/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.entity;

import doggytalents.DoggyTalentsMod;
import doggytalents.ModBlocks;
import doggytalents.ModEntities;
import doggytalents.ModItems;
import doggytalents.ModSerializers;
import doggytalents.ModTalents;
import doggytalents.api.DoggyTalentsAPI;
import doggytalents.api.inferface.IDogInteractItem;
import doggytalents.api.inferface.Talent;
import doggytalents.configuration.ConfigHandler;
import doggytalents.entity.ai.DogLocationManager;
import doggytalents.entity.ai.EntityAIBegDog;
import doggytalents.entity.ai.EntityAIDogFeed;
import doggytalents.entity.ai.EntityAIDogWander;
import doggytalents.entity.ai.EntityAIFetch;
import doggytalents.entity.ai.EntityAIFetchReturn;
import doggytalents.entity.ai.EntityAIFollowOwnerDog;
import doggytalents.entity.ai.EntityAIOwnerHurtByTargetDog;
import doggytalents.entity.ai.EntityAIOwnerHurtTargetDog;
import doggytalents.entity.ai.EntityAIOwnerTool;
import doggytalents.entity.ai.EntityAIShepherdDog;
import doggytalents.entity.ai.EntityBerserkerMode;
import doggytalents.entity.features.CoordFeature;
import doggytalents.entity.features.DogFeature;
import doggytalents.entity.features.DogGenderFeature;
import doggytalents.entity.features.LevelFeature;
import doggytalents.entity.features.ModeFeature;
import doggytalents.entity.features.TalentFeature;
import doggytalents.helper.DogUtil;
import doggytalents.helper.TalentHelper;
import doggytalents.inventory.InventoryTreatBag;
import doggytalents.item.ItemChewStick;
import doggytalents.item.ItemFancyCollar;
import doggytalents.lib.Constants;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAISit;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.Particles;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.particles.IParticleData;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IInteractionObject;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.fml.network.NetworkHooks;

public class EntityDog
extends EntityTameable
implements IInteractionObject {
    private static final DataParameter<Float> DATA_HEALTH_ID = EntityDataManager.func_187226_a(EntityDog.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Boolean> BEGGING = EntityDataManager.func_187226_a(EntityDog.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Byte> DOG_TEXTURE = EntityDataManager.func_187226_a(EntityDog.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Integer> COLLAR_COLOUR = EntityDataManager.func_187226_a(EntityDog.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> LEVEL = EntityDataManager.func_187226_a(EntityDog.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> LEVEL_DIRE = EntityDataManager.func_187226_a(EntityDog.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> MODE_PARAM = EntityDataManager.func_187226_a(EntityDog.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Map<Talent, Integer>> TALENTS_PARAM = EntityDataManager.func_187226_a(EntityDog.class, ModSerializers.TALENT_LEVEL_SERIALIZER.get());
    private static final DataParameter<Integer> HUNGER = EntityDataManager.func_187226_a(EntityDog.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> BONE = EntityDataManager.func_187226_a(EntityDog.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> FRIENDLY_FIRE = EntityDataManager.func_187226_a(EntityDog.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> OBEY_OTHERS = EntityDataManager.func_187226_a(EntityDog.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> CAPE = EntityDataManager.func_187226_a(EntityDog.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> SUNGLASSES = EntityDataManager.func_187226_a(EntityDog.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> RADAR_COLLAR = EntityDataManager.func_187226_a(EntityDog.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Optional<BlockPos>> BOWL_POS = EntityDataManager.func_187226_a(EntityDog.class, (DataSerializer)DataSerializers.field_187201_k);
    private static final DataParameter<Optional<BlockPos>> BED_POS = EntityDataManager.func_187226_a(EntityDog.class, (DataSerializer)DataSerializers.field_187201_k);
    private static final DataParameter<Integer> SIZE = EntityDataManager.func_187226_a(EntityDog.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<String> GENDER_PARAM = EntityDataManager.func_187226_a(EntityDog.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<Optional<ITextComponent>> LAST_KNOWN_NAME = EntityDataManager.func_187226_a(EntityDog.class, (DataSerializer)DataSerializers.field_200544_f);
    public DogLocationManager locationManager;
    public TalentFeature TALENTS = new TalentFeature(this);
    public LevelFeature LEVELS = new LevelFeature(this);
    public ModeFeature MODE = new ModeFeature(this);
    public CoordFeature COORDS = new CoordFeature(this);
    public DogGenderFeature GENDER = new DogGenderFeature(this);
    private List<DogFeature> FEATURES = Arrays.asList(this.TALENTS, this.LEVELS, this.MODE, this.COORDS);
    public Map<String, Object> objects;
    private float headRotationCourse;
    private float headRotationCourseOld;
    public boolean isWet;
    private boolean isShaking;
    private float timeWolfIsShaking;
    private float prevTimeWolfIsShaking;
    private float timeWolfIsHappy;
    private float prevTimeWolfIsHappy;
    private boolean isWolfHappy;
    public boolean hiyaMaster;
    private int hungerTick;
    private int prevHungerTick;
    private int healingTick;
    private int prevHealingTick;
    private int regenerationTick;
    private int prevRegenerationTick;
    private int foodBowlCheck;
    private int reversionTime;
    private int generalTick;
    protected boolean dogJumping;
    protected float jumpPower;

    public EntityDog(World worldIn) {
        super(ModEntities.DOG, worldIn);
        this.locationManager = DogLocationManager.getHandler(this.func_130014_f_());
        this.objects = new HashMap<String, Object>();
        this.func_70105_a(0.6f, 0.85f);
        this.func_70903_f(false);
        TalentHelper.onClassCreation(this);
    }

    protected void func_184651_r() {
        this.field_70911_d = new EntityAISit((EntityTameable)this);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.field_70911_d);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIFetchReturn(this, 1.0));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIDogWander(this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.4f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIShepherdDog(this, 1.0, 8.0f, entity -> !(entity instanceof EntityDog)));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIFetch(this, 1.0, 32.0f));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIOwnerTool(this, 1.0, 1.0f, 5.0f));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIFollowOwnerDog(this, 1.0, 10.0f, 2.0f));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 1.0));
        this.field_70714_bg.func_75776_a(12, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(13, (EntityAIBase)new EntityAIBegDog(this, 8.0f));
        this.field_70714_bg.func_75776_a(14, (EntityAIBase)new EntityAIDogFeed(this, 1.0, 20.0f));
        this.field_70714_bg.func_75776_a(15, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(15, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIOwnerHurtByTargetDog(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIOwnerHurtTargetDog(this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(4, new EntityBerserkerMode<EntityMob>(this, EntityMob.class, false));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DATA_HEALTH_ID, (Object)Float.valueOf(this.func_110143_aJ()));
        this.field_70180_af.func_187214_a(BEGGING, (Object)false);
        this.field_70180_af.func_187214_a(DOG_TEXTURE, (Object)0);
        this.field_70180_af.func_187214_a(COLLAR_COLOUR, (Object)-2);
        this.field_70180_af.func_187214_a(TALENTS_PARAM, Collections.emptyMap());
        this.field_70180_af.func_187214_a(HUNGER, (Object)60);
        this.field_70180_af.func_187214_a(OBEY_OTHERS, (Object)false);
        this.field_70180_af.func_187214_a(FRIENDLY_FIRE, (Object)false);
        this.field_70180_af.func_187214_a(BONE, (Object)-1);
        this.field_70180_af.func_187214_a(RADAR_COLLAR, (Object)false);
        this.field_70180_af.func_187214_a(MODE_PARAM, (Object)0);
        this.field_70180_af.func_187214_a(LEVEL, (Object)0);
        this.field_70180_af.func_187214_a(LEVEL_DIRE, (Object)0);
        this.field_70180_af.func_187214_a(BOWL_POS, Optional.empty());
        this.field_70180_af.func_187214_a(BED_POS, Optional.empty());
        this.field_70180_af.func_187214_a(CAPE, (Object)-2);
        this.field_70180_af.func_187214_a(SUNGLASSES, (Object)false);
        this.field_70180_af.func_187214_a(SIZE, (Object)3);
        this.field_70180_af.func_187214_a(GENDER_PARAM, (Object)(this.getRandom().nextInt(2) == 0 ? "male" : "female"));
        this.field_70180_af.func_187214_a(LAST_KNOWN_NAME, Optional.empty());
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        if (SIZE.equals(key)) {
            switch (this.getDogSize()) {
                case 1: {
                    this.func_98055_j(0.5f);
                    break;
                }
                case 2: {
                    this.func_98055_j(0.7f);
                    break;
                }
                case 3: {
                    this.func_98055_j(1.0f);
                    break;
                }
                case 4: {
                    this.func_98055_j(1.3f);
                    break;
                }
                case 5: {
                    this.func_98055_j(1.6f);
                }
            }
        }
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        this.field_70180_af.func_187227_b(DATA_HEALTH_ID, (Object)Float.valueOf(this.func_110143_aJ()));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.3f);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(this.func_70909_n() ? 20.0 : 8.0);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0);
    }

    protected SoundEvent func_184639_G() {
        if (this.getDogHunger() <= Constants.LOW_HUNGER && ConfigHandler.COMMON.whineWhenHungerLow()) {
            return SoundEvents.field_187871_gL;
        }
        if (this.field_70146_Z.nextInt(3) == 0) {
            return this.func_70909_n() && ((Float)this.field_70180_af.func_187225_a(DATA_HEALTH_ID)).floatValue() < this.func_110138_aP() / 2.0f ? SoundEvents.field_187871_gL : SoundEvents.field_187865_gI;
        }
        return SoundEvents.field_187857_gE;
    }

    protected void func_180429_a(BlockPos pos, IBlockState blockIn) {
        this.func_184185_a(SoundEvents.field_187869_gK, 0.15f, 1.0f);
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187863_gH;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187859_gF;
    }

    public float func_70599_aP() {
        return 0.4f;
    }

    protected ResourceLocation func_184647_J() {
        return null;
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        this.FEATURES.stream().forEach(f -> f.writeAdditional(compound));
        compound.func_74768_a("doggyTex", this.getTameSkin());
        compound.func_74768_a("collarColour", this.getCollarData());
        compound.func_74768_a("dogHunger", this.getDogHunger());
        compound.func_74757_a("willObey", this.willObeyOthers());
        compound.func_74757_a("friendlyFire", this.canFriendlyFire());
        compound.func_74757_a("radioCollar", this.hasRadarCollar());
        compound.func_74757_a("sunglasses", this.hasSunglasses());
        compound.func_74768_a("capeData", this.getCapeData());
        compound.func_74768_a("dogSize", this.getDogSize());
        if (this.getGender().equals("male") || this.getGender().equals("female")) {
            compound.func_74778_a("dogGender", this.getGender());
        }
        compound.func_74757_a("hasBone", this.hasBone());
        if (this.hasBone()) {
            compound.func_74768_a("boneVariant", this.getBoneVariant());
        }
        if (((Optional)this.field_70180_af.func_187225_a(LAST_KNOWN_NAME)).isPresent()) {
            compound.func_74778_a("lastKnownOwnerName", ITextComponent.Serializer.func_150696_a((ITextComponent)((ITextComponent)((Optional)this.field_70180_af.func_187225_a(LAST_KNOWN_NAME)).get())));
        }
        TalentHelper.writeAdditional(this, compound);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.FEATURES.stream().forEach(f -> f.readAdditional(compound));
        this.setTameSkin(compound.func_74762_e("doggyTex"));
        if (compound.func_150297_b("collarColour", 99)) {
            this.setCollarData(compound.func_74762_e("collarColour"));
        }
        this.setDogHunger(compound.func_74762_e("dogHunger"));
        this.setWillObeyOthers(compound.func_74767_n("willObey"));
        this.setFriendlyFire(compound.func_74767_n("friendlyFire"));
        this.hasRadarCollar(compound.func_74767_n("radioCollar"));
        this.setHasSunglasses(compound.func_74767_n("sunglasses"));
        if (compound.func_150297_b("capeData", 99)) {
            this.setCapeData(compound.func_74762_e("capeData"));
        }
        if (compound.func_150297_b("dogSize", 99)) {
            this.setDogSize(compound.func_74762_e("dogSize"));
        }
        if (compound.func_150297_b("dogGender", 8)) {
            this.setGender(compound.func_74779_i("dogGender"));
        } else if (ConfigHandler.COMMON.dogGender()) {
            this.setGender(this.field_70146_Z.nextInt(2) == 0 ? "male" : "female");
        }
        if (compound.func_74767_n("hasBone")) {
            this.setBoneVariant(compound.func_74762_e("boneVariant"));
        }
        if (compound.func_150297_b("lastKnownOwnerName", 8)) {
            this.field_70180_af.func_187227_b(LAST_KNOWN_NAME, Optional.of(ITextComponent.Serializer.func_150699_a((String)compound.func_74779_i("lastKnownOwnerName"))));
        }
        TalentHelper.readAdditional(this, compound);
        if (compound.func_74764_b("dogName")) {
            this.func_200203_b((ITextComponent)new TextComponentString(compound.func_74779_i("dogName")));
        }
    }

    public void func_70636_d() {
        Entity entityRidden;
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && this.isWet && !this.isShaking && !this.func_70781_l() && this.field_70122_E) {
            this.isShaking = true;
            this.timeWolfIsShaking = 0.0f;
            this.prevTimeWolfIsShaking = 0.0f;
            this.field_70170_p.func_72960_a((Entity)this, (byte)8);
        }
        if (ConfigHandler.COMMON.hungerOn()) {
            this.prevHungerTick = this.hungerTick++;
            if (this.func_184207_aI() || !this.func_70906_o()) {
                // empty if block
            }
            this.hungerTick += TalentHelper.hungerTick(this, this.hungerTick - this.prevHungerTick);
            if (this.hungerTick > 400) {
                this.setDogHunger(this.getDogHunger() - 1);
                this.hungerTick -= 400;
            }
        }
        if (ConfigHandler.COMMON.dogsImmortal()) {
            this.prevRegenerationTick = this.regenerationTick++;
            if (this.func_70906_o()) {
                this.regenerationTick += TalentHelper.regenerationTick(this, this.regenerationTick - this.prevRegenerationTick);
            } else if (!this.func_70906_o()) {
                this.regenerationTick = 0;
            }
            if (this.regenerationTick >= 2400 && this.isIncapacicated()) {
                this.func_70606_j(2.0f);
                this.setDogHunger(1);
            } else if (this.regenerationTick >= 2400 && !this.isIncapacicated() && this.regenerationTick >= 4400 && this.getDogHunger() < 60) {
                this.setDogHunger(this.getDogHunger() + 1);
                this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                this.regenerationTick = 2400;
            }
        }
        if (this.func_110143_aJ() != (float)Constants.LOW_HEATH_LEVEL) {
            this.prevHealingTick = this.healingTick;
            this.healingTick += this.nourishment();
            if (this.healingTick >= 6000) {
                if (this.func_110143_aJ() < this.func_110138_aP()) {
                    this.func_70606_j(this.func_110143_aJ() + 1.0f);
                }
                this.healingTick = 0;
            }
        }
        if (this.func_110143_aJ() <= 0.0f && this.isImmortal()) {
            this.field_70725_aQ = 0;
            this.func_70606_j(1.0f);
        }
        if (this.field_70170_p.field_72995_K && this.LEVELS.isDireDog() && ConfigHandler.CLIENT.direParticles()) {
            for (int i = 0; i < 2; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)Particles.field_197599_J, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O - 0.25, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, (this.field_70146_Z.nextDouble() - 0.5) * 2.0, -this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0);
            }
        }
        if (this.reversionTime > 0) {
            --this.reversionTime;
        }
        if ((entityRidden = this.func_184187_bx()) instanceof EntityPlayer && entityRidden.func_70093_af()) {
            this.func_184210_p();
        }
        if (this.foodBowlCheck++ > 50 && this.COORDS.hasBowlPos()) {
            if (this.field_70170_p.func_175667_e(this.COORDS.getBowlPos()) && this.field_70170_p.func_180495_p(this.COORDS.getBowlPos()).func_177230_c() != ModBlocks.FOOD_BOWL) {
                this.COORDS.resetBowlPosition();
            }
            this.foodBowlCheck = 0;
        }
        TalentHelper.livingTick(this);
    }

    public void func_70071_h_() {
        float distanceToOwner;
        EntityPlayer player;
        super.func_70071_h_();
        this.headRotationCourseOld = this.headRotationCourse;
        this.headRotationCourse = this.isBegging() ? (this.headRotationCourse += (1.0f - this.headRotationCourse) * 0.4f) : (this.headRotationCourse += (0.0f - this.headRotationCourse) * 0.4f);
        if (this.func_203008_ap()) {
            this.isWet = true;
            this.isShaking = false;
            this.timeWolfIsShaking = 0.0f;
            this.prevTimeWolfIsShaking = 0.0f;
        } else if ((this.isWet || this.isShaking) && this.isShaking) {
            if (this.timeWolfIsShaking == 0.0f) {
                this.func_184185_a(SoundEvents.field_187867_gJ, this.func_70599_aP(), (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            }
            this.prevTimeWolfIsShaking = this.timeWolfIsShaking;
            this.timeWolfIsShaking += 0.05f;
            if (this.prevTimeWolfIsShaking >= 2.0f) {
                this.isWet = false;
                this.isShaking = false;
                this.prevTimeWolfIsShaking = 0.0f;
                this.timeWolfIsShaking = 0.0f;
                this.onFinishShaking();
            }
            if (this.timeWolfIsShaking > 0.4f) {
                float f = (float)this.func_174813_aQ().field_72338_b;
                int i = (int)(MathHelper.func_76126_a((float)((this.timeWolfIsShaking - 0.4f) * (float)Math.PI)) * 7.0f);
                for (int j = 0; j < i; ++j) {
                    float f1 = (this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * this.field_70130_N * 0.5f;
                    float f2 = (this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * this.field_70130_N * 0.5f;
                    this.field_70170_p.func_195594_a((IParticleData)Particles.field_197606_Q, this.field_70165_t + (double)f1, (double)(f + 0.8f), this.field_70161_v + (double)f2, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                }
            }
        }
        if (this.field_70146_Z.nextInt(200) == 0) {
            this.hiyaMaster = true;
        }
        if ((this.isBegging() || this.hiyaMaster) && !this.isWolfHappy) {
            this.isWolfHappy = true;
            this.timeWolfIsHappy = 0.0f;
            this.prevTimeWolfIsHappy = 0.0f;
        } else {
            this.hiyaMaster = false;
        }
        if (this.isWolfHappy) {
            if (this.timeWolfIsHappy % 1.0f == 0.0f) {
                this.func_184185_a(SoundEvents.field_187865_gI, this.func_70599_aP(), (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            }
            this.prevTimeWolfIsHappy = this.timeWolfIsHappy;
            this.timeWolfIsHappy += 0.05f;
            if (this.prevTimeWolfIsHappy >= 8.0f) {
                this.isWolfHappy = false;
                this.prevTimeWolfIsHappy = 0.0f;
                this.timeWolfIsHappy = 0.0f;
            }
        }
        if (this.func_70909_n() && (player = (EntityPlayer)this.func_70902_q()) != null && (distanceToOwner = player.func_70032_d((Entity)this)) <= 2.0f && this.hasBone()) {
            if (!this.field_70170_p.field_72995_K) {
                ItemStack fetchItem = ItemStack.field_190927_a;
                switch (this.getBoneVariant()) {
                    case 0: {
                        fetchItem = new ItemStack((IItemProvider)ModItems.THROW_BONE_WET);
                        break;
                    }
                    case 1: {
                        fetchItem = new ItemStack((IItemProvider)ModItems.THROW_STICK_WET);
                    }
                }
                this.func_70099_a(fetchItem, 0.0f);
            }
            this.setNoFetchItem();
        }
        --this.generalTick;
        if (this.generalTick < 0) {
            if (!this.field_70170_p.field_72995_K) {
                if (this.func_70089_S()) {
                    if (ConfigHandler.COMMON.debugMode()) {
                        DoggyTalentsMod.LOGGER.debug("Update/Add Request From Living");
                    }
                    this.locationManager.update(this);
                } else {
                    if (ConfigHandler.COMMON.debugMode()) {
                        DoggyTalentsMod.LOGGER.debug("Remove Request From Living");
                    }
                    this.locationManager.remove(this);
                }
                if (this.func_70902_q() != null) {
                    this.field_70180_af.func_187227_b(LAST_KNOWN_NAME, Optional.ofNullable(this.func_70902_q().func_145748_c_()));
                }
            }
            this.generalTick = 40;
        }
        TalentHelper.tick(this);
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        ActionResult<ItemStack> result = TalentHelper.interactWithPlayer(this, player, stack);
        switch (result.func_188397_a()) {
            case SUCCESS: {
                return true;
            }
            case FAIL: {
                return false;
            }
        }
        if (stack.func_77973_b() == ModItems.OWNER_CHANGE && player.field_71075_bZ.field_75098_d && !this.func_152114_e((EntityLivingBase)player)) {
            if (!this.field_70170_p.field_72995_K) {
                this.func_70903_f(true);
                this.field_70699_by.func_75499_g();
                this.func_70624_b(null);
                this.field_70911_d.func_75270_a(true);
                this.func_184754_b(player.func_110124_au());
                this.func_70908_e(true);
                this.field_70170_p.func_72960_a((Entity)this, (byte)7);
            }
            return true;
        }
        if (this.func_70909_n()) {
            if (!stack.func_190926_b()) {
                int foodValue = this.foodValue(stack);
                if (foodValue != 0 && this.getDogHunger() < Constants.HUNGER_POINTS && this.canInteract(player) && !this.isIncapacicated()) {
                    if (!player.field_71075_bZ.field_75098_d) {
                        stack.func_190918_g(1);
                    }
                    this.setDogHunger(this.getDogHunger() + foodValue);
                    if (stack.func_77973_b() == ModItems.CHEW_STICK) {
                        ((ItemChewStick)ModItems.CHEW_STICK).addChewStickEffects(this);
                    }
                    return true;
                }
                if (stack.func_77973_b() == ModItems.DOGGY_CHARM && player.field_71075_bZ.field_75098_d) {
                    EntityDog babySpawn;
                    if (!this.field_70170_p.field_72995_K && (babySpawn = this.createChild((EntityAgeable)this)) != null) {
                        babySpawn.func_70873_a(-24000 * (ConfigHandler.COMMON.tenDayPups() ? 10 : 1));
                        babySpawn.func_70903_f(true);
                        if (ConfigHandler.COMMON.pupsGetParentLevels()) {
                            babySpawn.LEVELS.setLevel(Math.min(this.LEVELS.getLevel(), 20));
                        }
                        babySpawn.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0f, 0.0f);
                        this.field_70170_p.func_72838_d((Entity)babySpawn);
                        if (!player.field_71075_bZ.field_75098_d) {
                            stack.func_190918_g(1);
                        }
                    }
                    return true;
                }
                if (stack.func_77973_b() == Items.field_151055_y && this.canInteract(player)) {
                    if (this.isIncapacicated()) {
                        if (!this.field_70170_p.field_72995_K) {
                            player.func_145747_a((ITextComponent)new TextComponentTranslation("dog.mode.incapacitated.help", new Object[]{this.func_145748_c_()}));
                        }
                    } else if (player instanceof EntityPlayerMP && !(player instanceof FakePlayer)) {
                        EntityPlayerMP entityPlayerMP = (EntityPlayerMP)player;
                        NetworkHooks.openGui((EntityPlayerMP)entityPlayerMP, (IInteractionObject)this, buf -> buf.writeInt(this.func_145782_y()));
                    }
                    return true;
                }
                if (stack.func_77973_b() == ModItems.RADIO_COLLAR && this.canInteract(player) && !this.hasRadarCollar() && !this.isIncapacicated()) {
                    this.hasRadarCollar(true);
                    if (!player.field_71075_bZ.field_75098_d) {
                        stack.func_190918_g(1);
                    }
                    return true;
                }
                if (stack.func_77973_b() == ModItems.WOOL_COLLAR && this.canInteract(player) && !this.hasCollar() && !this.isIncapacicated()) {
                    int colour = -1;
                    if (stack.func_77942_o() && stack.func_77978_p().func_150297_b("collar_colour", 99)) {
                        colour = stack.func_77978_p().func_74762_e("collar_colour");
                    }
                    this.setCollarData(colour);
                    if (!player.field_71075_bZ.field_75098_d) {
                        stack.func_190918_g(1);
                    }
                    return true;
                }
                if (stack.func_77973_b() instanceof ItemFancyCollar && this.canInteract(player) && !this.hasCollar() && !this.isIncapacicated()) {
                    this.setCollarData(-3 - ((ItemFancyCollar)stack.func_77973_b()).type.ordinal());
                    if (!player.field_71075_bZ.field_75098_d) {
                        stack.func_190918_g(1);
                    }
                    return true;
                }
                if (stack.func_77973_b() == ModItems.CAPE && this.canInteract(player) && !this.hasCape() && !this.isIncapacicated()) {
                    this.setFancyCape();
                    if (!player.field_71075_bZ.field_75098_d) {
                        stack.func_190918_g(1);
                    }
                    return true;
                }
                if (stack.func_77973_b() == ModItems.LEATHER_JACKET && this.canInteract(player) && !this.hasCape() && !this.isIncapacicated()) {
                    this.setLeatherJacket();
                    if (!player.field_71075_bZ.field_75098_d) {
                        stack.func_190918_g(1);
                    }
                    return true;
                }
                if (stack.func_77973_b() == ModItems.CAPE_COLOURED && this.canInteract(player) && !this.hasCape() && !this.isIncapacicated()) {
                    int colour = -1;
                    if (stack.func_77942_o() && stack.func_77978_p().func_150297_b("cape_colour", 99)) {
                        colour = stack.func_77978_p().func_74762_e("cape_colour");
                    }
                    this.setCapeData(colour);
                    if (!player.field_71075_bZ.field_75098_d) {
                        stack.func_190918_g(1);
                    }
                    return true;
                }
                if (stack.func_77973_b() == ModItems.SUNGLASSES && this.canInteract(player) && !this.hasSunglasses() && !this.isIncapacicated()) {
                    this.setHasSunglasses(true);
                    if (!player.field_71075_bZ.field_75098_d) {
                        stack.func_190918_g(1);
                    }
                    return true;
                }
                if (stack.func_77973_b() instanceof IDogInteractItem && this.canInteract(player) && !this.isIncapacicated()) {
                    IDogInteractItem treat = (IDogInteractItem)stack.func_77973_b();
                    ActionResult<ItemStack> treatResult = treat.onItemRightClick(stack, this, this.field_70170_p, player);
                    switch (treatResult.func_188397_a()) {
                        case SUCCESS: {
                            return true;
                        }
                        case FAIL: {
                            return false;
                        }
                    }
                } else {
                    if (stack.func_77973_b() == ModItems.COLLAR_SHEARS && this.canInteract(player)) {
                        if (!this.field_70170_p.field_72995_K) {
                            if (this.hasCollar() || this.hasSunglasses() || this.hasCape()) {
                                this.reversionTime = 40;
                                if (this.hasCollarColoured()) {
                                    ItemStack collarDrop = new ItemStack((IItemProvider)ModItems.WOOL_COLLAR, 1);
                                    if (this.isCollarColoured()) {
                                        collarDrop.func_77982_d(new NBTTagCompound());
                                        collarDrop.func_77978_p().func_74768_a("collar_colour", this.getCollarData());
                                    }
                                    this.func_70099_a(collarDrop, 1.0f);
                                    this.setNoCollar();
                                }
                                if (this.hasFancyCollar()) {
                                    Item drop = ModItems.MULTICOLOURED_COLLAR;
                                    if (this.getCollarData() == -3) {
                                        drop = ModItems.CREATIVE_COLLAR;
                                    } else if (this.getCollarData() == -4) {
                                        drop = ModItems.SPOTTED_COLLAR;
                                    }
                                    this.func_199702_a((IItemProvider)drop, 1);
                                    this.setNoCollar();
                                }
                                if (this.hasFancyCape()) {
                                    this.func_70099_a(new ItemStack((IItemProvider)ModItems.CAPE, 1), 1.0f);
                                    this.setNoCape();
                                }
                                if (this.hasCapeColoured()) {
                                    ItemStack capeDrop = new ItemStack((IItemProvider)ModItems.CAPE_COLOURED, 1);
                                    if (this.isCapeColoured()) {
                                        capeDrop.func_77982_d(new NBTTagCompound());
                                        capeDrop.func_77978_p().func_74768_a("cape_colour", this.getCapeData());
                                    }
                                    this.func_70099_a(capeDrop, 1.0f);
                                    this.setNoCape();
                                }
                                if (this.hasLeatherJacket()) {
                                    this.func_70099_a(new ItemStack((IItemProvider)ModItems.LEATHER_JACKET, 1), 1.0f);
                                    this.setNoCape();
                                }
                                if (this.hasSunglasses()) {
                                    this.func_70099_a(new ItemStack((IItemProvider)ModItems.SUNGLASSES, 1), 1.0f);
                                    this.setHasSunglasses(false);
                                }
                            } else if (this.reversionTime < 1) {
                                this.func_70903_f(false);
                                this.field_70699_by.func_75499_g();
                                this.field_70911_d.func_75270_a(false);
                                this.func_70606_j(8.0f);
                                this.TALENTS.resetTalents();
                                this.func_184754_b(UUID.randomUUID());
                                this.setWillObeyOthers(false);
                                this.MODE.setMode(ModeFeature.EnumMode.DOCILE);
                                if (this.hasRadarCollar()) {
                                    this.func_199703_a((IItemProvider)ModItems.RADIO_COLLAR);
                                }
                                this.hasRadarCollar(false);
                                this.reversionTime = 40;
                            }
                        }
                        return true;
                    }
                    if (stack.func_77973_b() == Blocks.field_150414_aQ.func_199767_j() && this.canInteract(player) && this.isIncapacicated()) {
                        if (!player.field_71075_bZ.field_75098_d) {
                            stack.func_190918_g(1);
                        }
                        if (!this.field_70170_p.field_72995_K) {
                            this.field_70911_d.func_75270_a(true);
                            this.func_70606_j(this.func_110138_aP());
                            this.setDogHunger(Constants.HUNGER_POINTS);
                            this.regenerationTick = 0;
                            this.func_70624_b(null);
                            this.func_70908_e(true);
                            this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                        }
                        return true;
                    }
                    if (stack.func_77973_b().func_206844_a(Tags.Items.DYES) && this.canInteract(player) && this.hasCollarColoured()) {
                        if (!this.field_70170_p.field_72995_K) {
                            int[] aint = new int[3];
                            int maxCompSum = 0;
                            int count = 1;
                            EnumDyeColor colour = EnumDyeColor.getColor((ItemStack)stack);
                            if (colour == null) {
                                return false;
                            }
                            float[] afloat = colour.func_193349_f();
                            int l1 = (int)(afloat[0] * 255.0f);
                            int i2 = (int)(afloat[1] * 255.0f);
                            int j2 = (int)(afloat[2] * 255.0f);
                            maxCompSum += Math.max(l1, Math.max(i2, j2));
                            aint[0] = aint[0] + l1;
                            aint[1] = aint[1] + i2;
                            aint[2] = aint[2] + j2;
                            if (this.isCollarColoured()) {
                                int l = this.getCollarData();
                                float f = (float)(l >> 16 & 0xFF) / 255.0f;
                                float f1 = (float)(l >> 8 & 0xFF) / 255.0f;
                                float f2 = (float)(l & 0xFF) / 255.0f;
                                maxCompSum = (int)((float)maxCompSum + Math.max(f, Math.max(f1, f2)) * 255.0f);
                                aint[0] = (int)((float)aint[0] + f * 255.0f);
                                aint[1] = (int)((float)aint[1] + f1 * 255.0f);
                                aint[2] = (int)((float)aint[2] + f2 * 255.0f);
                                ++count;
                            }
                            int i1 = aint[0] / count;
                            int j1 = aint[1] / count;
                            int k1 = aint[2] / count;
                            float f3 = (float)maxCompSum / (float)count;
                            float f4 = Math.max(i1, Math.max(j1, k1));
                            i1 = (int)((float)i1 * f3 / f4);
                            j1 = (int)((float)j1 * f3 / f4);
                            k1 = (int)((float)k1 * f3 / f4);
                            int k2 = (i1 << 8) + j1;
                            k2 = (k2 << 8) + k1;
                            this.setCollarData(k2);
                        }
                        return true;
                    }
                    if (stack.func_77973_b() == ModItems.TREAT_BAG && this.getDogHunger() < Constants.HUNGER_POINTS && this.canInteract(player)) {
                        InventoryTreatBag treatBag = new InventoryTreatBag(player, player.field_71071_by.field_70461_c, stack);
                        treatBag.func_174889_b(player);
                        int slotIndex = DogUtil.getFirstSlotWithFood(this, (IInventory)treatBag);
                        if (slotIndex >= 0) {
                            DogUtil.feedDog(this, (IInventory)treatBag, slotIndex);
                        }
                        treatBag.func_174886_c(player);
                        return true;
                    }
                }
            }
            if (!this.func_70877_b(stack) && this.canInteract(player)) {
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70911_d.func_75270_a(!this.func_70906_o());
                    this.field_70703_bu = false;
                    this.field_70699_by.func_75499_g();
                    this.func_70624_b(null);
                }
                return true;
            }
        } else {
            if (stack.func_77973_b() == ModItems.COLLAR_SHEARS && this.reversionTime < 1) {
                if (!this.field_70170_p.field_72995_K) {
                    this.locationManager.remove(this);
                    this.func_70106_y();
                    EntityWolf wolf = new EntityWolf(this.field_70170_p);
                    wolf.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
                    this.field_70170_p.func_72838_d((Entity)wolf);
                }
                return true;
            }
            if (stack.func_77973_b() == Items.field_151103_aS) {
                if (!player.field_71075_bZ.field_75098_d) {
                    stack.func_190918_g(1);
                }
                if (!this.field_70170_p.field_72995_K) {
                    if (this.field_70146_Z.nextInt(3) == 0) {
                        this.func_70903_f(true);
                        this.field_70699_by.func_75499_g();
                        this.func_70624_b(null);
                        this.field_70911_d.func_75270_a(true);
                        this.func_70606_j(20.0f);
                        this.func_184754_b(player.func_110124_au());
                        this.func_70908_e(true);
                        this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                    } else {
                        this.func_70908_e(false);
                        this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                    }
                }
                return true;
            }
        }
        return super.func_184645_a(player, hand);
    }

    public EntityDog createChild(EntityAgeable entityAgeable) {
        EntityDog entitydog = new EntityDog(this.field_70170_p);
        UUID uuid = this.func_184753_b();
        if (uuid != null) {
            entitydog.func_184754_b(uuid);
            entitydog.func_70903_f(true);
        }
        entitydog.func_70873_a(-24000 * (ConfigHandler.COMMON.tenDayPups() ? 10 : 1));
        if (ConfigHandler.COMMON.pupsGetParentLevels() && entityAgeable instanceof EntityDog) {
            int combinedLevel = this.LEVELS.getLevel() + ((EntityDog)entityAgeable).LEVELS.getLevel();
            combinedLevel /= 2;
            combinedLevel = Math.min(combinedLevel, 20);
            entitydog.LEVELS.setLevel(combinedLevel);
        }
        return entitydog;
    }

    public boolean func_70877_b(ItemStack stack) {
        return DoggyTalentsAPI.BREED_WHITELIST.containsItem(stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_94059_bO() {
        return this.func_145818_k_();
    }

    public void func_70908_e(boolean successful) {
        super.func_70908_e(successful);
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        if (!TalentHelper.isImmuneToFalls(this)) {
            super.func_180430_e(distance - (float)TalentHelper.fallProtection(this), damageMultiplier);
        }
    }

    public boolean func_70097_a(DamageSource damageSource, float damage) {
        if (this.func_180431_b(damageSource)) {
            return false;
        }
        Entity entity = damageSource.func_76346_g();
        if (!this.canFriendlyFire() && entity instanceof EntityPlayer && (this.willObeyOthers() || this.func_152114_e((EntityLivingBase)((EntityPlayer)entity)))) {
            return false;
        }
        if (!TalentHelper.attackEntityFrom(this, damageSource, damage)) {
            return false;
        }
        if (this.field_70911_d != null) {
            this.field_70911_d.func_75270_a(false);
        }
        if (entity != null && !(entity instanceof EntityPlayer) && !(entity instanceof EntityArrow)) {
            damage = (damage + 1.0f) / 2.0f;
        }
        return super.func_70097_a(damageSource, damage);
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag;
        if (!TalentHelper.shouldDamageMob(this, entityIn)) {
            return false;
        }
        int damage = 4 + (MathHelper.func_76128_c((double)this.effectiveLevel()) + 1) / 2;
        damage = TalentHelper.attackEntityAsMob(this, entityIn, damage);
        if (entityIn instanceof EntityZombie) {
            ((EntityZombie)entityIn).func_70624_b((EntityLivingBase)this);
        }
        if (flag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)damage)) {
            this.func_174815_a((EntityLivingBase)this, entityIn);
        }
        return flag;
    }

    public void func_70903_f(boolean tamed) {
        super.func_70903_f(tamed);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(tamed ? 20.0 : 8.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 8) {
            this.isShaking = true;
            this.timeWolfIsShaking = 0.0f;
            this.prevTimeWolfIsShaking = 0.0f;
        } else {
            super.func_70103_a(id);
        }
    }

    public void func_70645_a(DamageSource cause) {
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_82736_K().func_82766_b("showDeathMessages") && !this.isImmortal() && this.func_70902_q() instanceof EntityPlayerMP) {
            DoggyTalentsMod.LOGGER.debug("From onDeath");
            this.locationManager.remove(this);
            this.func_70902_q().func_145747_a(this.func_110142_aN().func_151521_b());
        }
    }

    public boolean func_70687_e(PotionEffect potioneffectIn) {
        if (this.isIncapacicated()) {
            return false;
        }
        if (!TalentHelper.isPostionApplicable(this, potioneffectIn)) {
            return false;
        }
        return super.func_70687_e(potioneffectIn);
    }

    public void func_70015_d(int amount) {
        if (TalentHelper.setFire(this, amount)) {
            super.func_70015_d(amount);
        }
    }

    public boolean func_70648_aU() {
        return TalentHelper.canBreatheUnderwater(this);
    }

    protected boolean func_70041_e_() {
        return TalentHelper.canTriggerWalking(this);
    }

    public boolean func_142018_a(EntityLivingBase target, EntityLivingBase owner) {
        if (TalentHelper.canAttackEntity(this, (Entity)target)) {
            return true;
        }
        if (!(target instanceof EntityCreeper) && !(target instanceof EntityGhast)) {
            EntityWolf entitywolf;
            EntityDog entitydog;
            if (target instanceof EntityDog ? (entitydog = (EntityDog)target).func_70909_n() && entitydog.func_70902_q() == owner : target instanceof EntityWolf && (entitywolf = (EntityWolf)target).func_70909_n() && entitywolf.func_70902_q() == owner) {
                return false;
            }
            if (target instanceof EntityPlayer && owner instanceof EntityPlayer && !((EntityPlayer)owner).func_96122_a((EntityPlayer)target)) {
                return false;
            }
            if (target == owner) {
                return false;
            }
            return !(target instanceof AbstractHorse) || !((AbstractHorse)target).func_110248_bS();
        }
        return false;
    }

    public boolean func_70686_a(Class<? extends EntityLivingBase> cls) {
        if (TalentHelper.canAttackClass(this, cls)) {
            return true;
        }
        return super.func_70686_a(cls);
    }

    public Entity changeDimension(DimensionType dimType, ITeleporter teleporter) {
        Entity entity = super.changeDimension(dimType, teleporter);
        if (entity instanceof EntityDog) {
            EntityDog dog = (EntityDog)entity;
            if (!this.field_70170_p.field_72995_K) {
                dog.locationManager.update(dog);
                this.locationManager.remove(this);
            }
        } else if (entity != null) {
            DoggyTalentsMod.LOGGER.warn("Dog tried to change dimension but now isn't a dog?");
        }
        return entity;
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        if (!this.field_70170_p.field_72995_K) {
            this.locationManager.update(this);
        }
    }

    public void onRemovedFromWorld() {
        super.onRemovedFromWorld();
        if (!this.field_70170_p.field_72995_K && !this.func_70089_S()) {
            this.locationManager.remove(this);
        }
    }

    protected float func_175134_bD() {
        return 0.42f;
    }

    public boolean func_70692_ba() {
        return false;
    }

    protected float func_189749_co() {
        return 0.8f;
    }

    protected void onFinishShaking() {
        if (!this.field_70170_p.field_72995_K) {
            int lvlFisherDog = this.TALENTS.getLevel(ModTalents.FISHER_DOG);
            int lvlHellHound = this.TALENTS.getLevel(ModTalents.HELL_HOUND);
            if (this.field_70146_Z.nextInt(15) < lvlFisherDog * 2) {
                this.func_199703_a((IItemProvider)(this.field_70146_Z.nextInt(15) < lvlHellHound * 2 ? Items.field_196102_ba : Items.field_196086_aW));
            }
        }
    }

    public boolean func_70878_b(EntityAnimal otherAnimal) {
        if (otherAnimal == this) {
            return false;
        }
        if (!this.func_70909_n()) {
            return false;
        }
        if (!(otherAnimal instanceof EntityDog)) {
            return false;
        }
        EntityDog entitydog = (EntityDog)otherAnimal;
        if (!entitydog.func_70909_n()) {
            return false;
        }
        if (entitydog.func_70906_o()) {
            return false;
        }
        if (this.getGender().equals(entitydog.getGender())) {
            return false;
        }
        return this.func_70880_s() && entitydog.func_70880_s();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isDogWet() {
        return this.isWet;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getShadingWhileWet(float p_70915_1_) {
        return 0.75f + (this.prevTimeWolfIsShaking + (this.timeWolfIsShaking - this.prevTimeWolfIsShaking) * p_70915_1_) / 2.0f * 0.25f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getShakeAngle(float partialTick, float offset) {
        float f = (this.prevTimeWolfIsShaking + (this.timeWolfIsShaking - this.prevTimeWolfIsShaking) * partialTick + offset) / 1.8f;
        if (f < 0.0f) {
            f = 0.0f;
        } else if (f > 1.0f) {
            f = 1.0f;
        }
        return MathHelper.func_76126_a((float)(f * (float)Math.PI)) * MathHelper.func_76126_a((float)(f * (float)Math.PI * 11.0f)) * 0.15f * (float)Math.PI;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getInterestedAngle(float p_70917_1_) {
        return (this.headRotationCourseOld + (this.headRotationCourse - this.headRotationCourseOld) * p_70917_1_) * 0.15f * (float)Math.PI;
    }

    public float getWagAngle(float partialTick, float offset) {
        float f = (this.prevTimeWolfIsHappy + (this.timeWolfIsHappy - this.prevTimeWolfIsHappy) * partialTick + offset) / 2.0f;
        if (f < 0.0f) {
            f = 0.0f;
        } else if (f > 2.0f) {
            f %= 2.0f;
        }
        return MathHelper.func_76126_a((float)(f * (float)Math.PI * 11.0f)) * 0.3f * (float)Math.PI;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getTailRotation() {
        return this.func_70909_n() ? (0.55f - (this.func_110138_aP() - ((Float)this.field_70180_af.func_187225_a(DATA_HEALTH_ID)).floatValue()) / this.func_110138_aP() * 20.0f * 0.02f) * (float)Math.PI : 0.62831855f;
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.8f;
    }

    public int func_70646_bf() {
        return this.func_70906_o() ? 20 : super.func_70646_bf();
    }

    public boolean isImmortal() {
        return this.func_70909_n() && ConfigHandler.COMMON.dogsImmortal() || this.LEVELS.isDireDog();
    }

    public boolean isIncapacicated() {
        return this.isImmortal() && this.func_110143_aJ() <= (float)Constants.LOW_HEATH_LEVEL;
    }

    public double effectiveLevel() {
        return (double)(this.LEVELS.getLevel() + this.LEVELS.getDireLevel()) / 10.0;
    }

    public double getHealthRelative() {
        return (double)this.func_110143_aJ() / (double)this.func_110138_aP();
    }

    public boolean canWander() {
        return this.MODE.isMode(ModeFeature.EnumMode.WANDERING) && this.COORDS.hasBowlPos() && this.func_174818_b(this.COORDS.getBowlPos()) < 256.0;
    }

    public boolean canInteract(EntityPlayer player) {
        return this.func_152114_e((EntityLivingBase)player) || this.willObeyOthers();
    }

    public int foodValue(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0;
        }
        int foodValue = 0;
        Item item = stack.func_77973_b();
        if (stack.func_77973_b() != Items.field_151078_bh && item instanceof ItemFood) {
            ItemFood itemfood = (ItemFood)item;
            if (itemfood.func_77845_h()) {
                foodValue = 40;
            }
        } else if (stack.func_77973_b() == ModItems.CHEW_STICK) {
            return 10;
        }
        foodValue = TalentHelper.changeFoodValue(this, stack, foodValue);
        return foodValue;
    }

    public int nourishment() {
        int amount = 0;
        if (this.getDogHunger() > 0) {
            amount = 40 + 4 * (MathHelper.func_76128_c((double)this.effectiveLevel()) + 1);
            if (this.func_70906_o() && this.TALENTS.getLevel(ModTalents.QUICK_HEALER) == 5) {
                amount += 20 + 2 * (MathHelper.func_76128_c((double)this.effectiveLevel()) + 1);
            }
            if (!this.func_70906_o()) {
                amount *= 5 + this.TALENTS.getLevel(ModTalents.QUICK_HEALER);
                amount /= 10;
            }
        }
        return amount;
    }

    public void mountTo(EntityLivingBase entityLiving) {
        entityLiving.field_70177_z = this.field_70177_z;
        entityLiving.field_70125_A = this.field_70125_A;
        if (!this.field_70170_p.field_72995_K) {
            entityLiving.func_184220_m((Entity)this);
        }
    }

    public int points() {
        return this.isCreativeCollar() ? 1000 : this.LEVELS.getLevel() + this.LEVELS.getDireLevel() + (this.LEVELS.isDireDog() ? 15 : 0) + (this.func_70874_b() < 0 ? 0 : 15);
    }

    public int spendablePoints() {
        return this.points() - this.usedPoints();
    }

    public int usedPoints() {
        return TalentHelper.getUsedPoints(this);
    }

    public int deductive(int id) {
        if (id >= 1 && id <= 5) {
            return (new int[]{1, 3, 6, 10, 15})[id - 1];
        }
        return 0;
    }

    public ITextComponent getOwnersName() {
        if (this.func_70902_q() != null) {
            return this.func_70902_q().func_145748_c_();
        }
        if (((Optional)this.field_70180_af.func_187225_a(LAST_KNOWN_NAME)).isPresent()) {
            return (ITextComponent)((Optional)this.field_70180_af.func_187225_a(LAST_KNOWN_NAME)).get();
        }
        if (this.func_184753_b() != null) {
            return new TextComponentString(this.func_184753_b().toString());
        }
        return new TextComponentString("dog.owner.unknown");
    }

    public void setBegging(boolean flag) {
        this.field_70180_af.func_187227_b(BEGGING, (Object)flag);
    }

    public boolean isBegging() {
        return (Boolean)this.field_70180_af.func_187225_a(BEGGING);
    }

    public int getTameSkin() {
        return ((Byte)this.field_70180_af.func_187225_a(DOG_TEXTURE)).byteValue();
    }

    public void setTameSkin(int index) {
        this.field_70180_af.func_187227_b(DOG_TEXTURE, (Object)((byte)index));
    }

    public void setWillObeyOthers(boolean flag) {
        this.field_70180_af.func_187227_b(OBEY_OTHERS, (Object)flag);
    }

    public boolean willObeyOthers() {
        return (Boolean)this.field_70180_af.func_187225_a(OBEY_OTHERS);
    }

    public void setFriendlyFire(boolean flag) {
        this.field_70180_af.func_187227_b(FRIENDLY_FIRE, (Object)flag);
    }

    public boolean canFriendlyFire() {
        return (Boolean)this.field_70180_af.func_187225_a(FRIENDLY_FIRE);
    }

    public int getDogHunger() {
        return (Integer)this.field_70180_af.func_187225_a(HUNGER);
    }

    public void setDogHunger(int par1) {
        this.field_70180_af.func_187227_b(HUNGER, (Object)Math.min(Constants.HUNGER_POINTS, Math.max(0, par1)));
    }

    public void hasRadarCollar(boolean flag) {
        this.field_70180_af.func_187227_b(RADAR_COLLAR, (Object)flag);
    }

    public boolean hasRadarCollar() {
        return (Boolean)this.field_70180_af.func_187225_a(RADAR_COLLAR);
    }

    public void setNoFetchItem() {
        this.field_70180_af.func_187227_b(BONE, (Object)-1);
    }

    public void setBoneVariant(int value) {
        this.field_70180_af.func_187227_b(BONE, (Object)value);
    }

    public int getBoneVariant() {
        return (Integer)this.field_70180_af.func_187225_a(BONE);
    }

    public boolean hasBone() {
        return this.getBoneVariant() >= 0;
    }

    public void setHasSunglasses(boolean hasSunglasses) {
        this.field_70180_af.func_187227_b(SUNGLASSES, (Object)hasSunglasses);
    }

    public boolean hasSunglasses() {
        return (Boolean)this.field_70180_af.func_187225_a(SUNGLASSES);
    }

    public int getCollarData() {
        return (Integer)this.field_70180_af.func_187225_a(COLLAR_COLOUR);
    }

    public void setCollarData(int value) {
        this.field_70180_af.func_187227_b(COLLAR_COLOUR, (Object)value);
    }

    public int getCapeData() {
        return (Integer)this.field_70180_af.func_187225_a(CAPE);
    }

    public void setCapeData(int value) {
        this.field_70180_af.func_187227_b(CAPE, (Object)value);
    }

    public void setDogSize(int value) {
        this.field_70180_af.func_187227_b(SIZE, (Object)Math.min(5, Math.max(1, value)));
    }

    public int getDogSize() {
        return (Integer)this.field_70180_af.func_187225_a(SIZE);
    }

    public void setGender(String data) {
        this.field_70180_af.func_187227_b(GENDER_PARAM, (Object)data);
    }

    public String getGender() {
        return (String)this.field_70180_af.func_187225_a(GENDER_PARAM);
    }

    public void setLevel(int level) {
        this.field_70180_af.func_187227_b(LEVEL, (Object)level);
    }

    public int getLevel() {
        return (Integer)this.field_70180_af.func_187225_a(LEVEL);
    }

    public void setDireLevel(int level) {
        this.field_70180_af.func_187227_b(LEVEL_DIRE, (Object)level);
    }

    public int getDireLevel() {
        return (Integer)this.field_70180_af.func_187225_a(LEVEL_DIRE);
    }

    public void setModeId(int mode) {
        this.field_70180_af.func_187227_b(MODE_PARAM, (Object)Math.min(mode, ModeFeature.EnumMode.values().length - 1));
    }

    public int getModeId() {
        return (Integer)this.field_70180_af.func_187225_a(MODE_PARAM);
    }

    public void setTalentMap(Map<Talent, Integer> data) {
        this.field_70180_af.func_187227_b(TALENTS_PARAM, data);
    }

    public Map<Talent, Integer> getTalentMap() {
        return (Map)this.field_70180_af.func_187225_a(TALENTS_PARAM);
    }

    public boolean hasBedPos() {
        return ((Optional)this.field_70180_af.func_187225_a(BED_POS)).isPresent();
    }

    public boolean hasBowlPos() {
        return ((Optional)this.field_70180_af.func_187225_a(BOWL_POS)).isPresent();
    }

    public BlockPos getBedPos() {
        return ((Optional)this.field_70180_af.func_187225_a(BED_POS)).orElse(this.field_70170_p.func_175694_M());
    }

    public BlockPos getBowlPos() {
        return ((Optional)this.field_70180_af.func_187225_a(BOWL_POS)).orElse(this.func_180425_c());
    }

    public void resetBedPosition() {
        this.field_70180_af.func_187227_b(BED_POS, Optional.empty());
    }

    public void resetBowlPosition() {
        this.field_70180_af.func_187227_b(BOWL_POS, Optional.empty());
    }

    public void setBedPos(BlockPos pos) {
        this.field_70180_af.func_187227_b(BED_POS, Optional.of(pos));
    }

    public void setBowlPos(BlockPos pos) {
        this.field_70180_af.func_187227_b(BOWL_POS, Optional.of(pos));
    }

    public void setNoCollar() {
        this.setCollarData(-2);
    }

    public boolean hasCollar() {
        return this.getCollarData() != -2;
    }

    public boolean hasCollarColoured() {
        return this.getCollarData() >= -1;
    }

    public boolean isCollarColoured() {
        return this.getCollarData() > -1;
    }

    public void setHasCollar() {
        this.setCollarData(-1);
    }

    public boolean hasFancyCollar() {
        return this.getCollarData() < -2;
    }

    public int getFancyCollarIndex() {
        return -3 - this.getCollarData();
    }

    public boolean isCreativeCollar() {
        return this.getCollarData() == -3;
    }

    public float[] getCollar() {
        return DogUtil.rgbIntToFloatArray(this.getCollarData());
    }

    public boolean hasCape() {
        return this.getCapeData() != -2;
    }

    public boolean hasCapeColoured() {
        return this.getCapeData() >= -1;
    }

    public boolean hasFancyCape() {
        return this.getCapeData() == -3;
    }

    public boolean hasLeatherJacket() {
        return this.getCapeData() == -4;
    }

    public boolean isCapeColoured() {
        return this.getCapeData() > -1;
    }

    public void setFancyCape() {
        this.setCapeData(-3);
    }

    public void setLeatherJacket() {
        this.setCapeData(-4);
    }

    public void setCapeColoured() {
        this.setCapeData(-1);
    }

    public void setNoCape() {
        this.setCapeData(-2);
    }

    public float[] getCapeColour() {
        return DogUtil.rgbIntToFloatArray(this.getCapeData());
    }

    public Random getRandom() {
        return this.field_70146_Z;
    }

    public Container func_174876_a(InventoryPlayer inventory, EntityPlayer player) {
        return new Container(){

            public boolean func_75145_c(EntityPlayer playerIn) {
                return true;
            }
        };
    }

    public String func_174875_k() {
        return "doggytalents:dog_info";
    }

    public boolean isDogJumping() {
        return this.dogJumping;
    }

    public void setDogJumping(boolean jumping) {
        this.dogJumping = jumping;
    }

    public double getDogJumpStrength() {
        float verticalVelocity = 0.42f + 0.06f * (float)this.TALENTS.getLevel(ModTalents.WOLF_MOUNT);
        if (this.TALENTS.getLevel(ModTalents.WOLF_MOUNT) == 5) {
            verticalVelocity += 0.04f;
        }
        return verticalVelocity;
    }

    public Entity func_184179_bs() {
        return this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
    }

    public boolean func_82171_bF() {
        return this.func_184179_bs() instanceof EntityLivingBase;
    }

    public boolean func_70104_M() {
        return !this.func_184207_aI();
    }

    public void func_184232_k(Entity passenger) {
        super.func_184232_k(passenger);
        if (passenger instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)passenger;
            this.field_70761_aq = entityliving.field_70761_aq;
        }
    }

    public double func_70033_W() {
        return this.func_184187_bx() instanceof EntityPlayer ? 0.5 : 0.0;
    }

    public boolean canBeRiddenInWater(Entity rider) {
        return !TalentHelper.shouldDismountInWater(this, rider);
    }

    public boolean canRiderInteract() {
        return true;
    }

    public void setJumpPower(int jumpPowerIn) {
        if (this.TALENTS.getLevel(ModTalents.WOLF_MOUNT) > 0) {
            this.jumpPower = 1.0f;
        }
    }

    public boolean canJump() {
        return this.TALENTS.getLevel(ModTalents.WOLF_MOUNT) > 0;
    }

    public void func_191986_a(float strafe, float vertical, float forward) {
        if (this.func_184207_aI() && this.func_82171_bF() && this.TALENTS.getLevel(ModTalents.WOLF_MOUNT) > 0) {
            EntityLivingBase entitylivingbase = (EntityLivingBase)this.func_184179_bs();
            this.field_70126_B = this.field_70177_z = entitylivingbase.field_70177_z;
            this.field_70125_A = entitylivingbase.field_70125_A * 0.5f;
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            this.field_70759_as = this.field_70761_aq = this.field_70177_z;
            strafe = entitylivingbase.field_70702_br * 0.7f;
            forward = entitylivingbase.field_191988_bg;
            if (forward <= 0.0f) {
                forward *= 0.5f;
            }
            this.field_70138_W = 1.0f;
            if (this.jumpPower > 0.0f && !this.isDogJumping() && this.field_70122_E) {
                this.field_70181_x = this.getDogJumpStrength() * (double)this.jumpPower;
                if (this.func_70644_a(MobEffects.field_76430_j)) {
                    this.field_70181_x += (double)((float)(this.func_70660_b(MobEffects.field_76430_j).func_76458_c() + 1) * 0.1f);
                }
                this.setDogJumping(true);
                this.field_70160_al = true;
                if (forward > 0.0f) {
                    float f = MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180)));
                    float f1 = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)));
                    this.field_70159_w += (double)(-0.4f * f * this.jumpPower);
                    this.field_70179_y += (double)(0.4f * f1 * this.jumpPower);
                }
                this.jumpPower = 0.0f;
            } else if (this.jumpPower > 0.0f && this.func_70090_H() && !this.isDogJumping()) {
                this.field_70181_x = this.getDogJumpStrength() * (double)0.4f;
                this.setDogJumping(true);
                this.jumpPower = 0.0f;
            }
            this.field_70747_aH = this.func_70689_ay() * 0.3f;
            if (this.func_184186_bw()) {
                this.func_70659_e((float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e() * 0.5f);
                super.func_191986_a(strafe, vertical, forward);
            } else if (entitylivingbase instanceof EntityPlayer) {
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
                this.field_70179_y = 0.0;
            }
            if (this.field_70122_E || this.func_70090_H()) {
                this.jumpPower = 0.0f;
                this.setDogJumping(false);
            }
            this.field_184618_aE = this.field_70721_aZ;
            double d1 = this.field_70165_t - this.field_70169_q;
            double d0 = this.field_70161_v - this.field_70166_s;
            float f2 = MathHelper.func_76133_a((double)(d1 * d1 + d0 * d0)) * 4.0f;
            if (f2 > 1.0f) {
                f2 = 1.0f;
            }
            this.field_70721_aZ += (f2 - this.field_70721_aZ) * 0.4f;
            this.field_184619_aG += this.field_70721_aZ;
        } else {
            this.field_70138_W = 0.6f;
            this.field_70747_aH = 0.02f;
            super.func_191986_a(strafe, vertical, forward);
        }
    }
}

