/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.entity.ai;

import doggytalents.DoggyTalentsMod;
import doggytalents.entity.EntityDog;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraft.world.storage.WorldSavedDataStorage;

public class DogLocationManager
extends WorldSavedData {
    private List<DogLocation> locations = new ArrayList<DogLocation>();

    public DogLocationManager(String name) {
        super(name);
    }

    public List<DogLocation> getList(Predicate<DogLocation> selector) {
        return this.getStream(selector).collect(Collectors.toList());
    }

    public Stream<DogLocation> getStream(Predicate<DogLocation> selector) {
        return this.locations.stream().filter(selector);
    }

    public static DogLocationManager getHandler(World world) {
        return DogLocationManager.getHandler(world.func_175693_T(), world.func_201675_m().func_186058_p());
    }

    public static DogLocationManager getHandler(World world, DimensionType dimType) {
        return DogLocationManager.getHandler(world.func_175693_T(), dimType);
    }

    public static DogLocationManager getHandler(WorldSavedDataStorage storage, DimensionType dimType) {
        DogLocationManager locationManager = (DogLocationManager)storage.func_212426_a(dimType, DogLocationManager::new, "dog_locations");
        if (locationManager == null) {
            locationManager = new DogLocationManager("dog_locations");
            storage.func_212424_a(dimType, "dog_locations", (WorldSavedData)locationManager);
        }
        return locationManager;
    }

    public void update(EntityDog dog) {
        DogLocation temp = new DogLocation(dog);
        int index = this.locations.indexOf(temp);
        if (index >= 0) {
            this.locations.set(index, temp);
        } else {
            DoggyTalentsMod.LOGGER.debug("ADDED NEW DATA: " + temp);
            this.locations.add(temp);
        }
        this.func_76185_a();
    }

    public void remove(EntityDog dog) {
        DogLocation temp = new DogLocation(dog);
        if (this.locations.remove(temp)) {
            this.func_76185_a();
            DoggyTalentsMod.LOGGER.debug("REMOVED DATA: " + temp);
        }
    }

    public void func_76184_a(NBTTagCompound nbt) {
        if (nbt.func_150297_b("dog_locations", 9)) {
            NBTTagList nbtlist = nbt.func_150295_c("dog_locations", 10);
            for (int i = 0; i < nbtlist.size(); ++i) {
                DogLocation location = new DogLocation(nbtlist.func_150305_b(i));
                DoggyTalentsMod.LOGGER.debug("Loaded: " + location);
                if (location.entityId == null) continue;
                this.locations.add(location);
            }
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound compound) {
        NBTTagList nbtlist = new NBTTagList();
        for (DogLocation location : this.locations) {
            nbtlist.add((INBTBase)location.write(new NBTTagCompound()));
        }
        compound.func_74782_a("dog_locations", (INBTBase)nbtlist);
        return compound;
    }

    public class DogLocation {
        @Nonnull
        private UUID entityId;
        public double x;
        public double y;
        public double z;
        @Nullable
        private UUID owner;
        private ITextComponent name;
        private String gender;
        private boolean hasRadarCollar;

        public DogLocation(NBTTagCompound nbt) {
            this.read(nbt);
        }

        public DogLocation(EntityDog dog) {
            this.x = dog.field_70165_t;
            this.y = dog.field_70163_u;
            this.z = dog.field_70161_v;
            this.entityId = dog.func_110124_au();
            this.owner = dog.func_184753_b();
            this.name = dog.func_200200_C_();
            this.gender = dog.getGender();
            this.hasRadarCollar = dog.hasRadarCollar();
        }

        private void read(NBTTagCompound compound) {
            this.x = compound.func_74769_h("x");
            this.y = compound.func_74769_h("y");
            this.z = compound.func_74769_h("z");
            this.entityId = compound.func_186857_a("entityId");
            if (compound.func_186855_b("ownerId")) {
                this.owner = compound.func_186857_a("ownerId");
            }
            if (compound.func_150297_b("name_text_component", 8)) {
                this.name = ITextComponent.Serializer.func_150699_a((String)compound.func_74779_i("name_text_component"));
            } else if (compound.func_150297_b("name", 8)) {
                this.name = new TextComponentString(compound.func_74779_i("name"));
            }
            this.gender = compound.func_74779_i("gender");
            this.hasRadarCollar = compound.func_74767_n("collar");
        }

        public NBTTagCompound write(NBTTagCompound compound) {
            compound.func_74780_a("x", this.x);
            compound.func_74780_a("y", this.y);
            compound.func_74780_a("z", this.z);
            compound.func_186854_a("entityId", this.entityId);
            if (this.owner != null) {
                compound.func_186854_a("ownerId", this.owner);
            }
            compound.func_74778_a("name_text_component", ITextComponent.Serializer.func_150696_a((ITextComponent)this.name));
            compound.func_74778_a("gender", this.gender);
            compound.func_74757_a("collar", this.hasRadarCollar);
            return compound;
        }

        public EntityDog getDog(World world) {
            if (!(world instanceof WorldServer)) {
                DoggyTalentsMod.LOGGER.warn("Something when wrong. Tried to call DogLocation#getDog(EntityPlayer) on what looks like the client side");
                return null;
            }
            Entity entity = ((WorldServer)world).func_175733_a(this.entityId);
            if (entity == null) {
                return null;
            }
            if (!(entity instanceof EntityDog)) {
                DoggyTalentsMod.LOGGER.warn("Something when wrong. The saved dog UUID is not an EntityDog");
                return null;
            }
            return (EntityDog)entity;
        }

        public EntityLivingBase getOwner(World world) {
            EntityDog dog = this.getDog(world);
            if (dog != null) {
                return dog.func_70902_q();
            }
            if (this.owner != null) {
                return world.func_152378_a(this.owner);
            }
            return null;
        }

        public ITextComponent getName(World world) {
            EntityDog dog = this.getDog(world);
            if (dog != null) {
                return dog.func_145748_c_();
            }
            if (this.owner != null) {
                return this.name;
            }
            return null;
        }

        public boolean hasRadioCollar(World world) {
            EntityDog dog = this.getDog(world);
            if (dog != null) {
                return dog.hasRadarCollar();
            }
            return this.hasRadarCollar;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DogLocation)) {
                return false;
            }
            DogLocation other = (DogLocation)obj;
            return this.entityId != null && other.entityId != null && this.entityId.equals(other.entityId);
        }

        public String toString() {
            return String.format("DogLocation [id=%s, x=%f,y=%f, z=%f]", this.entityId.toString(), this.x, this.y, this.z);
        }
    }
}

