/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.entity.ai;

import doggytalents.api.inferface.IWaterMovement;
import doggytalents.entity.EntityDog;
import doggytalents.entity.ai.WaterMovementHandler;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNavigate;

public class EntityAIClosestItem
extends EntityAIBase {
    protected final EntityDog dog;
    private final Predicate<EntityItem> predicate;
    private final Comparator<Entity> sorter;
    private final double followSpeed;
    private final PathNavigate dogPathfinder;
    private final IWaterMovement waterMovement;
    protected EntityItem target;
    private int timeToRecalcPath;
    private float maxDist;
    private double oldRangeSense;

    public EntityAIClosestItem(EntityDog dogIn, double speedIn, float range, @Nullable Predicate<ItemStack> targetSelector) {
        this.dog = dogIn;
        this.dogPathfinder = dogIn.func_70661_as();
        this.followSpeed = speedIn;
        this.maxDist = range;
        this.predicate = entity -> {
            double d0 = this.getFollowRange();
            if (entity.func_82150_aj()) {
                return false;
            }
            if (targetSelector != null && !targetSelector.test(entity.func_92059_d())) {
                return false;
            }
            return !((double)entity.func_70032_d((Entity)this.dog) > d0);
        };
        this.sorter = new EntityAINearestAttackableTarget.Sorter((Entity)dogIn);
        this.waterMovement = new WaterMovementHandler(this.dog);
        this.func_75248_a(3);
    }

    public boolean func_75250_a() {
        double d0 = this.getFollowRange();
        List list = this.dog.field_70170_p.func_175647_a(EntityItem.class, this.dog.func_174813_aQ().func_72314_b(d0, 4.0, d0), this.predicate);
        Collections.sort(list, this.sorter);
        if (list.isEmpty()) {
            return false;
        }
        this.target = (EntityItem)list.get(0);
        return true;
    }

    public boolean func_75253_b() {
        EntityItem target = this.target;
        if (target == null) {
            return false;
        }
        if (!target.func_70089_S()) {
            return false;
        }
        double d0 = this.getFollowRange();
        return !(this.dog.func_70068_e((Entity)target) > d0 * d0);
    }

    public void func_75249_e() {
        this.timeToRecalcPath = 0;
        this.oldRangeSense = this.dog.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111126_e();
        this.dog.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a((double)this.maxDist);
    }

    public void func_75246_d() {
        this.dog.func_70671_ap().func_75651_a((Entity)this.target, 10.0f, (float)this.dog.func_70646_bf());
        if (!this.dog.func_70906_o() && --this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = 10;
            this.dogPathfinder.func_75497_a((Entity)this.target, this.followSpeed);
        }
    }

    public void func_75251_c() {
        this.dogPathfinder.func_75499_g();
        this.waterMovement.resetTask();
        this.dog.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(this.oldRangeSense);
    }

    protected double getFollowRange() {
        IAttributeInstance iattributeinstance = this.dog.func_110148_a(SharedMonsterAttributes.field_111265_b);
        return iattributeinstance == null ? 16.0 : iattributeinstance.func_111126_e();
    }
}

