/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.entity.ai;

import doggytalents.api.inferface.IWaterMovement;
import doggytalents.entity.EntityDog;
import doggytalents.entity.ai.WaterMovementHandler;
import doggytalents.entity.features.ModeFeature;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntityAIOwnerTool
extends EntityAIBase {
    private final EntityDog dog;
    private EntityLivingBase owner;
    private World world;
    private final double followSpeed;
    private final PathNavigate petPathfinder;
    private int timeToRecalcPath;
    private float executeDistance;
    private float finishedDistance;
    private IWaterMovement waterMovement;

    public EntityAIOwnerTool(EntityDog thePetIn, double followSpeedIn, float executeDistance, float finishedDistance) {
        this.dog = thePetIn;
        this.world = thePetIn.field_70170_p;
        this.followSpeed = followSpeedIn;
        this.petPathfinder = thePetIn.func_70661_as();
        this.executeDistance = executeDistance;
        this.finishedDistance = finishedDistance;
        this.waterMovement = new WaterMovementHandler(this.dog);
        this.func_75248_a(3);
        if (!(thePetIn.func_70661_as() instanceof PathNavigateGround)) {
            throw new IllegalArgumentException("Unsupported mob type for FollowOwnerGoal");
        }
    }

    public boolean func_75250_a() {
        EntityLivingBase entitylivingbase = this.dog.func_70902_q();
        if (entitylivingbase == null) {
            return false;
        }
        if (entitylivingbase instanceof EntityPlayer && ((EntityPlayer)entitylivingbase).func_175149_v()) {
            return false;
        }
        if (this.dog.func_70906_o()) {
            return false;
        }
        if (this.dog.func_70068_e((Entity)entitylivingbase) > (double)(this.finishedDistance * this.finishedDistance)) {
            return false;
        }
        if (!this.isCommanding(entitylivingbase)) {
            return false;
        }
        if (this.dog.MODE.isMode(ModeFeature.EnumMode.WANDERING)) {
            return false;
        }
        this.owner = entitylivingbase;
        return true;
    }

    public boolean func_75253_b() {
        return !this.petPathfinder.func_75500_f() && !this.dog.func_70906_o() && this.dog.func_70068_e((Entity)this.owner) < (double)(this.finishedDistance * this.finishedDistance) && this.isCommanding(this.owner);
    }

    public void func_75249_e() {
        this.timeToRecalcPath = 0;
        this.waterMovement.startExecuting();
    }

    public void func_75251_c() {
        this.owner = null;
        this.petPathfinder.func_75499_g();
        this.waterMovement.resetTask();
    }

    public void func_75246_d() {
        if (!this.dog.func_70906_o() && --this.timeToRecalcPath <= 0) {
            int dogZ;
            int dPosZ;
            int k3;
            int dogY;
            this.timeToRecalcPath = 10;
            int masterX = MathHelper.func_76128_c((double)this.owner.field_70165_t);
            int masterY = MathHelper.func_76128_c((double)this.owner.func_174813_aQ().field_72338_b);
            int masterZ = MathHelper.func_76128_c((double)this.owner.field_70161_v);
            int dogX = MathHelper.func_76128_c((double)this.dog.field_70165_t);
            int dPosX = dogX - masterX;
            int j3 = masterX + dPosX * 2;
            if (this.petPathfinder.func_75492_a((double)j3, (double)(dogY = MathHelper.func_76128_c((double)this.dog.field_70163_u)), (double)(k3 = masterZ + (dPosZ = (dogZ = MathHelper.func_76128_c((double)this.dog.field_70161_v)) - masterZ) * 2), this.followSpeed)) {
                this.dog.func_70671_ap().func_75650_a((double)j3, (double)(dogY + 1), (double)k3, 10.0f, (float)this.dog.func_70646_bf());
            }
        }
    }

    public boolean isCommanding(EntityLivingBase entitylivingbase) {
        ItemStack mainStack = entitylivingbase.func_184614_ca();
        return mainStack.func_77973_b() instanceof ItemSword || mainStack.func_77973_b() instanceof ItemTool;
    }
}

