/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.entity.ai;

import com.google.common.collect.Lists;
import doggytalents.ModItems;
import doggytalents.ModTalents;
import doggytalents.api.inferface.IWaterMovement;
import doggytalents.entity.EntityDog;
import doggytalents.entity.ai.WaterMovementHandler;
import doggytalents.entity.features.ModeFeature;
import doggytalents.helper.DogUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityAIShepherdDog
extends EntityAIBase {
    protected final EntityDog dog;
    private World world;
    private EntityLivingBase owner;
    private final Predicate<EntityAnimal> predicate;
    private final EntityAINearestAttackableTarget.Sorter sorter;
    protected List<EntityAnimal> targets;
    private final double followSpeed;
    private final PathNavigate dogPathfinder;
    private int timeToRecalcPath;
    private float maxDist;
    private IWaterMovement waterMovement;
    private int MAX_FOLLOW = 5;

    public EntityAIShepherdDog(EntityDog dogIn, double speedIn, float range, @Nullable Predicate<EntityAnimal> targetSelector) {
        this.dog = dogIn;
        this.world = dogIn.field_70170_p;
        this.dogPathfinder = dogIn.func_70661_as();
        this.followSpeed = speedIn;
        this.maxDist = range;
        this.predicate = entity -> {
            double d0 = this.getFollowRange();
            if (entity.func_82150_aj()) {
                return false;
            }
            if (targetSelector != null && !targetSelector.test((EntityAnimal)entity)) {
                return false;
            }
            return (double)entity.func_70032_d((Entity)this.dog) > d0 ? false : entity.func_70685_l((Entity)this.dog);
        };
        this.sorter = new EntityAINearestAttackableTarget.Sorter((Entity)dogIn);
        this.waterMovement = new WaterMovementHandler(this.dog);
        this.func_75248_a(3);
    }

    public boolean func_75250_a() {
        if (!this.dog.MODE.isMode(ModeFeature.EnumMode.DOCILE)) {
            return false;
        }
        if (this.dog.TALENTS.getLevel(ModTalents.SHEPHERD_DOG) <= 0) {
            return false;
        }
        EntityLivingBase entitylivingbase = this.dog.func_70902_q();
        if (entitylivingbase == null) {
            return false;
        }
        if (entitylivingbase instanceof EntityPlayer && ((EntityPlayer)entitylivingbase).func_175149_v()) {
            return false;
        }
        if (!DogUtil.isHolding((Entity)entitylivingbase, ModItems.WHISTLE, nbt -> nbt.func_74764_b("mode") && nbt.func_74762_e("mode") == 4)) {
            return false;
        }
        List list = this.world.func_175647_a(EntityAnimal.class, this.dog.func_174813_aQ().func_72314_b(12.0, 4.0, 12.0), this.predicate);
        Collections.sort(list, this.sorter);
        if (list.isEmpty()) {
            return false;
        }
        this.MAX_FOLLOW = ModTalents.SHEPHERD_DOG.getMaxFollowers(this.dog);
        this.targets = list.subList(0, Math.min(this.MAX_FOLLOW, list.size()));
        this.owner = entitylivingbase;
        return true;
    }

    public boolean func_75253_b() {
        if (!this.dog.MODE.isMode(ModeFeature.EnumMode.DOCILE)) {
            return false;
        }
        if (this.dog.TALENTS.getLevel(ModTalents.SHEPHERD_DOG) <= 0) {
            return false;
        }
        if (!DogUtil.isHolding((Entity)this.owner, ModItems.WHISTLE, nbt -> nbt.func_74764_b("mode") && nbt.func_74762_e("mode") == 4)) {
            return false;
        }
        return !this.targets.isEmpty();
    }

    public void func_75249_e() {
        this.timeToRecalcPath = 0;
        this.waterMovement.startExecuting();
    }

    public void func_75246_d() {
        if (!this.dog.func_70906_o() && --this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = 10;
            if (this.targets.size() < this.MAX_FOLLOW) {
                List list = this.world.func_175647_a(EntityAnimal.class, this.dog.func_174813_aQ().func_72314_b(16.0, 4.0, 16.0), this.predicate);
                list.removeAll(this.targets);
                Collections.sort(list, this.sorter);
                this.targets.addAll(list.subList(0, Math.min(this.MAX_FOLLOW - this.targets.size(), list.size())));
            }
            Collections.sort(this.targets, this.sorter);
            boolean teleport = this.owner.func_70032_d((Entity)this.targets.get(0)) > 16.0f;
            for (EntityAnimal entityAnimal : this.targets) {
                double distanceAway = entityAnimal.func_70032_d((Entity)this.owner);
                entityAnimal.func_70671_ap().func_75651_a((Entity)this.owner, 10.0f, (float)entityAnimal.func_70646_bf());
                if (teleport) {
                    if (entityAnimal.func_110167_bD() || entityAnimal.func_184218_aH()) continue;
                    DogUtil.teleportDogToOwner((Entity)this.owner, (Entity)entityAnimal, this.world, entityAnimal.func_70661_as(), 4);
                    continue;
                }
                if (distanceAway >= 5.0) {
                    if (entityAnimal.func_70661_as().func_75497_a((Entity)this.owner, 1.2) || entityAnimal.func_110167_bD() || entityAnimal.func_184218_aH() || !(distanceAway >= 20.0)) continue;
                    DogUtil.teleportDogToOwner((Entity)this.owner, (Entity)entityAnimal, this.world, entityAnimal.func_70661_as(), 4);
                    continue;
                }
                entityAnimal.func_70661_as().func_75499_g();
            }
            Vec3d vec = Vec3d.field_186680_a;
            for (EntityAnimal target : this.targets) {
                vec = vec.func_178787_e(target.func_174791_d());
            }
            vec = vec.func_186678_a(1.0 / (double)this.targets.size());
            double d = vec.field_72450_a - this.owner.field_70165_t;
            double dPosZ = vec.field_72449_c - this.owner.field_70161_v;
            double size = Math.sqrt(d * d + dPosZ * dPosZ);
            double j3 = vec.field_72450_a + d / size * (double)(2 + this.targets.size() / 16);
            double k3 = vec.field_72449_c + dPosZ / size * (double)(2 + this.targets.size() / 16);
            if (teleport) {
                DogUtil.teleportDogToPos(j3, this.dog.field_70163_u, k3, (Entity)this.dog, this.world, this.dogPathfinder, 1);
            }
            this.dog.func_70671_ap().func_75651_a((Entity)this.owner, 10.0f, (float)this.dog.func_70646_bf());
            if (!this.dogPathfinder.func_75492_a(j3, this.owner.func_174813_aQ().field_72338_b, k3, this.followSpeed) && this.dog.func_70011_f(j3, this.owner.func_174813_aQ().field_72338_b, k3) > 12.0 && !this.dog.func_110167_bD() && !this.dog.func_184218_aH()) {
                DogUtil.teleportDogToPos(j3, this.dog.field_70163_u, k3, (Entity)this.dog, this.world, this.dogPathfinder, 4);
            }
            if (this.dog.func_70032_d((Entity)this.owner) > 40.0f) {
                DogUtil.teleportDogToOwner((Entity)this.owner, (Entity)this.dog, this.world, this.dogPathfinder, 2);
            }
            if (this.dog.getRandom().nextFloat() < 0.15f) {
                this.dog.func_184185_a(SoundEvents.field_187857_gE, this.dog.func_70599_aP() + 1.0f, (this.dog.getRandom().nextFloat() - this.dog.getRandom().nextFloat()) * 0.1f + 0.9f);
            }
            ArrayList toRemove = Lists.newArrayList();
            for (EntityAnimal target : this.targets) {
                if (target.func_70089_S() && !((double)target.func_70032_d((Entity)this.dog) > 25.0)) continue;
                toRemove.add(target);
            }
            this.targets.removeAll(toRemove);
        }
    }

    public void func_75251_c() {
        this.owner = null;
        for (EntityAnimal target : this.targets) {
            target.func_70661_as().func_75499_g();
        }
        this.dogPathfinder.func_75499_g();
        this.waterMovement.resetTask();
    }

    protected double getFollowRange() {
        IAttributeInstance iattributeinstance = this.dog.func_110148_a(SharedMonsterAttributes.field_111265_b);
        return iattributeinstance == null ? 16.0 : iattributeinstance.func_111126_e();
    }
}

