/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.helper;

import doggytalents.ModItems;
import doggytalents.entity.EntityDog;
import doggytalents.item.ItemChewStick;
import java.util.function.Predicate;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class DogUtil {
    public static void teleportDogToOwner(Entity owner, Entity entity, World world, PathNavigate pathfinder, int radius) {
        DogUtil.teleportDogToPos(owner.field_70165_t, owner.func_174813_aQ().field_72338_b, owner.field_70161_v, entity, world, pathfinder, radius);
    }

    public static void teleportDogToOwner(Entity owner, Entity entity, World world, PathNavigate pathfinder) {
        DogUtil.teleportDogToPos(owner.field_70165_t, owner.func_174813_aQ().field_72338_b, owner.field_70161_v, entity, world, pathfinder, 2);
    }

    public static void teleportDogToPos(double x, double y, double z, Entity entity, World world, PathNavigate pathfinder, int radius) {
        int i = MathHelper.func_76128_c((double)x) - radius;
        int j = MathHelper.func_76128_c((double)z) - radius;
        int k = MathHelper.func_76128_c((double)y);
        for (int l = 0; l <= radius * 2; ++l) {
            for (int i1 = 0; i1 <= radius * 2; ++i1) {
                if (l >= 1 && i1 >= 1 && l <= radius * 2 - 1 && i1 <= radius * 2 - 1 || !DogUtil.isTeleportFriendlyBlock(entity, world, i, j, k, l, i1)) continue;
                entity.func_70012_b((double)((float)(i + l) + 0.5f), (double)k, (double)((float)(j + i1) + 0.5f), entity.field_70177_z, entity.field_70125_A);
                pathfinder.func_75499_g();
                return;
            }
        }
    }

    public static boolean isTeleportFriendlyBlock(Entity entity, World world, int xBase, int zBase, int y, int xAdd, int zAdd) {
        BlockPos blockpos = new BlockPos(xBase + xAdd, y - 1, zBase + zAdd);
        IBlockState iblockstate = world.func_180495_p(blockpos);
        return iblockstate.func_193401_d((IBlockReader)world, blockpos, EnumFacing.DOWN) == BlockFaceShape.SOLID && iblockstate.func_189884_a(entity) && world.func_175623_d(blockpos.func_177984_a()) && world.func_175623_d(blockpos.func_177981_b(2));
    }

    public static ItemStack feedDog(EntityDog dog, IInventory inventory, int slotIndex) {
        if (!inventory.func_70301_a(slotIndex).func_190926_b()) {
            ItemStack itemstack = inventory.func_70301_a(slotIndex);
            dog.setDogHunger(dog.getDogHunger() + dog.foodValue(itemstack));
            if (itemstack.func_77973_b() == ModItems.CHEW_STICK) {
                ((ItemChewStick)ModItems.CHEW_STICK).addChewStickEffects(dog);
            }
            if (inventory.func_70301_a(slotIndex).func_190916_E() <= 1) {
                ItemStack itemstack1 = inventory.func_70301_a(slotIndex);
                inventory.func_70299_a(slotIndex, ItemStack.field_190927_a);
                return itemstack1;
            }
            ItemStack itemstack2 = inventory.func_70301_a(slotIndex).func_77979_a(1);
            if (inventory.func_70301_a(slotIndex).func_190926_b()) {
                inventory.func_70299_a(slotIndex, ItemStack.field_190927_a);
            } else {
                inventory.func_70296_d();
            }
            return itemstack2;
        }
        return ItemStack.field_190927_a;
    }

    public static boolean doesInventoryContainFood(EntityDog dog, IInventory inventory) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            if (dog.foodValue(inventory.func_70301_a(i)) <= 0) continue;
            return true;
        }
        return false;
    }

    public static int getFirstSlotWithFood(EntityDog dog, IInventory inventory) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            if (dog.foodValue(inventory.func_70301_a(i)) <= 0) continue;
            return i;
        }
        return -1;
    }

    public static ItemStack addItem(IInventory inventory, ItemStack stack) {
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack itemstack = stack.func_77946_l();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack itemstack1 = inventory.func_70301_a(i);
            if (itemstack1.func_190926_b()) {
                inventory.func_70299_a(i, itemstack);
                inventory.func_70296_d();
                return ItemStack.field_190927_a;
            }
            if (!ItemStack.func_179545_c((ItemStack)itemstack1, (ItemStack)itemstack)) continue;
            int j = Math.min(inventory.func_70297_j_(), itemstack1.func_77976_d());
            int k = Math.min(itemstack.func_190916_E(), j - itemstack1.func_190916_E());
            if (k <= 0) continue;
            itemstack1.func_190917_f(k);
            itemstack.func_190918_g(k);
            if (!itemstack.func_190926_b()) continue;
            inventory.func_70296_d();
            return ItemStack.field_190927_a;
        }
        if (itemstack.func_190916_E() != stack.func_190916_E()) {
            inventory.func_70296_d();
        }
        return itemstack;
    }

    public static boolean isHolding(Entity entity, Item item, Predicate<NBTTagCompound> nbtPredicate) {
        return DogUtil.isHolding(entity, (ItemStack stack) -> stack.func_77973_b() == item && stack.func_77942_o() && nbtPredicate.test(stack.func_77978_p()));
    }

    public static boolean isHolding(Entity entity, Item item) {
        return DogUtil.isHolding(entity, (ItemStack stack) -> stack.func_77973_b() == item);
    }

    public static boolean isHolding(Entity entity, Predicate<ItemStack> matcher) {
        if (entity == null) {
            return false;
        }
        for (ItemStack stack : entity.func_184214_aD()) {
            if (!matcher.test(stack)) continue;
            return true;
        }
        return false;
    }

    public static float[] rgbIntToFloatArray(int rgbInt) {
        int r = rgbInt >> 16 & 0xFF;
        int g = rgbInt >> 8 & 0xFF;
        int b = rgbInt >> 0 & 0xFF;
        return new float[]{(float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f};
    }

    public static int[] rgbIntToIntArray(int rgbInt) {
        int r = rgbInt >> 16 & 0xFF;
        int g = rgbInt >> 8 & 0xFF;
        int b = rgbInt >> 0 & 0xFF;
        return new int[]{r, g, b};
    }
}

