/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.item;

import doggytalents.helper.DogUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemCapeColoured
extends Item {
    protected static int[] WHITE = new int[]{0, 0, 0};

    public ItemCapeColoured(Item.Properties properties) {
        super(properties);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        int[] rgb = WHITE;
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("cap_colour")) {
            rgb = DogUtil.rgbIntToIntArray(stack.func_77978_p().func_74762_e("cap_colour"));
        }
        tooltip.add((ITextComponent)new TextComponentTranslation(this.func_77658_a() + ".tooltip", new Object[]{TextFormatting.RED + "" + rgb[0] + TextFormatting.GREEN + " " + rgb[1] + TextFormatting.BLUE + " " + rgb[2]}));
    }

    public boolean hasColor(ItemStack stack) {
        NBTTagCompound nbttagcompound = stack.func_77978_p();
        return nbttagcompound != null && nbttagcompound.func_150297_b("cape_colour", 3);
    }

    public int getColor(ItemStack stack) {
        NBTTagCompound nbttagcompound = stack.func_77978_p();
        if (nbttagcompound != null) {
            return nbttagcompound.func_74762_e("cape_colour");
        }
        return 10511680;
    }

    public void removeColor(ItemStack stack) {
        NBTTagCompound nbttagcompound = stack.func_77978_p();
        if (nbttagcompound != null) {
            nbttagcompound.func_82580_o("cape_colour");
        }
    }

    public void setColor(ItemStack stack, int color) {
        NBTTagCompound nbttagcompound = stack.func_77978_p();
        if (nbttagcompound == null) {
            nbttagcompound = new NBTTagCompound();
            stack.func_77982_d(nbttagcompound);
        }
        nbttagcompound.func_74768_a("cape_colour", color);
    }
}

