/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.item;

import doggytalents.entity.ai.DogLocationManager;
import doggytalents.item.ItemRadar;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemRadarCreative
extends Item {
    public ItemRadarCreative(Item.Properties properties) {
        super(properties);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        if (!worldIn.field_72995_K) {
            DimensionType dimCurr = playerIn.field_71093_bK;
            playerIn.func_145747_a((ITextComponent)new TextComponentString(""));
            DogLocationManager locationManager = DogLocationManager.getHandler(worldIn, dimCurr);
            List<DogLocationManager.DogLocation> ownDogs = locationManager.getList(loc -> loc.getOwner(worldIn) == playerIn);
            if (ownDogs.isEmpty()) {
                playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("dogradar.errornull", new Object[]{String.valueOf(DimensionType.func_212678_a((DimensionType)dimCurr))}));
            } else {
                for (DogLocationManager.DogLocation loc2 : ownDogs) {
                    String translateStr = ItemRadar.getDirectionTranslationKey(loc2, (Entity)playerIn);
                    playerIn.func_145747_a((ITextComponent)new TextComponentTranslation(translateStr, new Object[]{loc2.getName(worldIn), (int)Math.ceil(playerIn.func_70011_f(loc2.x, loc2.y, loc2.z))}));
                }
            }
            ArrayList<DimensionType> otherDogs = new ArrayList<DimensionType>();
            ArrayList<DimensionType> noDogs = new ArrayList<DimensionType>();
            for (DimensionType dimType : DimensionType.func_212681_b()) {
                if (dimCurr == dimType) continue;
                locationManager = DogLocationManager.getHandler(worldIn, dimType);
                ownDogs = locationManager.getList(loc -> loc.getOwner(worldIn) == playerIn && loc.hasRadioCollar(worldIn));
                if (ownDogs.size() > 0) {
                    otherDogs.add(dimType);
                    continue;
                }
                noDogs.add(dimType);
            }
            if (otherDogs.size() > 0) {
                playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("dogradar.notindim", new Object[]{otherDogs.stream().map(dim -> String.valueOf(DimensionType.func_212678_a((DimensionType)dim))).collect(Collectors.joining(", "))}));
            }
            if (noDogs.size() > 0) {
                playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("dogradar.errornull", new Object[]{noDogs.stream().map(dim -> String.valueOf(DimensionType.func_212678_a((DimensionType)dim))).collect(Collectors.joining(", "))}));
            }
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)playerIn.func_184586_b(handIn));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add((ITextComponent)new TextComponentTranslation(this.func_77658_a() + ".tooltip", new Object[0]));
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.EPIC;
    }
}

