/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.network.client;

import doggytalents.DoggyTalentsMod;
import java.util.function.Supplier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketCustomParticle {
    private BlockPos pos;
    private float posX;
    private float posY;
    private float posZ;
    private int numberOfParticles;
    private float particleSpeed;

    public PacketCustomParticle(BlockPos pos, double posX, double posY, double posZ, int numberOfParticles, float particleSpeed) {
        this.pos = pos;
        this.posX = (float)posX;
        this.posY = (float)posY;
        this.posZ = (float)posZ;
        this.numberOfParticles = numberOfParticles;
        this.particleSpeed = particleSpeed;
    }

    public static void encode(PacketCustomParticle msg, PacketBuffer buf) {
        buf.func_179255_a(msg.pos);
        buf.writeInt(msg.numberOfParticles);
        buf.writeFloat(msg.posX);
        buf.writeFloat(msg.posY);
        buf.writeFloat(msg.posZ);
        buf.writeFloat(msg.particleSpeed);
    }

    public static PacketCustomParticle decode(PacketBuffer buf) {
        BlockPos pos = buf.func_179259_c();
        int numberOfParticles = buf.readInt();
        float posX = buf.readFloat();
        float posY = buf.readFloat();
        float posZ = buf.readFloat();
        float particleSpeed = buf.readFloat();
        return new PacketCustomParticle(pos, posX, posY, posZ, numberOfParticles, particleSpeed);
    }

    public static class Handler {
        public static void handle(PacketCustomParticle message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                EntityPlayer player = DoggyTalentsMod.PROXY.getPlayerEntity();
                DoggyTalentsMod.PROXY.spawnCustomParticle(player, message.pos, player.func_70681_au(), message.posX, message.posY, message.posZ, message.numberOfParticles, message.particleSpeed);
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

