/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.network.client;

import doggytalents.entity.EntityDog;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketDogMode {
    public int entityId;
    public int doggyMode;

    public PacketDogMode(int entityId, int dogMode) {
        this.entityId = entityId;
        this.doggyMode = dogMode;
    }

    public static void encode(PacketDogMode msg, PacketBuffer buf) {
        buf.writeInt(msg.entityId);
        buf.writeInt(msg.doggyMode);
    }

    public static PacketDogMode decode(PacketBuffer buf) {
        int entityId = buf.readInt();
        int doggyMode = buf.readInt();
        return new PacketDogMode(entityId, doggyMode);
    }

    public static class Handler {
        public static void handle(PacketDogMode message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                Entity target = ((NetworkEvent.Context)ctx.get()).getSender().field_70170_p.func_73045_a(message.entityId);
                if (!(target instanceof EntityDog)) {
                    return;
                }
                EntityDog dog = (EntityDog)target;
                dog.MODE.setMode(message.doggyMode);
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

