/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.network.client;

import doggytalents.entity.EntityDog;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketDogTexture {
    public int entityId;
    public int doggyTexture;

    public PacketDogTexture(int entityId, int doggyTexture) {
        this.entityId = entityId;
        this.doggyTexture = doggyTexture;
    }

    public static void encode(PacketDogTexture msg, PacketBuffer buf) {
        buf.writeInt(msg.entityId);
        buf.writeInt(msg.doggyTexture);
    }

    public static PacketDogTexture decode(PacketBuffer buf) {
        int entityId = buf.readInt();
        int doggyTexture = buf.readInt();
        return new PacketDogTexture(entityId, doggyTexture);
    }

    public static class Handler {
        public static void handle(PacketDogTexture message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                Entity target = ((NetworkEvent.Context)ctx.get()).getSender().field_70170_p.func_73045_a(message.entityId);
                if (!(target instanceof EntityDog)) {
                    return;
                }
                EntityDog dog = (EntityDog)target;
                dog.setTameSkin(message.doggyTexture);
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

