/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.proxy;

import doggytalents.DoggyTalentsMod;
import doggytalents.ModBlocks;
import doggytalents.ModItems;
import doggytalents.client.gui.GuiHandler;
import doggytalents.client.model.block.IStateParticleModel;
import doggytalents.client.renderer.entity.RenderDog;
import doggytalents.client.renderer.entity.RenderDogBeam;
import doggytalents.client.renderer.particle.ParticleCustomLanding;
import doggytalents.entity.EntityDog;
import doggytalents.entity.EntityDoggyBeam;
import doggytalents.handler.GameOverlay;
import doggytalents.handler.InputUpdate;
import doggytalents.proxy.CommonProxy;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Particles;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReaderBase;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeColors;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@OnlyIn(value=Dist.CLIENT)
public class ClientProxy
extends CommonProxy {
    public ClientProxy() {
        DoggyTalentsMod.LOGGER.debug("Client Proxy");
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup);
    }

    private void clientSetup(FMLClientSetupEvent event) {
        DoggyTalentsMod.LOGGER.debug("ClientProxy clientSetup");
        ModLoadingContext.get().registerExtensionPoint(ExtensionPoint.GUIFACTORY, () -> GuiHandler::openGui);
        RenderingRegistry.registerEntityRenderingHandler(EntityDog.class, RenderDog::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityDoggyBeam.class, RenderDogBeam::new);
    }

    @Override
    protected void preInit(FMLCommonSetupEvent event) {
        super.preInit(event);
        MinecraftForge.EVENT_BUS.register((Object)new GameOverlay());
        MinecraftForge.EVENT_BUS.register((Object)new InputUpdate());
    }

    @Override
    protected void postInit(InterModProcessEvent event) {
        super.postInit(event);
        Minecraft.func_71410_x().getItemColors().func_199877_a((stack, tintIndex) -> stack.func_77942_o() && stack.func_77978_p().func_74764_b("collar_colour") ? stack.func_77978_p().func_74762_e("collar_colour") : -1, new IItemProvider[]{ModItems.WOOL_COLLAR});
        Minecraft.func_71410_x().getItemColors().func_199877_a((stack, tintIndex) -> stack.func_77942_o() && stack.func_77978_p().func_74764_b("cape_colour") ? stack.func_77978_p().func_74762_e("cape_colour") : -1, new IItemProvider[]{ModItems.CAPE_COLOURED});
        Minecraft.func_71410_x().getItemColors().func_199877_a((stack, tintIndex) -> 4159204, new IItemProvider[]{ModBlocks.DOG_BATH});
        Minecraft.func_71410_x().func_184125_al().func_186722_a((state, blockAccess, pos, tintIndex) -> blockAccess != null && pos != null ? BiomeColors.func_180288_c((IWorldReaderBase)blockAccess, (BlockPos)pos) : -1, new Block[]{ModBlocks.DOG_BATH});
    }

    @Override
    public EntityPlayer getPlayerEntity() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @Override
    public void spawnCustomParticle(EntityPlayer player, Object pos, Random rand, float posX, float posY, float posZ, int numberOfParticles, float particleSpeed) {
        TextureAtlasSprite sprite;
        IBlockState state = player.field_70170_p.func_180495_p((BlockPos)pos);
        IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_184389_a(state);
        if (model instanceof IStateParticleModel) {
            state = state.getExtendedState((IBlockReader)player.field_70170_p, (BlockPos)pos);
            sprite = ((IStateParticleModel)model).getParticleTexture(state);
        } else {
            sprite = model.func_177554_e();
        }
        ParticleManager manager = Minecraft.func_71410_x().field_71452_i;
        for (int i = 0; i < numberOfParticles; ++i) {
            double xSpeed = rand.nextGaussian() * (double)particleSpeed;
            double ySpeed = rand.nextGaussian() * (double)particleSpeed;
            double zSpeed = rand.nextGaussian() * (double)particleSpeed;
            ParticleCustomLanding particle = new ParticleCustomLanding(player.field_70170_p, posX, posY, posZ, xSpeed, ySpeed, zSpeed, state, (BlockPos)pos, sprite);
            manager.func_78873_a((Particle)particle);
        }
    }

    @Override
    public void spawnCrit(World world, Entity entity) {
        Minecraft.func_71410_x().field_71452_i.func_199282_a(entity, (IParticleData)Particles.field_197614_g);
    }
}

