/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.tileentity;

import doggytalents.ModTileEntities;
import doggytalents.entity.EntityDog;
import doggytalents.helper.DogUtil;
import doggytalents.inventory.ContainerFoodBowl;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IInteractionObject;

public class TileEntityFoodBowl
extends TileEntity
implements ISidedInventory,
IInteractionObject,
ITickable {
    private static final int[] SLOTS_ALL = new int[]{0, 1, 2, 3, 4};
    private NonNullList<ItemStack> bowlItemStacks = NonNullList.func_191197_a((int)5, (Object)ItemStack.field_190927_a);
    public int timeoutCounter;

    public TileEntityFoodBowl() {
        super(ModTileEntities.FOOD_BOWL);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.bowlItemStacks = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((NBTTagCompound)compound, this.bowlItemStacks);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        ItemStackHelper.func_191282_a((NBTTagCompound)compound, this.bowlItemStacks);
        return compound;
    }

    public void func_73660_a() {
        if (++this.timeoutCounter < 5) {
            return;
        }
        List dogList = this.field_145850_b.func_72872_a(EntityDog.class, new AxisAlignedBB(this.field_174879_c).func_72314_b(5.0, 5.0, 5.0));
        for (EntityDog dog : dogList) {
            if (!dog.COORDS.hasBowlPos()) {
                dog.COORDS.setBowlPos(this.field_174879_c);
            }
            int slotIndex = DogUtil.getFirstSlotWithFood(dog, (IInventory)this);
            if (dog.getDogHunger() >= 60 || slotIndex < 0) continue;
            DogUtil.feedDog(dog, (IInventory)this, slotIndex);
        }
        this.timeoutCounter = 0;
    }

    public int func_70302_i_() {
        return this.bowlItemStacks.size();
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.bowlItemStacks) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.bowlItemStacks.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.bowlItemStacks, (int)index, (int)count);
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.bowlItemStacks, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.bowlItemStacks.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
    }

    public void func_174888_l() {
        this.bowlItemStacks.clear();
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return !(player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) > 64.0);
    }

    public ITextComponent func_200201_e() {
        return null;
    }

    public ITextComponent func_200200_C_() {
        return new TextComponentTranslation("container.doggytalents.food_bowl", new Object[0]);
    }

    public boolean func_145818_k_() {
        return false;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public int[] func_180463_a(EnumFacing side) {
        if (side == EnumFacing.DOWN) {
            return SLOTS_ALL;
        }
        return new int[0];
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, @Nullable EnumFacing direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        Item item;
        return direction != EnumFacing.DOWN || index != 1 || (item = stack.func_77973_b()) == Items.field_151131_as || item == Items.field_151133_ar;
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerFoodBowl((IInventory)playerInventory, this);
    }

    public String func_174875_k() {
        return "doggytalents:food_bowl";
    }
}

