/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.block;

import doggytalents.api.inferface.IBedMaterial;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BedMaterial
implements IBedMaterial {
    @Nullable
    private String translationKey;
    public ResourceLocation key;
    public String textureLoc;
    public Ingredient ingredients;
    public String regName;

    public BedMaterial(ResourceLocation key, ResourceLocation texture, Ingredient ingredients) {
        this.key = key;
        this.textureLoc = texture.toString();
        this.ingredients = ingredients;
    }

    public BedMaterial(Block block, ResourceLocation texture, Ingredient ingredients) {
        this(ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)block), texture, ingredients);
    }

    @Override
    public String getTexture() {
        return this.textureLoc;
    }

    @Override
    public Ingredient getIngredient() {
        return this.ingredients;
    }

    @Override
    public ITextComponent getTooltip() {
        if (this.translationKey == null) {
            this.translationKey = Util.func_200697_a((String)("dogbed." + this.regName), (ResourceLocation)this.key);
        }
        return new TranslationTextComponent(this.translationKey, new Object[0]);
    }

    @Override
    public String getSaveId() {
        return this.key.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BedMaterial)) {
            return false;
        }
        BedMaterial other = (BedMaterial)o;
        return other.key.equals((Object)this.key);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    @Override
    public BedMaterial setRegName(String regName) {
        this.regName = regName;
        return this;
    }
}

