/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.block;

import doggytalents.DoggyTalentsMod;
import doggytalents.ModBlocks;
import doggytalents.api.inferface.IBedMaterial;
import doggytalents.api.inferface.IDogBedRegistry;
import doggytalents.block.BedMaterial;
import doggytalents.helper.Compatibility;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class DogBedRegistry
implements IDogBedRegistry {
    public static final DogBedRegistry CASINGS = new DogBedRegistry("casing");
    public static final DogBedRegistry BEDDINGS = new DogBedRegistry("bedding");
    private final List<IBedMaterial> REGISTRY = new ArrayList<IBedMaterial>();
    private final String key;

    public DogBedRegistry(String key) {
        this.key = key;
    }

    @Override
    public IBedMaterial registerMaterial(@Nonnull Block block, ResourceLocation textureLocation) {
        return this.registerMaterial(new BedMaterial(block, textureLocation, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{block})));
    }

    @Override
    public IBedMaterial registerMaterial(IBedMaterial material) {
        if (this.REGISTRY.contains(material)) {
            DoggyTalentsMod.LOGGER.warn("Tried to register a dog bed material with the id {} more that once", (Object)material);
            return null;
        }
        this.REGISTRY.add(material.setRegName(this.key));
        DoggyTalentsMod.LOGGER.debug("Register dog bed {} under the key {}", (Object)this.key, (Object)material);
        return material;
    }

    public List<IBedMaterial> getKeys() {
        return this.REGISTRY;
    }

    public IBedMaterial get(String saveId) {
        if (saveId.equals("missing")) {
            return IBedMaterial.NULL;
        }
        saveId = Compatibility.getBedOldNamingScheme(saveId);
        for (IBedMaterial thing : this.REGISTRY) {
            if (!thing.getSaveId().equals(saveId)) continue;
            return thing;
        }
        return IBedMaterial.getHolder(saveId);
    }

    public IBedMaterial getFromStack(ItemStack stack) {
        for (IBedMaterial m : this.REGISTRY) {
            if (!m.getIngredient().test(stack)) continue;
            return m;
        }
        return IBedMaterial.NULL;
    }

    public static ItemStack createItemStack(IBedMaterial casingId, IBedMaterial beddingId) {
        ItemStack stack = new ItemStack((IItemProvider)ModBlocks.DOG_BED, 1);
        CompoundNBT tag = stack.func_190925_c("doggytalents");
        tag.func_74778_a("casingId", casingId.getSaveId());
        tag.func_74778_a("beddingId", beddingId.getSaveId());
        return stack;
    }
}

