/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import doggytalents.api.DoggyTalentsAPI;
import doggytalents.api.feature.EnumMode;
import doggytalents.api.inferface.Talent;
import doggytalents.entity.EntityDog;
import doggytalents.lib.ConfigValues;
import doggytalents.network.PacketHandler;
import doggytalents.network.client.PacketDogMode;
import doggytalents.network.client.PacketDogName;
import doggytalents.network.client.PacketDogObey;
import doggytalents.network.client.PacketDogTalent;
import doggytalents.network.client.PacketDogTexture;
import doggytalents.network.client.PacketFriendlyFire;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.PacketDistributor;

@OnlyIn(value=Dist.CLIENT)
public class GuiDogInfo
extends Screen {
    public EntityDog dog;
    public PlayerEntity player;
    public int doggyTex;
    private int currentPage = 0;
    private int maxPages = 1;
    public int btnPerPages = 0;
    private final DecimalFormat dfShort = new DecimalFormat("0.0");
    private final DecimalFormat dfShortDouble = new DecimalFormat("0.00");

    public GuiDogInfo(EntityDog dog, PlayerEntity player) {
        super((ITextComponent)new TranslationTextComponent("doggytalents.screen.dog.title", new Object[0]));
        this.dog = dog;
        this.player = player;
    }

    public static void open(EntityDog dog) {
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_147108_a((Screen)new GuiDogInfo(dog, (PlayerEntity)mc.field_71439_g));
    }

    public void init() {
        this.buttons.clear();
        this.children.clear();
        super.init();
        this.minecraft.field_195559_v.func_197967_a(true);
        int topX = this.width / 2;
        int topY = this.height / 2;
        TextFieldWidget nameTextField = new TextFieldWidget(this.font, topX - 100, topY + 50, 200, 20, "TEST");
        nameTextField.func_212954_a(text -> PacketHandler.send(PacketDistributor.SERVER.noArg(), new PacketDogName(this.dog.func_145782_y(), (String)text)));
        nameTextField.func_146195_b(false);
        nameTextField.func_146203_f(32);
        if (this.dog.func_145818_k_()) {
            nameTextField.func_146180_a(this.dog.func_200201_e().func_150261_e());
        }
        this.addButton((Widget)nameTextField);
        this.doggyTex = this.dog.getTameSkin();
        int size = (int)DoggyTalentsAPI.TALENTS.getKeys().stream().filter(loc -> ConfigValues.ENABLED_TALENTS.getOrDefault(loc, false)).count();
        this.btnPerPages = Math.max(MathHelper.func_76128_c((double)((double)(this.height - 10) / 21.0)) - 2, 1);
        if (this.btnPerPages < size) {
            this.addButton((Widget)new Button(25, this.btnPerPages * 21 + 10, 20, 20, "<", button -> {
                if (this.currentPage > 0) {
                    --this.currentPage;
                    this.init();
                }
            }){

                public void renderToolTip(int mouseX, int mouseY) {
                    ArrayList<String> list = new ArrayList<String>();
                    list.add(TextFormatting.ITALIC + I18n.func_135052_a((String)"doggui.prevpage", (Object[])new Object[0]));
                    GuiDogInfo.this.renderTooltip(list, mouseX, mouseY, GuiDogInfo.this.font);
                }
            });
            this.addButton((Widget)new Button(48, this.btnPerPages * 21 + 10, 20, 20, ">", button -> {
                if (this.currentPage + 1 < this.maxPages) {
                    ++this.currentPage;
                    this.init();
                }
            }){

                public void renderToolTip(int mouseX, int mouseY) {
                    ArrayList<String> list = new ArrayList<String>();
                    list.add(TextFormatting.ITALIC + I18n.func_135052_a((String)"doggui.nextpage", (Object[])new Object[0]));
                    GuiDogInfo.this.renderTooltip(list, mouseX, mouseY, GuiDogInfo.this.font);
                }
            });
        }
        this.maxPages = MathHelper.func_76143_f((double)((double)size / (double)this.btnPerPages));
        if (this.currentPage >= this.maxPages) {
            this.currentPage = 0;
        }
        int i = -1;
        for (Talent talent : DoggyTalentsAPI.TALENTS.getValues()) {
            if (!ConfigValues.ENABLED_TALENTS.getOrDefault(talent.getRegistryName(), false).booleanValue() || ++i < this.currentPage * this.btnPerPages || i >= (this.currentPage + 1) * this.btnPerPages) continue;
            this.addButton((Widget)new TalentButton(25, 10 + (i - this.currentPage * this.btnPerPages) * 21, 20, 20, "+", talent, button -> {
                int level = this.dog.TALENTS.getLevel(button.talent);
                if (level < button.talent.getHighestLevel(this.dog) && this.dog.spendablePoints() >= button.talent.getCost(this.dog, level + 1)) {
                    PacketHandler.send(PacketDistributor.SERVER.noArg(), new PacketDogTalent(this.dog.func_145782_y(), button.talent.getRegistryName()));
                }
            }){

                public void renderToolTip(int mouseX, int mouseY) {
                    ArrayList<String> list = new ArrayList<String>();
                    list.add(TextFormatting.GREEN + I18n.func_135052_a((String)this.talent.getTranslationKey(), (Object[])new Object[0]));
                    list.add("Level: " + GuiDogInfo.this.dog.TALENTS.getLevel(this.talent));
                    list.add(TextFormatting.GRAY + "--------------------------------");
                    list.addAll(GuiDogInfo.this.splitInto(I18n.func_135052_a((String)this.talent.getInfoTranslationKey(), (Object[])new Object[0]), 200, GuiDogInfo.this.font));
                    GuiDogInfo.this.renderTooltip(list, mouseX, mouseY, GuiDogInfo.this.font);
                }
            });
        }
        if (ConfigValues.USE_DT_TEXTURES) {
            this.addButton((Widget)new Button(this.width - 42, topY + 30, 20, 20, "+", button -> {
                ++this.doggyTex;
                this.doggyTex %= 128;
                PacketHandler.send(PacketDistributor.SERVER.noArg(), new PacketDogTexture(this.dog.func_145782_y(), this.doggyTex));
            }));
            this.addButton((Widget)new Button(this.width - 64, topY + 30, 20, 20, "-", button -> {
                this.doggyTex += 127;
                this.doggyTex %= 128;
                PacketHandler.send(PacketDistributor.SERVER.noArg(), new PacketDogTexture(this.dog.func_145782_y(), this.doggyTex));
            }));
        }
        if (this.dog.func_152114_e((LivingEntity)this.player)) {
            this.addButton((Widget)new Button(this.width - 64, topY + 65, 42, 20, String.valueOf(this.dog.willObeyOthers()), button -> {
                button.setMessage(String.valueOf(!this.dog.willObeyOthers()));
                PacketHandler.send(PacketDistributor.SERVER.noArg(), new PacketDogObey(this.dog.func_145782_y(), !this.dog.willObeyOthers()));
            }));
        }
        this.addButton((Widget)new Button(this.width - 64, topY - 5, 42, 20, String.valueOf(this.dog.canPlayersAttack()), button -> {
            button.setMessage(String.valueOf(!this.dog.canPlayersAttack()));
            PacketHandler.send(PacketDistributor.SERVER.noArg(), new PacketFriendlyFire(this.dog.func_145782_y(), !this.dog.canPlayersAttack()));
        }));
        this.addButton((Widget)new Button(topX + 40, topY + 25, 60, 20, I18n.func_135052_a((String)this.dog.MODE.getMode().getUnlocalisedName(), (Object[])new Object[0]), button -> {
            EnumMode mode = this.dog.getMode().nextMode();
            if (mode == EnumMode.WANDERING && !this.dog.COORDS.hasBowlPos()) {
                button.setMessage(TextFormatting.RED + I18n.func_135052_a((String)mode.getUnlocalisedName(), (Object[])new Object[0]));
            } else {
                button.setMessage(I18n.func_135052_a((String)mode.getUnlocalisedName(), (Object[])new Object[0]));
            }
            PacketHandler.send(PacketDistributor.SERVER.noArg(), new PacketDogMode(this.dog.func_145782_y(), mode));
        }){

            public void renderToolTip(int mouseX, int mouseY) {
                ArrayList<String> list = new ArrayList<String>();
                String str = I18n.func_135052_a((String)GuiDogInfo.this.dog.MODE.getMode().getUnlocalisedInfo(), (Object[])new Object[0]);
                list.addAll(GuiDogInfo.this.splitInto(str, 150, GuiDogInfo.this.font));
                if (GuiDogInfo.this.dog.MODE.isMode(EnumMode.WANDERING)) {
                    if (!GuiDogInfo.this.dog.COORDS.hasBowlPos()) {
                        list.add(TextFormatting.RED + I18n.func_135052_a((String)"dog.mode.docile.nobowl", (Object[])new Object[0]));
                    } else if (GuiDogInfo.this.dog.func_180425_c().func_177951_i((Vec3i)GuiDogInfo.this.dog.COORDS.getBowlPos()) > 256.0) {
                        list.add(TextFormatting.RED + I18n.func_135052_a((String)"dog.mode.docile.distance", (Object[])new Object[]{(int)Math.sqrt(GuiDogInfo.this.dog.func_180425_c().func_177951_i((Vec3i)GuiDogInfo.this.dog.COORDS.getBowlPos()))}));
                    } else {
                        list.add(TextFormatting.GREEN + I18n.func_135052_a((String)"dog.mode.docile.bowl", (Object[])new Object[]{(int)Math.sqrt(GuiDogInfo.this.dog.func_180425_c().func_177951_i((Vec3i)GuiDogInfo.this.dog.COORDS.getBowlPos()))}));
                    }
                }
                GuiDogInfo.this.renderTooltip(list, mouseX, mouseY, GuiDogInfo.this.font);
            }
        });
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        int topX = this.width / 2;
        int topY = this.height / 2;
        this.renderBackground();
        String health = this.dfShort.format(this.dog.func_110143_aJ());
        String healthMax = this.dfShort.format(this.dog.func_110138_aP());
        String healthRel = this.dfShort.format(this.dog.getHealthRelative() * 100.0);
        String healthState = health + "/" + healthMax + " (" + healthRel + "%)";
        String speedValue = this.dfShortDouble.format(this.dog.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
        String ageValue = this.dfShortDouble.format(this.dog.func_70874_b());
        String ageRel = "";
        ageRel = this.dog.func_70631_g_() ? I18n.func_135052_a((String)"doggui.age.baby", (Object[])new Object[0]) : I18n.func_135052_a((String)"doggui.age.adult", (Object[])new Object[0]);
        String ageString = ageValue + " " + ageRel;
        String tamedString = "";
        if (this.dog.func_70909_n()) {
            tamedString = this.dog.func_152114_e((LivingEntity)this.player) ? I18n.func_135052_a((String)"doggui.owner.you", (Object[])new Object[0]) : this.dog.getOwnersName().func_150254_d();
        }
        this.font.func_211126_b(I18n.func_135052_a((String)"doggui.health", (Object[])new Object[0]) + healthState, (float)(this.width - 160), (float)(topY - 110), 0xFFFFFF);
        this.font.func_211126_b(I18n.func_135052_a((String)"doggui.speed", (Object[])new Object[0]) + speedValue, (float)(this.width - 160), (float)(topY - 100), 0xFFFFFF);
        this.font.func_211126_b(I18n.func_135052_a((String)"doggui.owner", (Object[])new Object[0]) + tamedString, (float)(this.width - 160), (float)(topY - 90), 0xFFFFFF);
        this.font.func_211126_b(I18n.func_135052_a((String)"doggui.age", (Object[])new Object[0]) + ageString, (float)(this.width - 160), (float)(topY - 80), 0xFFFFFF);
        if (ConfigValues.DOG_GENDER) {
            this.font.func_211126_b(I18n.func_135052_a((String)"doggui.gender", (Object[])new Object[0]) + this.dog.GENDER.getGenderName().func_150254_d(), (float)(this.width - 160), (float)(topY - 70), 0xFFFFFF);
        }
        this.font.func_211126_b(I18n.func_135052_a((String)"doggui.newname", (Object[])new Object[0]), (float)(topX - 100), (float)(topY + 38), 0x404040);
        this.font.func_211126_b(I18n.func_135052_a((String)"doggui.level", (Object[])new Object[0]) + " " + this.dog.LEVELS.getLevel(), (float)(topX - 65), (float)(topY + 75), 16716025);
        this.font.func_211126_b(I18n.func_135052_a((String)"doggui.leveldire", (Object[])new Object[0]) + " " + this.dog.LEVELS.getDireLevel(), (float)topX, (float)(topY + 75), 16716025);
        this.font.func_211126_b(I18n.func_135052_a((String)"doggui.pointsleft", (Object[])new Object[0]) + " " + this.dog.spendablePoints(), (float)(topX - 38), (float)(topY + 89), 0xFFFFFF);
        if (ConfigValues.USE_DT_TEXTURES) {
            this.font.func_211126_b(I18n.func_135052_a((String)"doggui.textureindex", (Object[])new Object[0]), (float)(this.width - 80), (float)(topY + 20), 0xFFFFFF);
        }
        if (this.dog.func_152114_e((LivingEntity)this.player)) {
            this.font.func_211126_b(I18n.func_135052_a((String)"doggui.obeyothers", (Object[])new Object[0]), (float)(this.width - 76), (float)(topY + 55), 0xFFFFFF);
        }
        this.font.func_211126_b(I18n.func_135052_a((String)"doggui.friendlyfire", (Object[])new Object[0]), (float)(this.width - 76), (float)(topY - 15), 0xFFFFFF);
        this.buttons.forEach(widget -> {
            if (widget instanceof TalentButton) {
                TalentButton talBut = (TalentButton)((Object)widget);
                this.font.func_211126_b(I18n.func_135052_a((String)talBut.talent.getTranslationKey(), (Object[])new Object[0]), (float)(talBut.x + 25), (float)(talBut.y + 7), 0xFFFFFF);
            }
        });
        GlStateManager.disableRescaleNormal();
        RenderHelper.func_74518_a();
        GlStateManager.disableLighting();
        GlStateManager.disableDepthTest();
        super.render(mouseX, mouseY, partialTicks);
        RenderHelper.func_74520_c();
        GlStateManager.pushMatrix();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.buttons.forEach(widget -> {
            if (widget.isMouseOver((double)mouseX, (double)mouseY)) {
                widget.renderToolTip(mouseX, mouseY);
            }
        });
        GlStateManager.popMatrix();
    }

    public void onClose() {
        super.onClose();
        this.minecraft.field_195559_v.func_197967_a(false);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public List<String> splitInto(String text, int maxLength, FontRenderer font) {
        ArrayList<String> list = new ArrayList<String>();
        String temp = "";
        String[] split = text.split(" ");
        for (int i = 0; i < split.length; ++i) {
            String str = split[i];
            int length = font.func_78256_a(temp + str);
            if (length > maxLength) {
                list.add(temp);
                temp = "";
            }
            temp = temp + str + " ";
            if (i != split.length - 1) continue;
            list.add(temp);
        }
        return list;
    }

    private static class TalentButton
    extends Button {
        protected Talent talent;

        private TalentButton(int x, int y, int widthIn, int heightIn, String buttonText, Talent talent, Consumer<TalentButton> onPress) {
            super(x, y, widthIn, heightIn, buttonText, button -> onPress.accept((TalentButton)button));
            this.talent = talent;
        }
    }
}

