/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.configuration;

import doggytalents.DoggyTalentsMod;
import doggytalents.api.DoggyTalentsAPI;
import doggytalents.lib.ConfigValues;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

public class ConfigHandler {
    private static ClientConfig CLIENT;
    private static ServerConfig SERVER;
    private static TalentConfig TALENT;
    private static ForgeConfigSpec CONFIG_SERVER_SPEC;
    private static ForgeConfigSpec CONFIG_CLIENT_SPEC;
    private static ForgeConfigSpec CONFIG_TALENT_SPEC;

    public static void init() {
        Pair commonPair = new ForgeConfigSpec.Builder().configure(ServerConfig::new);
        CONFIG_SERVER_SPEC = (ForgeConfigSpec)commonPair.getRight();
        SERVER = (ServerConfig)commonPair.getLeft();
        Pair clientPair = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        CONFIG_CLIENT_SPEC = (ForgeConfigSpec)clientPair.getRight();
        CLIENT = (ClientConfig)clientPair.getLeft();
        DoggyTalentsMod.LOGGER.debug("Register configs");
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, CONFIG_SERVER_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, CONFIG_CLIENT_SPEC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(ConfigHandler::loadConfig);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(ConfigHandler::reloadConfig);
    }

    public static void initTalentConfig() {
        Pair talentPair = new ForgeConfigSpec.Builder().configure(TalentConfig::new);
        CONFIG_TALENT_SPEC = (ForgeConfigSpec)talentPair.getRight();
        TALENT = (TalentConfig)talentPair.getLeft();
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, CONFIG_TALENT_SPEC, "doggytalents-talents.toml");
    }

    public static void loadConfig(ModConfig.Loading event) {
        ModConfig config = event.getConfig();
        if (config.getSpec() == CONFIG_CLIENT_SPEC) {
            ConfigHandler.refreshClient();
        } else if (config.getSpec() == CONFIG_SERVER_SPEC) {
            ConfigHandler.refreshServer();
        } else if (config.getSpec() == CONFIG_TALENT_SPEC) {
            ConfigHandler.refreshTalents();
        }
    }

    public static void reloadConfig(ModConfig.ConfigReloading event) {
        ModConfig config = event.getConfig();
        if (config.getSpec() == CONFIG_CLIENT_SPEC) {
            ConfigHandler.refreshClient();
        } else if (config.getSpec() == CONFIG_SERVER_SPEC) {
            ConfigHandler.refreshServer();
        } else if (config.getSpec() == CONFIG_TALENT_SPEC) {
            ConfigHandler.refreshTalents();
        }
    }

    public static void refreshServer() {
        DoggyTalentsMod.LOGGER.debug("Refresh Common Config");
        ConfigValues.DOGS_IMMORTAL = (Boolean)ConfigHandler.SERVER.DOGS_IMMORTAL.get();
        ConfigValues.TIME_TO_MATURE = (Integer)ConfigHandler.SERVER.TIME_TO_MATURE.get();
        ConfigValues.DISABLE_HUNGER = (Boolean)ConfigHandler.SERVER.DISABLE_HUNGER.get();
        ConfigValues.STARTING_ITEMS = (Boolean)ConfigHandler.SERVER.STARTING_ITEMS.get();
        ConfigValues.DOG_GENDER = (Boolean)ConfigHandler.SERVER.DOG_GENDER.get();
        ConfigValues.DOG_WHINE_WHEN_HUNGER_LOW = (Boolean)ConfigHandler.SERVER.DOG_WHINE_WHEN_HUNGER_LOW.get();
        ConfigValues.PUPS_GET_PARENT_LEVELS = (Boolean)ConfigHandler.SERVER.PUPS_GET_PARENT_LEVELS.get();
        ConfigValues.EAT_FOOD_ON_FLOOR = (Boolean)ConfigHandler.SERVER.EAT_FOOD_ON_FLOOR.get();
        ResourceLocation reviveResource = ResourceLocation.func_208304_a((String)((String)ConfigHandler.SERVER.REVIVE_ITEM.get()));
        ConfigValues.REVIVE_ITEM = ForgeRegistries.ITEMS.containsKey(reviveResource) ? (Item)ForgeRegistries.ITEMS.getValue(reviveResource) : Items.field_222070_lD;
    }

    public static void refreshClient() {
        DoggyTalentsMod.LOGGER.debug("Refresh Client Config");
        ConfigValues.DIRE_PARTICLES = (Boolean)ConfigHandler.CLIENT.DIRE_PARTICLES.get();
        ConfigValues.RENDER_BLOOD = (Boolean)ConfigHandler.CLIENT.RENDER_BLOOD.get();
        ConfigValues.RENDER_WINGS = (Boolean)ConfigHandler.CLIENT.RENDER_WINGS.get();
        ConfigValues.RENDER_CHEST = (Boolean)ConfigHandler.CLIENT.RENDER_CHEST.get();
        ConfigValues.RENDER_ARMOUR = (Boolean)ConfigHandler.CLIENT.RENDER_ARMOUR.get();
        ConfigValues.RENDER_SADDLE = (Boolean)ConfigHandler.CLIENT.RENDER_SADDLE.get();
        ConfigValues.USE_DT_TEXTURES = (Boolean)ConfigHandler.CLIENT.USE_DT_TEXTURES.get();
    }

    public static void refreshTalents() {
        DoggyTalentsMod.LOGGER.debug("Refresh Talents Config");
        ConfigValues.ENABLED_TALENTS.clear();
        ConfigHandler.TALENT.DISABLED_TALENTS.forEach((loc, val) -> ConfigValues.ENABLED_TALENTS.put((ResourceLocation)loc, (Boolean)val.get()));
    }

    static class TalentConfig {
        public Map<ResourceLocation, ForgeConfigSpec.BooleanValue> DISABLED_TALENTS;

        public TalentConfig(ForgeConfigSpec.Builder builder) {
            builder.comment("Here you can disable talents.").push("Talents");
            this.DISABLED_TALENTS = new HashMap<ResourceLocation, ForgeConfigSpec.BooleanValue>();
            DoggyTalentsAPI.TALENTS.getKeys().forEach(loc -> this.DISABLED_TALENTS.put((ResourceLocation)loc, builder.define(loc.toString(), true)));
            builder.pop();
        }
    }

    static class ServerConfig {
        public ForgeConfigSpec.BooleanValue DOGS_IMMORTAL;
        public ForgeConfigSpec.IntValue TIME_TO_MATURE;
        public ForgeConfigSpec.BooleanValue DISABLE_HUNGER;
        public ForgeConfigSpec.BooleanValue STARTING_ITEMS;
        public ForgeConfigSpec.BooleanValue DOG_GENDER;
        public ForgeConfigSpec.BooleanValue DOG_WHINE_WHEN_HUNGER_LOW;
        public ForgeConfigSpec.BooleanValue PUPS_GET_PARENT_LEVELS;
        public ForgeConfigSpec.BooleanValue EAT_FOOD_ON_FLOOR;
        public ForgeConfigSpec.ConfigValue<String> REVIVE_ITEM;
        public Map<String, ForgeConfigSpec.BooleanValue> DISABLED_TALENTS;

        public ServerConfig(ForgeConfigSpec.Builder builder) {
            builder.push("General");
            builder.pop();
            builder.push("Dog Constants");
            this.DOGS_IMMORTAL = builder.comment("Determines if dogs die when their health reaches zero. If true, dogs will not die, and will instead become incapacitated.").translation("doggytalents.config.dog.enable_immortality").define("enable_immortality", true);
            this.TIME_TO_MATURE = builder.comment("The time in ticks it takes for a baby dog to become an adult, default 48000 (2 Minecraft days) and minimum 0").translation("doggytalents.config.dog.time_to_mature").defineInRange("time_to_mature", 48000, 0, Integer.MAX_VALUE);
            this.DISABLE_HUNGER = builder.comment("Disable hunger mode for the dog").translation("doggytalents.config.dog.disable_hunger").define("disable_hunger", false);
            this.STARTING_ITEMS = builder.comment("When enabled you will spawn with a guide, Doggy Charm and Command Emblem.").translation("doggytalents.config.enable_starting_items").define("enable_starting_items", false);
            this.DOG_GENDER = builder.comment("When enabled, dogs will be randomly assigned genders and will only mate and produce children with the opposite gender.").translation("doggytalents.config.enable_gender").define("enable_gender", true);
            this.DOG_WHINE_WHEN_HUNGER_LOW = builder.comment("Determines if dogs should whine when hunger reaches below 20 DP.").translation("doggytalents.config.whine_when_hungry").define("whine_when_hungry", true);
            this.PUPS_GET_PARENT_LEVELS = builder.comment("When enabled, puppies get some levels from parents. When disabled, puppies start at 0 points.").translation("doggytalents.config.enable_pup_get_parent_levels").define("enable_pup_get_parent_levels", false);
            this.EAT_FOOD_ON_FLOOR = builder.comment("When enabled dogs will path and eat editable items in the world.").translation("doggytalents.config.eat_food_on_floor").define("eat_food_on_floor", true);
            this.REVIVE_ITEM = builder.comment("The item resource path that can be used to revive an incapacitated dog. If item is not valid defaults to minecraft:cake").translation("doggytalents.config.revive_item").define("revive_item", (Object)"minecraft:cake");
            builder.pop();
        }
    }

    static class ClientConfig {
        public ForgeConfigSpec.BooleanValue DIRE_PARTICLES;
        public ForgeConfigSpec.BooleanValue RENDER_BLOOD;
        public ForgeConfigSpec.BooleanValue RENDER_WINGS;
        public ForgeConfigSpec.BooleanValue RENDER_CHEST;
        public ForgeConfigSpec.BooleanValue RENDER_SADDLE;
        public ForgeConfigSpec.BooleanValue USE_DT_TEXTURES;
        public ForgeConfigSpec.BooleanValue RENDER_ARMOUR;

        public ClientConfig(ForgeConfigSpec.Builder builder) {
            builder.push("General");
            builder.pop();
            builder.push("Dog Render");
            this.DIRE_PARTICLES = builder.comment("Enables the particle effect on Dire Level 30 dogs.").translation("doggytalents.config.client.enable_dire_particles").define("enable_dire_particles", true);
            this.RENDER_BLOOD = builder.comment("When enabled, Dogs will show blood texture while incapacitated.").translation("doggytalents.config.client.render_incapacitated_overlay").define("render_incapacitated_overlay", true);
            this.RENDER_WINGS = builder.comment("When enabled, Dogs will have wings when at level 5 pillow paw.").translation("doggytalents.config.client.render_wings").define("render_wings", false);
            this.RENDER_CHEST = builder.comment("When enabled, dogs with points in pack puppy will have chests on their side.").translation("doggytalents.config.client.render_chest").define("render_chest", true);
            this.RENDER_SADDLE = builder.comment("When enabled, dogs with points in wolf mount will have a saddle on.").translation("doggytalents.config.client.render_saddle").define("render_saddle", true);
            this.RENDER_ARMOUR = builder.comment("When enabled, dogs with points in guard dog will have armour.").translation("doggytalents.config.client.render_armour").define("render_armour", false);
            this.USE_DT_TEXTURES = builder.comment("If disabled will use the default minecraft wolf skin for all dog textures.").translation("doggytalents.config.client.enable_dt_textures").define("enable_dt_textures", true);
            builder.pop();
        }
    }
}

