/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.entity;

import doggytalents.DoggyTalentsMod;
import doggytalents.ModBlocks;
import doggytalents.ModItems;
import doggytalents.ModSerializers;
import doggytalents.ModTags;
import doggytalents.ModTalents;
import doggytalents.api.feature.EnumGender;
import doggytalents.api.feature.EnumMode;
import doggytalents.api.feature.ICoordFeature;
import doggytalents.api.feature.IDog;
import doggytalents.api.feature.IGenderFeature;
import doggytalents.api.feature.IHungerFeature;
import doggytalents.api.feature.ILevelFeature;
import doggytalents.api.feature.IModeFeature;
import doggytalents.api.feature.IStatsFeature;
import doggytalents.api.feature.ITalentFeature;
import doggytalents.api.inferface.IDogEntity;
import doggytalents.api.inferface.IDogFoodItem;
import doggytalents.api.inferface.IDogItem;
import doggytalents.api.inferface.IThrowableItem;
import doggytalents.api.inferface.Talent;
import doggytalents.client.gui.GuiDogInfo;
import doggytalents.entity.ai.DogLocationManager;
import doggytalents.entity.ai.EntityAIBegDog;
import doggytalents.entity.ai.EntityAIBerserkerMode;
import doggytalents.entity.ai.EntityAIDogFeed;
import doggytalents.entity.ai.EntityAIDogWander;
import doggytalents.entity.ai.EntityAIExtinguishFire;
import doggytalents.entity.ai.EntityAIFetch;
import doggytalents.entity.ai.EntityAIFetchReturn;
import doggytalents.entity.ai.EntityAIFollowOwnerDog;
import doggytalents.entity.ai.EntityAIHurtByTargetDog;
import doggytalents.entity.ai.EntityAIIncapacitatedTargetDog;
import doggytalents.entity.ai.EntityAIOwnerHurtByTargetDog;
import doggytalents.entity.ai.EntityAIOwnerHurtTargetDog;
import doggytalents.entity.ai.EntityAIShepherdDog;
import doggytalents.entity.features.CoordFeature;
import doggytalents.entity.features.DogFeature;
import doggytalents.entity.features.GenderFeature;
import doggytalents.entity.features.HungerFeature;
import doggytalents.entity.features.LevelFeature;
import doggytalents.entity.features.ModeFeature;
import doggytalents.entity.features.StatsFeature;
import doggytalents.entity.features.TalentFeature;
import doggytalents.helper.CapabilityHelper;
import doggytalents.helper.DogUtil;
import doggytalents.helper.TalentHelper;
import doggytalents.item.ItemFancyCollar;
import doggytalents.lib.ConfigValues;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.SitGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.GhastEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.CatEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class EntityDog
extends IDogEntity
implements IDog {
    private static final DataParameter<Float> DATA_HEALTH_ID = EntityDataManager.func_187226_a(EntityDog.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Byte> DOG_TEXTURE = EntityDataManager.func_187226_a(EntityDog.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Integer> COLLAR_COLOUR = EntityDataManager.func_187226_a(EntityDog.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Byte> LEVEL = EntityDataManager.func_187226_a(EntityDog.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Byte> LEVEL_DIRE = EntityDataManager.func_187226_a(EntityDog.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Byte> DOG_FLAGS = EntityDataManager.func_187226_a(EntityDog.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Map<Talent, Integer>> TALENTS_PARAM = EntityDataManager.func_187226_a(EntityDog.class, ModSerializers.TALENT_LEVEL_SERIALIZER);
    private static final DataParameter<Integer> HUNGER_INT = EntityDataManager.func_187226_a(EntityDog.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<ItemStack> BONE_VARIANT = EntityDataManager.func_187226_a(EntityDog.class, (IDataSerializer)DataSerializers.field_187196_f);
    private static final DataParameter<Integer> CAPE = EntityDataManager.func_187226_a(EntityDog.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Optional<BlockPos>> BOWL_POS = EntityDataManager.func_187226_a(EntityDog.class, (IDataSerializer)DataSerializers.field_187201_k);
    private static final DataParameter<Optional<BlockPos>> BED_POS = EntityDataManager.func_187226_a(EntityDog.class, (IDataSerializer)DataSerializers.field_187201_k);
    private static final DataParameter<Byte> SIZE = EntityDataManager.func_187226_a(EntityDog.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Byte> GENDER_PARAM = EntityDataManager.func_187226_a(EntityDog.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Byte> MODE_PARAM = EntityDataManager.func_187226_a(EntityDog.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Optional<ITextComponent>> LAST_KNOWN_NAME = EntityDataManager.func_187226_a(EntityDog.class, (IDataSerializer)DataSerializers.field_200544_f);
    @Nullable
    public DogLocationManager locationManager;
    public TalentFeature TALENTS = new TalentFeature(this);
    public LevelFeature LEVELS = new LevelFeature(this);
    public ModeFeature MODE = new ModeFeature(this);
    public CoordFeature COORDS = new CoordFeature(this);
    public GenderFeature GENDER = new GenderFeature(this);
    public StatsFeature STATS;
    public HungerFeature HUNGER = new HungerFeature(this);
    private List<DogFeature> FEATURES;
    public Map<String, Object> objects;
    private float headRotationCourse;
    private float headRotationCourseOld;
    public boolean isWet;
    public boolean gotWetInWater;
    public boolean isShaking;
    private float timeWolfIsShaking;
    private float prevTimeWolfIsShaking;
    private float timeWolfIsHappy;
    private float prevTimeWolfIsHappy;
    private boolean isWolfHappy;
    public boolean hiyaMaster;
    private int hungerTick;
    private int prevHungerTick;
    private int healingTick;
    private int prevHealingTick;
    private int regenerationTick;
    private int prevRegenerationTick;
    private int reversionTime;
    protected boolean dogJumping;
    protected float jumpPower;

    public EntityDog(EntityType<EntityDog> type, World worldIn) {
        super(type, worldIn);
        this.STATS = new StatsFeature(this);
        this.FEATURES = Arrays.asList(this.TALENTS, this.LEVELS, this.MODE, this.COORDS, this.GENDER, this.HUNGER, this.STATS);
        if (worldIn instanceof ServerWorld) {
            this.locationManager = DogLocationManager.getHandler((ServerWorld)this.func_130014_f_());
        }
        this.objects = new HashMap<String, Object>();
        this.func_70903_f(false);
        this.setGender(this.func_70681_au().nextBoolean() ? EnumGender.MALE : EnumGender.FEMALE);
        TalentHelper.onClassCreation(this);
    }

    protected void func_184651_r() {
        this.field_70911_d = new SitGoal((TameableEntity)this);
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new EntityAIExtinguishFire((MobEntity)this, 1.15, 16));
        this.field_70714_bg.func_75776_a(2, (Goal)this.field_70911_d);
        this.field_70714_bg.func_75776_a(3, (Goal)new EntityAIFetchReturn(this, 1.0));
        this.field_70714_bg.func_75776_a(4, (Goal)new EntityAIDogWander(this, 1.0));
        this.field_70714_bg.func_75776_a(5, (Goal)new LeapAtTargetGoal((MobEntity)this, 0.4f));
        this.field_70714_bg.func_75776_a(6, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, true));
        this.field_70714_bg.func_75776_a(7, (Goal)new EntityAIShepherdDog(this, 1.0, 8.0f, entity -> !(entity instanceof EntityDog)));
        this.field_70714_bg.func_75776_a(8, (Goal)new EntityAIFetch(this, 1.0, 32.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new EntityAIFollowOwnerDog(this, 1.0, 10.0f, 2.0f));
        this.field_70714_bg.func_75776_a(12, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(13, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(14, (Goal)new EntityAIBegDog(this, 8.0f));
        this.field_70714_bg.func_75776_a(15, (Goal)new EntityAIDogFeed(this, 1.0, 20.0f));
        this.field_70714_bg.func_75776_a(25, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(25, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(0, (Goal)new EntityAIIncapacitatedTargetDog(this));
        this.field_70715_bh.func_75776_a(1, (Goal)new EntityAIOwnerHurtByTargetDog(this));
        this.field_70715_bh.func_75776_a(2, (Goal)new EntityAIOwnerHurtTargetDog(this));
        this.field_70715_bh.func_75776_a(3, (Goal)new EntityAIHurtByTargetDog(this).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(4, new EntityAIBerserkerMode<MonsterEntity>(this, MonsterEntity.class, false));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DATA_HEALTH_ID, (Object)Float.valueOf(this.func_110143_aJ()));
        this.field_70180_af.func_187214_a(DOG_FLAGS, (Object)0);
        this.field_70180_af.func_187214_a(DOG_TEXTURE, (Object)0);
        this.field_70180_af.func_187214_a(COLLAR_COLOUR, (Object)-2);
        this.field_70180_af.func_187214_a(TALENTS_PARAM, Collections.emptyMap());
        this.field_70180_af.func_187214_a(HUNGER_INT, (Object)60);
        this.field_70180_af.func_187214_a(BONE_VARIANT, (Object)ItemStack.field_190927_a);
        this.field_70180_af.func_187214_a(MODE_PARAM, (Object)((byte)EnumMode.DOCILE.getIndex()));
        this.field_70180_af.func_187214_a(LEVEL, (Object)0);
        this.field_70180_af.func_187214_a(LEVEL_DIRE, (Object)0);
        this.field_70180_af.func_187214_a(BOWL_POS, Optional.empty());
        this.field_70180_af.func_187214_a(BED_POS, Optional.empty());
        this.field_70180_af.func_187214_a(CAPE, (Object)-2);
        this.field_70180_af.func_187214_a(SIZE, (Object)3);
        this.field_70180_af.func_187214_a(GENDER_PARAM, (Object)((byte)EnumGender.UNISEX.getIndex()));
        this.field_70180_af.func_187214_a(LAST_KNOWN_NAME, Optional.empty());
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        if (SIZE.equals(key)) {
            this.func_213323_x_();
        }
    }

    public float func_213355_cm() {
        if (this.func_70631_g_()) {
            return 0.5f;
        }
        return (float)this.getDogSize() * 0.3f + 0.1f;
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        this.field_70180_af.func_187227_b(DATA_HEALTH_ID, (Object)Float.valueOf(this.func_110143_aJ()));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.3f);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(this.func_70909_n() ? 20.0 : 8.0);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0);
    }

    protected SoundEvent func_184639_G() {
        if (this.getDogHunger() <= ConfigValues.LOW_HUNGER && ConfigValues.DOG_WHINE_WHEN_HUNGER_LOW) {
            return SoundEvents.field_187871_gL;
        }
        if (this.field_70146_Z.nextInt(3) == 0) {
            return this.func_70909_n() && ((Float)this.field_70180_af.func_187225_a(DATA_HEALTH_ID)).floatValue() < this.func_110138_aP() / 2.0f ? SoundEvents.field_187871_gL : SoundEvents.field_187865_gI;
        }
        return SoundEvents.field_187857_gE;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_187869_gK, 0.15f, 1.0f);
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187863_gH;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187859_gF;
    }

    @Override
    public float func_70599_aP() {
        return 0.4f;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        this.FEATURES.forEach(f -> f.writeAdditional(compound));
        compound.func_74768_a("doggyTex", this.getTameSkin());
        compound.func_74768_a("collarColour", this.getCollarData());
        compound.func_74768_a("dogHunger", this.getDogHunger());
        compound.func_74757_a("willObey", this.willObeyOthers());
        compound.func_74757_a("friendlyFire", this.canPlayersAttack());
        compound.func_74757_a("radioCollar", this.hasRadarCollar());
        compound.func_74757_a("sunglasses", this.hasSunglasses());
        compound.func_74768_a("capeData", this.getCapeData());
        compound.func_74768_a("dogSize", this.getDogSize());
        compound.func_74757_a("hasBone", this.hasBone());
        if (this.hasBone()) {
            compound.func_218657_a("fetchItem", (INBT)this.getBoneVariant().func_77955_b(new CompoundNBT()));
        }
        if (((Optional)this.field_70180_af.func_187225_a(LAST_KNOWN_NAME)).isPresent()) {
            compound.func_74778_a("lastKnownOwnerName", ITextComponent.Serializer.func_150696_a((ITextComponent)((ITextComponent)((Optional)this.field_70180_af.func_187225_a(LAST_KNOWN_NAME)).get())));
        }
        TalentHelper.writeAdditional(this, compound);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.FEATURES.forEach(f -> f.readAdditional(compound));
        this.setTameSkin(compound.func_74762_e("doggyTex"));
        if (compound.func_150297_b("collarColour", 99)) {
            this.setCollarData(compound.func_74762_e("collarColour"));
        }
        this.setDogHunger(compound.func_74762_e("dogHunger"));
        this.setWillObeyOthers(compound.func_74767_n("willObey"));
        this.setCanPlayersAttack(compound.func_74767_n("friendlyFire"));
        this.hasRadarCollar(compound.func_74767_n("radioCollar"));
        this.setHasSunglasses(compound.func_74767_n("sunglasses"));
        if (compound.func_150297_b("capeData", 99)) {
            this.setCapeData(compound.func_74762_e("capeData"));
        }
        if (compound.func_150297_b("dogSize", 99)) {
            this.setDogSize(compound.func_74762_e("dogSize"));
        }
        if (compound.func_150297_b("fetchItem", 10)) {
            this.setBoneVariant(ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("fetchItem")));
        }
        if (compound.func_150297_b("lastKnownOwnerName", 8)) {
            this.field_70180_af.func_187227_b(LAST_KNOWN_NAME, Optional.of(ITextComponent.Serializer.func_150699_a((String)compound.func_74779_i("lastKnownOwnerName"))));
        }
        TalentHelper.readAdditional(this, compound);
        if (compound.func_74764_b("dogName")) {
            this.func_200203_b((ITextComponent)new StringTextComponent(compound.func_74779_i("dogName")));
        }
        if (compound.func_74767_n("hasBone")) {
            int variant = compound.func_74762_e("boneVariant");
            if (variant == 0) {
                this.setBoneVariant(new ItemStack((IItemProvider)ModItems.THROW_BONE));
            } else if (variant == 1) {
                this.setBoneVariant(new ItemStack((IItemProvider)ModItems.THROW_STICK));
            }
        }
    }

    public void func_70636_d() {
        Entity entityRidden;
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && this.isWet && !this.isShaking && !this.func_70781_l() && this.field_70122_E) {
            this.isShaking = true;
            this.timeWolfIsShaking = 0.0f;
            this.prevTimeWolfIsShaking = 0.0f;
            this.field_70170_p.func_72960_a((Entity)this, (byte)8);
        }
        if (!ConfigValues.DISABLE_HUNGER) {
            this.prevHungerTick = this.hungerTick++;
            if (this.func_184207_aI() || !this.func_70906_o()) {
                // empty if block
            }
            this.hungerTick += TalentHelper.hungerTick(this, this.hungerTick - this.prevHungerTick);
            if (this.hungerTick > 400) {
                this.setDogHunger(this.getDogHunger() - 1);
                this.hungerTick -= 400;
            }
        }
        if (ConfigValues.DOGS_IMMORTAL) {
            this.prevRegenerationTick = this.regenerationTick++;
            if (this.func_70906_o()) {
                this.regenerationTick += TalentHelper.regenerationTick(this, this.regenerationTick - this.prevRegenerationTick);
            } else if (!this.func_70906_o()) {
                this.regenerationTick = 0;
            }
            if (this.regenerationTick >= 2400 && this.isIncapacicated()) {
                this.func_70606_j(2.0f);
                this.setDogHunger(1);
            } else if (this.regenerationTick >= 2400 && !this.isIncapacicated() && this.regenerationTick >= 4400 && this.getDogHunger() < 60) {
                this.setDogHunger(this.getDogHunger() + 1);
                this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                this.regenerationTick = 2400;
            }
        }
        if (this.func_110143_aJ() != (float)ConfigValues.LOW_HEATH_LEVEL) {
            this.prevHealingTick = this.healingTick;
            this.healingTick += this.nourishment();
            if (this.healingTick >= 6000) {
                if (this.func_110143_aJ() < this.func_110138_aP()) {
                    this.func_70606_j(this.func_110143_aJ() + 1.0f);
                }
                this.healingTick = 0;
            }
        }
        if (this.func_110143_aJ() <= 0.0f && this.isImmortal()) {
            this.field_70725_aQ = 0;
            this.func_70606_j(1.0f);
        }
        if (this.field_70170_p.field_72995_K && this.LEVELS.isDireDog() && ConfigValues.DIRE_PARTICLES) {
            for (int i = 0; i < 2; ++i) {
                double width = this.func_213305_a((Pose)this.func_213283_Z()).field_220315_a;
                double height = this.func_213305_a((Pose)this.func_213283_Z()).field_220316_b;
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197599_J, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * width, this.field_70163_u + this.field_70146_Z.nextDouble() * height - 0.25, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * width, (this.field_70146_Z.nextDouble() - 0.5) * 2.0, -this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0);
            }
        }
        if (this.reversionTime > 0) {
            --this.reversionTime;
        }
        if ((entityRidden = this.func_184187_bx()) instanceof PlayerEntity && entityRidden.func_70093_af()) {
            this.func_184210_p();
        }
        if (this.field_70173_aa % 50 == 0 && this.COORDS.hasBowlPos() && this.field_70170_p.func_175667_e(this.COORDS.getBowlPos()) && this.field_70170_p.func_180495_p(this.COORDS.getBowlPos()).func_177230_c() != ModBlocks.FOOD_BOWL) {
            this.COORDS.setBowlPos(null);
        }
        TalentHelper.livingTick(this);
    }

    public void func_70071_h_() {
        float distanceToOwner;
        PlayerEntity player;
        super.func_70071_h_();
        this.headRotationCourseOld = this.headRotationCourse;
        this.headRotationCourse = this.isBegging() ? (this.headRotationCourse += (1.0f - this.headRotationCourse) * 0.4f) : (this.headRotationCourse += (0.0f - this.headRotationCourse) * 0.4f);
        if (this.func_203008_ap()) {
            this.isWet = true;
            this.isShaking = false;
            this.timeWolfIsShaking = 0.0f;
            this.prevTimeWolfIsShaking = 0.0f;
            this.gotWetInWater = this.func_70090_H();
        } else if ((this.isWet || this.isShaking) && this.isShaking) {
            if (this.timeWolfIsShaking == 0.0f) {
                this.func_184185_a(SoundEvents.field_187867_gJ, this.func_70599_aP(), (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            }
            this.prevTimeWolfIsShaking = this.timeWolfIsShaking;
            this.timeWolfIsShaking += 0.05f;
            if (this.prevTimeWolfIsShaking >= 2.0f) {
                this.isWet = false;
                this.isShaking = false;
                this.prevTimeWolfIsShaking = 0.0f;
                this.timeWolfIsShaking = 0.0f;
                TalentHelper.onFinishShaking(this, this.gotWetInWater);
            }
            if (this.timeWolfIsShaking > 0.4f) {
                float f = (float)this.func_174813_aQ().field_72338_b;
                int i = (int)(MathHelper.func_76126_a((float)((this.timeWolfIsShaking - 0.4f) * (float)Math.PI)) * 7.0f);
                Vec3d vec3d = this.func_213322_ci();
                for (int j = 0; j < i; ++j) {
                    float f1 = (this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * this.func_213311_cf() * 0.5f;
                    float f2 = (this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * this.func_213311_cf() * 0.5f;
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_218422_X, this.field_70165_t + (double)f1, (double)(f + 0.8f), this.field_70161_v + (double)f2, vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c);
                }
            }
        }
        if (this.field_70146_Z.nextInt(200) == 0) {
            this.hiyaMaster = true;
        }
        if ((this.isBegging() || this.hiyaMaster) && !this.isWolfHappy) {
            this.isWolfHappy = true;
            this.timeWolfIsHappy = 0.0f;
            this.prevTimeWolfIsHappy = 0.0f;
        } else {
            this.hiyaMaster = false;
        }
        if (this.isWolfHappy) {
            if (this.timeWolfIsHappy % 1.0f == 0.0f) {
                this.func_184185_a(SoundEvents.field_187865_gI, this.func_70599_aP(), (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            }
            this.prevTimeWolfIsHappy = this.timeWolfIsHappy;
            this.timeWolfIsHappy += 0.05f;
            if (this.prevTimeWolfIsHappy >= 8.0f) {
                this.isWolfHappy = false;
                this.prevTimeWolfIsHappy = 0.0f;
                this.timeWolfIsHappy = 0.0f;
            }
        }
        if (this.func_70909_n() && (player = (PlayerEntity)this.func_70902_q()) != null && (distanceToOwner = player.func_70032_d((Entity)this)) <= 2.0f && this.hasBone() && !this.field_70170_p.field_72995_K) {
            IThrowableItem throwableItem = this.getThrowableItem();
            ItemStack fetchItem = throwableItem != null ? throwableItem.getReturnStack(this.getBoneVariant()) : this.getBoneVariant();
            this.func_70099_a(fetchItem, 0.0f);
            this.setBoneVariant(ItemStack.field_190927_a);
        }
        if (this.field_70173_aa % 40 == 0 && !this.field_70170_p.field_72995_K) {
            if (this.func_70089_S()) {
                this.locationManager.update(this);
            } else {
                this.locationManager.remove(this);
            }
            if (this.func_70902_q() != null) {
                this.field_70180_af.func_187227_b(LAST_KNOWN_NAME, Optional.ofNullable(this.func_70902_q().func_145748_c_()));
            }
        }
        TalentHelper.tick(this);
        this.FEATURES.forEach(DogFeature::tick);
    }

    public boolean func_184645_a(PlayerEntity player, Hand hand) {
        ActionResultType result = TalentHelper.interactWithPlayer(this, player, hand);
        switch (result) {
            case SUCCESS: {
                return true;
            }
            case FAIL: {
                return false;
            }
        }
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b() == ModItems.OWNER_CHANGE && player.field_71075_bZ.field_75098_d && !this.func_152114_e((LivingEntity)player)) {
            if (!this.field_70170_p.field_72995_K) {
                this.func_70903_f(true);
                this.field_70699_by.func_75499_g();
                this.func_70624_b(null);
                this.field_70911_d.func_75270_a(true);
                this.func_184754_b(player.func_110124_au());
                this.func_70908_e(true);
                this.field_70170_p.func_72960_a((Entity)this, (byte)7);
            }
            return true;
        }
        if (this.func_70909_n()) {
            if (!stack.func_190926_b()) {
                int foodValue = this.foodValue(stack, (Entity)player);
                if (foodValue != 0 && this.getDogHunger() < this.HUNGER.getMaxHunger() && this.canInteract((LivingEntity)player) && !this.isIncapacicated()) {
                    if (this.isIncapacicated()) {
                        if (!this.field_70170_p.field_72995_K) {
                            player.func_145747_a((ITextComponent)new TranslationTextComponent("dog.mode.incapacitated.help", new Object[]{this.func_145748_c_(), this.GENDER.getGenderPronoun()}));
                        }
                    } else {
                        this.func_175505_a(player, stack);
                        if (!this.field_70170_p.field_72995_K) {
                            this.setDogHunger(this.getDogHunger() + foodValue);
                            if (stack.func_77973_b() instanceof IDogFoodItem) {
                                IDogFoodItem dogFood = (IDogFoodItem)stack.func_77973_b();
                                dogFood.onItemConsumed(this, stack, (Entity)player);
                            }
                        }
                        this.func_70908_e(true);
                    }
                    return true;
                }
                if (stack.func_77973_b() == ModItems.DOGGY_CHARM && player.field_71075_bZ.field_75098_d) {
                    EntityDog babySpawn;
                    if (!this.field_70170_p.field_72995_K && (babySpawn = this.createChild((AgeableEntity)this)) != null) {
                        babySpawn.func_70873_a(-ConfigValues.TIME_TO_MATURE);
                        babySpawn.func_70903_f(true);
                        if (ConfigValues.PUPS_GET_PARENT_LEVELS) {
                            babySpawn.LEVELS.setLevel(Math.min(this.LEVELS.getLevel(), 20));
                        }
                        babySpawn.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0f, 0.0f);
                        this.field_70170_p.func_217376_c((Entity)babySpawn);
                        this.func_175505_a(player, stack);
                    }
                    return true;
                }
                if (stack.func_77973_b() == Items.field_151055_y && this.canInteract((LivingEntity)player)) {
                    if (this.isIncapacicated()) {
                        if (!this.field_70170_p.field_72995_K) {
                            player.func_145747_a((ITextComponent)new TranslationTextComponent("dog.mode.incapacitated.help", new Object[]{this.func_145748_c_(), this.GENDER.getGenderPronoun()}));
                        }
                    } else if (this.field_70170_p.field_72995_K) {
                        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> GuiDogInfo.open(this));
                    }
                    return true;
                }
                if (stack.func_77973_b() == ModItems.RADIO_COLLAR && this.canInteract((LivingEntity)player) && !this.hasRadarCollar() && !this.isIncapacicated()) {
                    this.hasRadarCollar(true);
                    this.func_175505_a(player, stack);
                    return true;
                }
                if (stack.func_77973_b() == ModItems.WOOL_COLLAR && this.canInteract((LivingEntity)player) && !this.hasCollar() && !this.isIncapacicated()) {
                    int colour = -1;
                    if (stack.func_77942_o() && stack.func_77978_p().func_150297_b("collar_colour", 99)) {
                        colour = stack.func_77978_p().func_74762_e("collar_colour");
                    }
                    this.setCollarData(colour);
                    this.func_175505_a(player, stack);
                    return true;
                }
                if (stack.func_77973_b() instanceof ItemFancyCollar && this.canInteract((LivingEntity)player) && !this.hasCollar() && !this.isIncapacicated()) {
                    this.setCollarData(-3 - ((ItemFancyCollar)stack.func_77973_b()).type.ordinal());
                    this.func_175505_a(player, stack);
                    return true;
                }
                if (stack.func_77973_b() == ModItems.CAPE && this.canInteract((LivingEntity)player) && !this.hasCape() && !this.isIncapacicated()) {
                    this.setFancyCape();
                    if (!player.field_71075_bZ.field_75098_d) {
                        stack.func_190918_g(1);
                    }
                    return true;
                }
                if (stack.func_77973_b() == ModItems.LEATHER_JACKET && this.canInteract((LivingEntity)player) && !this.hasCape() && !this.isIncapacicated()) {
                    this.setLeatherJacket();
                    if (!player.field_71075_bZ.field_75098_d) {
                        stack.func_190918_g(1);
                    }
                    return true;
                }
                if (stack.func_77973_b() == ModItems.CAPE_COLOURED && this.canInteract((LivingEntity)player) && !this.hasCape() && !this.isIncapacicated()) {
                    int colour = -1;
                    if (stack.func_77942_o() && stack.func_77978_p().func_150297_b("cape_colour", 99)) {
                        colour = stack.func_77978_p().func_74762_e("cape_colour");
                    }
                    this.setCapeData(colour);
                    this.func_175505_a(player, stack);
                    return true;
                }
                if (stack.func_77973_b() == ModItems.SUNGLASSES && this.canInteract((LivingEntity)player) && !this.hasSunglasses() && !this.isIncapacicated()) {
                    this.setHasSunglasses(true);
                    this.func_175505_a(player, stack);
                    return true;
                }
                if (stack.func_77973_b() instanceof IDogItem && this.canInteract((LivingEntity)player) && !this.isIncapacicated()) {
                    IDogItem treat = (IDogItem)stack.func_77973_b();
                    ActionResultType treatResult = treat.onInteractWithDog(this, this.field_70170_p, player, hand);
                    switch (treatResult) {
                        case SUCCESS: {
                            return true;
                        }
                        case FAIL: {
                            return false;
                        }
                    }
                } else {
                    if (stack.func_77973_b() == ModItems.COLLAR_SHEARS && this.canInteract((LivingEntity)player)) {
                        if (!this.field_70170_p.field_72995_K) {
                            if (this.hasCollar() || this.hasSunglasses() || this.hasCape()) {
                                this.reversionTime = 40;
                                if (this.hasCollarColoured()) {
                                    ItemStack collarDrop = new ItemStack((IItemProvider)ModItems.WOOL_COLLAR, 1);
                                    if (this.isCollarColoured()) {
                                        collarDrop.func_77982_d(new CompoundNBT());
                                        collarDrop.func_77978_p().func_74768_a("collar_colour", this.getCollarData());
                                    }
                                    this.func_70099_a(collarDrop, 1.0f);
                                    this.setNoCollar();
                                }
                                if (this.hasFancyCollar()) {
                                    Item drop = ModItems.MULTICOLOURED_COLLAR;
                                    if (this.getCollarData() == -3) {
                                        drop = ModItems.CREATIVE_COLLAR;
                                    } else if (this.getCollarData() == -4) {
                                        drop = ModItems.SPOTTED_COLLAR;
                                    }
                                    this.func_199702_a((IItemProvider)drop, 1);
                                    this.setNoCollar();
                                }
                                if (this.hasFancyCape()) {
                                    this.func_70099_a(new ItemStack((IItemProvider)ModItems.CAPE, 1), 1.0f);
                                    this.setNoCape();
                                }
                                if (this.hasCapeColoured()) {
                                    ItemStack capeDrop = new ItemStack((IItemProvider)ModItems.CAPE_COLOURED, 1);
                                    if (this.isCapeColoured()) {
                                        capeDrop.func_77982_d(new CompoundNBT());
                                        capeDrop.func_77978_p().func_74768_a("cape_colour", this.getCapeData());
                                    }
                                    this.func_70099_a(capeDrop, 1.0f);
                                    this.setNoCape();
                                }
                                if (this.hasLeatherJacket()) {
                                    this.func_70099_a(new ItemStack((IItemProvider)ModItems.LEATHER_JACKET, 1), 1.0f);
                                    this.setNoCape();
                                }
                                if (this.hasSunglasses()) {
                                    this.func_70099_a(new ItemStack((IItemProvider)ModItems.SUNGLASSES, 1), 1.0f);
                                    this.setHasSunglasses(false);
                                }
                            } else if (this.reversionTime < 1) {
                                this.func_70903_f(false);
                                this.field_70699_by.func_75499_g();
                                this.field_70911_d.func_75270_a(false);
                                this.func_70606_j(8.0f);
                                this.TALENTS.resetTalents();
                                this.func_184754_b(null);
                                this.field_70180_af.func_187227_b(LAST_KNOWN_NAME, Optional.empty());
                                this.setWillObeyOthers(false);
                                this.MODE.setMode(EnumMode.DOCILE);
                                if (this.hasRadarCollar()) {
                                    this.func_199703_a((IItemProvider)ModItems.RADIO_COLLAR);
                                }
                                this.hasRadarCollar(false);
                                this.reversionTime = 40;
                            }
                        }
                        return true;
                    }
                    if (stack.func_77973_b() == ConfigValues.REVIVE_ITEM && this.canInteract((LivingEntity)player) && this.isIncapacicated()) {
                        this.func_175505_a(player, stack);
                        if (!this.field_70170_p.field_72995_K) {
                            this.field_70911_d.func_75270_a(true);
                            this.func_70606_j(this.func_110138_aP());
                            this.setDogHunger(ConfigValues.HUNGER_POINTS);
                            this.regenerationTick = 0;
                            this.func_70624_b(null);
                            this.func_70908_e(true);
                            this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                        }
                        return true;
                    }
                    if (stack.func_77973_b().func_206844_a(Tags.Items.DYES) && this.canInteract((LivingEntity)player) && this.hasCollarColoured()) {
                        if (!this.field_70170_p.field_72995_K) {
                            int[] aint = new int[3];
                            int maxCompSum = 0;
                            int count = 1;
                            DyeColor colour = DyeColor.getColor((ItemStack)stack);
                            if (colour == null) {
                                return false;
                            }
                            float[] afloat = colour.func_193349_f();
                            int l1 = (int)(afloat[0] * 255.0f);
                            int i2 = (int)(afloat[1] * 255.0f);
                            int j2 = (int)(afloat[2] * 255.0f);
                            maxCompSum += Math.max(l1, Math.max(i2, j2));
                            aint[0] = aint[0] + l1;
                            aint[1] = aint[1] + i2;
                            aint[2] = aint[2] + j2;
                            if (this.isCollarColoured()) {
                                int l = this.getCollarData();
                                float f = (float)(l >> 16 & 0xFF) / 255.0f;
                                float f1 = (float)(l >> 8 & 0xFF) / 255.0f;
                                float f2 = (float)(l & 0xFF) / 255.0f;
                                maxCompSum = (int)((float)maxCompSum + Math.max(f, Math.max(f1, f2)) * 255.0f);
                                aint[0] = (int)((float)aint[0] + f * 255.0f);
                                aint[1] = (int)((float)aint[1] + f1 * 255.0f);
                                aint[2] = (int)((float)aint[2] + f2 * 255.0f);
                                ++count;
                            }
                            int i1 = aint[0] / count;
                            int j1 = aint[1] / count;
                            int k1 = aint[2] / count;
                            float f3 = (float)maxCompSum / (float)count;
                            float f4 = Math.max(i1, Math.max(j1, k1));
                            i1 = (int)((float)i1 * f3 / f4);
                            j1 = (int)((float)j1 * f3 / f4);
                            k1 = (int)((float)k1 * f3 / f4);
                            int k2 = (i1 << 8) + j1;
                            k2 = (k2 << 8) + k1;
                            this.setCollarData(k2);
                        }
                        return true;
                    }
                    if (stack.func_77973_b() == ModItems.TREAT_BAG && this.getDogHunger() < ConfigValues.HUNGER_POINTS && this.canInteract((LivingEntity)player) && !this.isIncapacicated()) {
                        IItemHandler treatBag = (IItemHandler)CapabilityHelper.getOrThrow(stack, CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
                        DogUtil.feedDogFrom(this, treatBag);
                        return true;
                    }
                }
            }
            if (!this.func_70877_b(stack) && this.canInteract((LivingEntity)player)) {
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70911_d.func_75270_a(!this.func_70906_o());
                    this.field_70703_bu = false;
                    this.field_70699_by.func_75499_g();
                    this.func_70624_b(null);
                }
                return true;
            }
        } else {
            if (stack.func_77973_b() == ModItems.COLLAR_SHEARS && this.reversionTime < 1) {
                if (!this.field_70170_p.field_72995_K) {
                    this.locationManager.remove(this);
                    this.func_70106_y();
                    WolfEntity wolf = (WolfEntity)EntityType.field_200724_aC.func_200721_a(this.field_70170_p);
                    wolf.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
                    wolf.func_70606_j(this.func_110143_aJ());
                    wolf.func_70873_a(this.func_70874_b());
                    this.field_70170_p.func_217376_c((Entity)wolf);
                }
                return true;
            }
            if (stack.func_77973_b() == Items.field_151103_aS || stack.func_77973_b() == ModItems.TRAINING_TREAT) {
                this.func_175505_a(player, stack);
                if (!this.field_70170_p.field_72995_K) {
                    if (stack.func_77973_b() == ModItems.TRAINING_TREAT || this.field_70146_Z.nextInt(3) == 0) {
                        this.func_70903_f(true);
                        this.field_70699_by.func_75499_g();
                        this.func_70624_b(null);
                        this.field_70911_d.func_75270_a(true);
                        this.func_70606_j(20.0f);
                        this.func_184754_b(player.func_110124_au());
                        this.func_70908_e(true);
                        this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                    } else {
                        this.func_70908_e(false);
                        this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                    }
                }
                return true;
            }
        }
        return super.func_184645_a(player, hand);
    }

    public EntityDog createChild(AgeableEntity entityAgeable) {
        EntityDog entitydog = (EntityDog)this.func_200600_R().func_200721_a(this.field_70170_p);
        UUID uuid = this.func_184753_b();
        if (uuid != null) {
            entitydog.func_184754_b(uuid);
            entitydog.func_70903_f(true);
        }
        entitydog.func_70873_a(-ConfigValues.TIME_TO_MATURE);
        if (ConfigValues.PUPS_GET_PARENT_LEVELS && entityAgeable instanceof EntityDog) {
            int combinedLevel = this.LEVELS.getLevel() + ((EntityDog)entityAgeable).LEVELS.getLevel();
            combinedLevel /= 2;
            combinedLevel = Math.min(combinedLevel, 20);
            entitydog.LEVELS.setLevel(combinedLevel);
        }
        return entitydog;
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b().func_206844_a(ModTags.BREEDING_ITEMS);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_94059_bO() {
        return this.func_145818_k_();
    }

    @Override
    public void func_70908_e(boolean successful) {
        super.func_70908_e(successful);
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        if (!TalentHelper.isImmuneToFalls(this)) {
            super.func_180430_e(distance - (float)TalentHelper.fallProtection(this), damageMultiplier);
        }
    }

    public boolean func_70097_a(DamageSource damageSource, float damage) {
        if (this.func_180431_b(damageSource)) {
            return false;
        }
        Entity entity = damageSource.func_76346_g();
        if (!this.canPlayersAttack() && entity instanceof PlayerEntity) {
            return false;
        }
        if (!TalentHelper.attackEntityFrom(this, damageSource, damage)) {
            return false;
        }
        if (this.field_70911_d != null) {
            this.field_70911_d.func_75270_a(false);
        }
        if (entity != null && !(entity instanceof PlayerEntity) && !(entity instanceof ArrowEntity)) {
            damage = (damage + 1.0f) / 2.0f;
        }
        return super.func_70097_a(damageSource, damage);
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag;
        if (!TalentHelper.shouldDamageMob(this, entityIn)) {
            return false;
        }
        int damage = 4 + (MathHelper.func_76128_c((double)this.effectiveLevel()) + 1) / 2;
        damage = TalentHelper.attackEntityAsMob(this, entityIn, damage);
        if (entityIn instanceof ZombieEntity) {
            ((ZombieEntity)entityIn).func_70624_b((LivingEntity)this);
        }
        if (flag = entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)damage)) {
            this.STATS.increaseDamageDealt(damage);
            this.func_174815_a((LivingEntity)this, entityIn);
        }
        return flag;
    }

    public void func_70903_f(boolean tamed) {
        super.func_70903_f(tamed);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(tamed ? 20.0 : 8.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 8) {
            this.isShaking = true;
            this.timeWolfIsShaking = 0.0f;
            this.prevTimeWolfIsShaking = 0.0f;
        } else {
            super.func_70103_a(id);
        }
    }

    public void func_70645_a(DamageSource cause) {
        if (!this.isImmortal()) {
            this.isWet = false;
            this.isShaking = false;
            this.prevTimeWolfIsShaking = 0.0f;
            this.timeWolfIsShaking = 0.0f;
            if (!this.field_70170_p.field_72995_K) {
                this.locationManager.remove(this);
                if (this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223609_l) && this.func_70902_q() instanceof ServerPlayerEntity) {
                    this.func_70902_q().func_145747_a(this.func_110142_aN().func_151521_b());
                }
            }
        }
    }

    public boolean func_70687_e(EffectInstance potioneffectIn) {
        if (this.isIncapacicated()) {
            return false;
        }
        if (!TalentHelper.isPostionApplicable(this, potioneffectIn)) {
            return false;
        }
        return super.func_70687_e(potioneffectIn);
    }

    public void func_70015_d(int amount) {
        if (TalentHelper.setFire(this, amount)) {
            super.func_70015_d(amount);
        }
    }

    public boolean func_70608_bn() {
        return false;
    }

    protected int func_70682_h(int air) {
        return TalentHelper.shouldDecreaseAir(this, air) ? super.func_70682_h(air) : air;
    }

    public boolean func_70648_aU() {
        return TalentHelper.canBreatheUnderwater(this);
    }

    protected boolean func_70041_e_() {
        return TalentHelper.canTriggerWalking(this);
    }

    public boolean func_142018_a(LivingEntity target, LivingEntity owner) {
        if (TalentHelper.canAttackEntity(this, (Entity)target)) {
            return true;
        }
        if (!(target instanceof CreeperEntity) && !(target instanceof GhastEntity)) {
            WolfEntity entitywolf;
            EntityDog entitydog;
            if (target instanceof EntityDog ? (entitydog = (EntityDog)target).func_70909_n() && entitydog.func_70902_q() == owner || !entitydog.func_70909_n() : target instanceof WolfEntity && (entitywolf = (WolfEntity)target).func_70909_n() && entitywolf.func_70902_q() == owner) {
                return false;
            }
            if (target instanceof PlayerEntity && owner instanceof PlayerEntity && !((PlayerEntity)owner).func_96122_a((PlayerEntity)target)) {
                return false;
            }
            if (target instanceof AbstractHorseEntity && ((AbstractHorseEntity)target).func_110248_bS()) {
                return false;
            }
            return !(target instanceof CatEntity) || !((CatEntity)target).func_70909_n();
        }
        return false;
    }

    public boolean func_213358_a(EntityType<?> cls) {
        if (TalentHelper.canAttack(this, cls)) {
            return true;
        }
        return super.func_213358_a(cls);
    }

    public boolean func_213336_c(LivingEntity target) {
        return target instanceof PlayerEntity && this.canInteract(target) ? false : super.func_213336_c(target);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        LazyOptional<T> capOut = TalentHelper.getCapability(this, cap, side);
        if (capOut != null) {
            return capOut.cast();
        }
        return super.getCapability(cap, side);
    }

    public Entity func_212321_a(DimensionType dimType) {
        Entity entity = super.func_212321_a(dimType);
        if (entity instanceof EntityDog) {
            EntityDog dog = (EntityDog)entity;
            if (!this.field_70170_p.field_72995_K) {
                dog.locationManager.update(dog);
                this.locationManager.remove(this);
            }
        } else if (entity != null) {
            DoggyTalentsMod.LOGGER.warn("Dog tried to change dimension but now isn't a dog?");
        }
        return entity;
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        if (!this.field_70170_p.field_72995_K) {
            this.locationManager.update(this);
        }
    }

    public void onRemovedFromWorld() {
        super.onRemovedFromWorld();
        if (!this.field_70170_p.field_72995_K && !this.func_70089_S()) {
            this.locationManager.remove(this);
        }
    }

    public void remove(boolean keepData) {
        super.remove(keepData);
        if (!this.field_70170_p.field_72995_K) {
            this.locationManager.remove(this);
        }
        if (!keepData) {
            TalentHelper.invalidateCapabilities(this);
        }
    }

    protected float func_175134_bD() {
        return 0.42f;
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return false;
    }

    protected float func_189749_co() {
        return 0.8f;
    }

    public boolean func_70878_b(AnimalEntity otherAnimal) {
        if (otherAnimal == this) {
            return false;
        }
        if (!this.func_70909_n()) {
            return false;
        }
        if (!(otherAnimal instanceof EntityDog)) {
            return false;
        }
        EntityDog entitydog = (EntityDog)otherAnimal;
        if (!entitydog.func_70909_n()) {
            return false;
        }
        if (entitydog.func_70906_o()) {
            return false;
        }
        if (!this.GENDER.canMateWith(entitydog)) {
            return false;
        }
        return this.func_70880_s() && entitydog.func_70880_s();
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)ModItems.DOGGY_CHARM);
    }

    public void func_70074_a(LivingEntity entityLivingIn) {
        super.func_70074_a(entityLivingIn);
        this.STATS.incrementKillCount((Entity)entityLivingIn);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isDogWet() {
        return this.isWet;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getShadingWhileWet(float partialTick) {
        return 0.75f + (this.prevTimeWolfIsShaking + (this.timeWolfIsShaking - this.prevTimeWolfIsShaking) * partialTick) / 2.0f * 0.25f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getShakeAngle(float partialTick, float offset) {
        float f = (this.prevTimeWolfIsShaking + (this.timeWolfIsShaking - this.prevTimeWolfIsShaking) * partialTick + offset) / 1.8f;
        if (f < 0.0f) {
            f = 0.0f;
        } else if (f > 1.0f) {
            f = 1.0f;
        }
        return MathHelper.func_76126_a((float)(f * (float)Math.PI)) * MathHelper.func_76126_a((float)(f * (float)Math.PI * 11.0f)) * 0.15f * (float)Math.PI;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getInterestedAngle(float partialTick) {
        return (this.headRotationCourseOld + (this.headRotationCourse - this.headRotationCourseOld) * partialTick) * 0.15f * (float)Math.PI;
    }

    public float getWagAngle(float partialTick, float offset) {
        float f = (this.prevTimeWolfIsHappy + (this.timeWolfIsHappy - this.prevTimeWolfIsHappy) * partialTick + offset) / 2.0f;
        if (f < 0.0f) {
            f = 0.0f;
        } else if (f > 2.0f) {
            f %= 2.0f;
        }
        return MathHelper.func_76126_a((float)(f * (float)Math.PI * 11.0f)) * 0.3f * (float)Math.PI;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getTailRotation() {
        return this.func_70909_n() ? (0.55f - (this.func_110138_aP() - ((Float)this.field_70180_af.func_187225_a(DATA_HEALTH_ID)).floatValue()) / this.func_110138_aP() * 20.0f * 0.02f) * (float)Math.PI : 0.62831855f;
    }

    public int func_70646_bf() {
        return this.func_70906_o() ? 20 : super.func_70646_bf();
    }

    public boolean isImmortal() {
        return this.func_70909_n() && ConfigValues.DOGS_IMMORTAL || this.LEVELS.isDireDog();
    }

    public boolean isIncapacicated() {
        return this.isImmortal() && this.func_110143_aJ() <= (float)ConfigValues.LOW_HEATH_LEVEL;
    }

    public double effectiveLevel() {
        return (double)(this.LEVELS.getLevel() + this.LEVELS.getDireLevel()) / 10.0;
    }

    public double getHealthRelative() {
        return (double)this.func_110143_aJ() / (double)this.func_110138_aP();
    }

    public boolean canWander() {
        return this.func_70909_n() && this.MODE.isMode(EnumMode.WANDERING) && this.COORDS.hasBowlPos() && this.COORDS.getBowlPos().func_177951_i((Vec3i)this.func_180425_c()) < 400.0;
    }

    @Override
    public boolean canInteract(LivingEntity player) {
        return this.func_152114_e(player) || this.willObeyOthers();
    }

    public int foodValue(ItemStack stack, @Nullable Entity entityIn) {
        IDogFoodItem dogFood;
        int temp;
        if (stack.func_190926_b()) {
            return 0;
        }
        int foodValue = 0;
        Item item = stack.func_77973_b();
        if (stack.func_77973_b() != Items.field_151078_bh && item.func_219971_r()) {
            if (item.func_219967_s().func_221467_c()) {
                foodValue = 40;
            }
        } else if (stack.func_77973_b() instanceof IDogFoodItem && (temp = (dogFood = (IDogFoodItem)stack.func_77973_b()).getFoodValue(this, stack, entityIn)) > 0) {
            foodValue = temp;
        }
        foodValue = TalentHelper.changeFoodValue(this, stack, foodValue);
        return foodValue;
    }

    public int nourishment() {
        int amount = 0;
        if (this.getDogHunger() > 0) {
            amount = 40 + 4 * (MathHelper.func_76128_c((double)this.effectiveLevel()) + 1);
            if (this.func_70906_o() && this.TALENTS.getLevel(ModTalents.QUICK_HEALER) == 5) {
                amount += 20 + 2 * (MathHelper.func_76128_c((double)this.effectiveLevel()) + 1);
            }
            if (!this.func_70906_o()) {
                amount *= 5 + this.TALENTS.getLevel(ModTalents.QUICK_HEALER);
                amount /= 10;
            }
        }
        return amount;
    }

    public int points() {
        return this.isCreativeCollar() ? 1000 : this.LEVELS.getLevel() + this.LEVELS.getDireLevel() + (this.LEVELS.isDireDog() ? 15 : 0) + (this.func_70874_b() < 0 ? 0 : 15);
    }

    public int spendablePoints() {
        return this.points() - this.usedPoints();
    }

    public int usedPoints() {
        return TalentHelper.getUsedPoints(this);
    }

    public int deductive(int id) {
        if (id >= 1 && id <= 5) {
            return (new int[]{1, 3, 6, 10, 15})[id - 1];
        }
        return 0;
    }

    public ITextComponent getOwnersName() {
        LivingEntity owner = this.func_70902_q();
        if (owner != null) {
            return owner.func_145748_c_();
        }
        return ((Optional)this.field_70180_af.func_187225_a(LAST_KNOWN_NAME)).orElseGet(this::getNameUnknown);
    }

    private ITextComponent getNameUnknown() {
        return new TranslationTextComponent(this.func_184753_b() != null ? "entity.doggytalents.dog.unknown_owner" : "entity.doggytalents.dog.untamed", new Object[0]);
    }

    private boolean getDogFlag(int bit) {
        return ((Byte)this.field_70180_af.func_187225_a(DOG_FLAGS) & bit) != 0;
    }

    private void setDogFlag(int bit, boolean flag) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(DOG_FLAGS);
        if (flag) {
            this.field_70180_af.func_187227_b(DOG_FLAGS, (Object)((byte)(b0 | bit)));
        } else {
            this.field_70180_af.func_187227_b(DOG_FLAGS, (Object)((byte)(b0 & ~bit)));
        }
    }

    public void setBegging(boolean begging) {
        this.setDogFlag(1, begging);
    }

    public boolean isBegging() {
        return this.getDogFlag(1);
    }

    public void setWillObeyOthers(boolean obeyOthers) {
        this.setDogFlag(2, obeyOthers);
    }

    public boolean willObeyOthers() {
        return this.getDogFlag(2);
    }

    public void setCanPlayersAttack(boolean flag) {
        this.setDogFlag(4, flag);
    }

    public boolean canPlayersAttack() {
        return this.getDogFlag(4);
    }

    public void hasRadarCollar(boolean collar) {
        this.setDogFlag(8, collar);
    }

    public boolean hasRadarCollar() {
        return this.getDogFlag(8);
    }

    public void setHasSunglasses(boolean sunglasses) {
        this.setDogFlag(16, sunglasses);
    }

    public boolean hasSunglasses() {
        return this.getDogFlag(16);
    }

    public void setLyingDown(boolean lying) {
        this.setDogFlag(32, lying);
    }

    public boolean isLyingDown() {
        return this.getDogFlag(32);
    }

    public void set64Flag(boolean lying) {
        this.setDogFlag(64, lying);
    }

    public boolean get64Flag() {
        return this.getDogFlag(64);
    }

    public int getTameSkin() {
        return ((Byte)this.field_70180_af.func_187225_a(DOG_TEXTURE)).byteValue();
    }

    public void setTameSkin(int index) {
        this.field_70180_af.func_187227_b(DOG_TEXTURE, (Object)((byte)index));
    }

    public int getDogHunger() {
        return (Integer)this.field_70180_af.func_187225_a(HUNGER_INT);
    }

    public void setDogHunger(int par1) {
        this.field_70180_af.func_187227_b(HUNGER_INT, (Object)Math.min(this.HUNGER.getMaxHunger(), Math.max(0, par1)));
    }

    public void setBoneVariant(ItemStack stack) {
        this.field_70180_af.func_187227_b(BONE_VARIANT, (Object)stack);
    }

    public ItemStack getBoneVariant() {
        return (ItemStack)this.field_70180_af.func_187225_a(BONE_VARIANT);
    }

    @Nullable
    public IThrowableItem getThrowableItem() {
        Item item = ((ItemStack)this.field_70180_af.func_187225_a(BONE_VARIANT)).func_77973_b();
        if (item instanceof IThrowableItem) {
            return (IThrowableItem)item;
        }
        return null;
    }

    public boolean hasBone() {
        return !this.getBoneVariant().func_190926_b();
    }

    public int getCollarData() {
        return (Integer)this.field_70180_af.func_187225_a(COLLAR_COLOUR);
    }

    public void setCollarData(int value) {
        this.field_70180_af.func_187227_b(COLLAR_COLOUR, (Object)value);
    }

    public int getCapeData() {
        return (Integer)this.field_70180_af.func_187225_a(CAPE);
    }

    public void setCapeData(int value) {
        this.field_70180_af.func_187227_b(CAPE, (Object)value);
    }

    @Override
    public void setDogSize(int value) {
        this.field_70180_af.func_187227_b(SIZE, (Object)((byte)Math.min(5, Math.max(1, value))));
    }

    @Override
    public int getDogSize() {
        return ((Byte)this.field_70180_af.func_187225_a(SIZE)).byteValue();
    }

    public void setGender(EnumGender gender) {
        this.field_70180_af.func_187227_b(GENDER_PARAM, (Object)((byte)gender.getIndex()));
    }

    public EnumGender getGender() {
        return EnumGender.byIndex(((Byte)this.field_70180_af.func_187225_a(GENDER_PARAM)).byteValue());
    }

    public void setLevel(int level) {
        this.field_70180_af.func_187227_b(LEVEL, (Object)((byte)level));
    }

    public int getLevel() {
        return ((Byte)this.field_70180_af.func_187225_a(LEVEL)).byteValue();
    }

    public void setDireLevel(int level) {
        this.field_70180_af.func_187227_b(LEVEL_DIRE, (Object)((byte)level));
    }

    public int getDireLevel() {
        return ((Byte)this.field_70180_af.func_187225_a(LEVEL_DIRE)).byteValue();
    }

    public void setMode(EnumMode mode) {
        EnumMode prevMode = this.getMode();
        this.field_70180_af.func_187227_b(MODE_PARAM, (Object)((byte)mode.getIndex()));
        mode.onModeSet(this, prevMode);
    }

    public EnumMode getMode() {
        return EnumMode.byIndex(((Byte)this.field_70180_af.func_187225_a(MODE_PARAM)).byteValue());
    }

    public void setTalentMap(Map<Talent, Integer> data) {
        this.field_70180_af.func_187227_b(TALENTS_PARAM, data);
    }

    public Map<Talent, Integer> getTalentMap() {
        return (Map)this.field_70180_af.func_187225_a(TALENTS_PARAM);
    }

    public boolean hasBedPos() {
        return ((Optional)this.field_70180_af.func_187225_a(BED_POS)).isPresent();
    }

    public boolean hasBowlPos() {
        return ((Optional)this.field_70180_af.func_187225_a(BOWL_POS)).isPresent();
    }

    public BlockPos getBedPos() {
        return ((Optional)this.field_70180_af.func_187225_a(BED_POS)).orElse(this.field_70170_p.func_175694_M());
    }

    public BlockPos getBowlPos() {
        return ((Optional)this.field_70180_af.func_187225_a(BOWL_POS)).orElse(this.func_180425_c());
    }

    public void resetBedPosition() {
        this.field_70180_af.func_187227_b(BED_POS, Optional.empty());
    }

    public void resetBowlPosition() {
        this.field_70180_af.func_187227_b(BOWL_POS, Optional.empty());
    }

    public void setBedPos(BlockPos pos) {
        this.field_70180_af.func_187227_b(BED_POS, Optional.ofNullable(pos));
    }

    public void setBowlPos(BlockPos pos) {
        this.field_70180_af.func_187227_b(BOWL_POS, Optional.ofNullable(pos));
    }

    public void setNoCollar() {
        this.setCollarData(-2);
    }

    public boolean hasCollar() {
        return this.getCollarData() != -2;
    }

    public boolean hasCollarColoured() {
        return this.getCollarData() >= -1;
    }

    public boolean isCollarColoured() {
        return this.getCollarData() > -1;
    }

    public void setHasCollar() {
        this.setCollarData(-1);
    }

    public boolean hasFancyCollar() {
        return this.getCollarData() < -2;
    }

    public int getFancyCollarIndex() {
        return -3 - this.getCollarData();
    }

    public boolean isCreativeCollar() {
        return this.getCollarData() == -3;
    }

    public float[] getCollar() {
        return DogUtil.rgbIntToFloatArray(this.getCollarData());
    }

    public boolean hasCape() {
        return this.getCapeData() != -2;
    }

    public boolean hasCapeColoured() {
        return this.getCapeData() >= -1;
    }

    public boolean hasFancyCape() {
        return this.getCapeData() == -3;
    }

    public boolean hasLeatherJacket() {
        return this.getCapeData() == -4;
    }

    public boolean isCapeColoured() {
        return this.getCapeData() > -1;
    }

    public void setFancyCape() {
        this.setCapeData(-3);
    }

    public void setLeatherJacket() {
        this.setCapeData(-4);
    }

    public void setCapeColoured() {
        this.setCapeData(-1);
    }

    public void setNoCape() {
        this.setCapeData(-2);
    }

    public float[] getCapeColour() {
        return DogUtil.rgbIntToFloatArray(this.getCapeData());
    }

    public boolean isDogJumping() {
        return this.dogJumping;
    }

    public void setDogJumping(boolean jumping) {
        this.dogJumping = jumping;
    }

    public double getDogJumpStrength() {
        float verticalVelocity = 0.42f + 0.06f * (float)this.TALENTS.getLevel(ModTalents.WOLF_MOUNT);
        if (this.TALENTS.getLevel(ModTalents.WOLF_MOUNT) == 5) {
            verticalVelocity += 0.04f;
        }
        return verticalVelocity;
    }

    public Entity func_184179_bs() {
        return this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
    }

    public boolean func_82171_bF() {
        return this.func_184179_bs() instanceof LivingEntity;
    }

    public boolean func_70104_M() {
        return !this.func_184207_aI();
    }

    public void func_184232_k(Entity passenger) {
        super.func_184232_k(passenger);
        if (passenger instanceof LivingEntity) {
            LivingEntity entityliving = (LivingEntity)passenger;
            this.field_70761_aq = entityliving.field_70761_aq;
        }
    }

    public double func_70033_W() {
        return this.func_184187_bx() instanceof PlayerEntity ? 0.5 : 0.0;
    }

    public boolean canBeRiddenInWater(Entity rider) {
        switch (TalentHelper.canBeRiddenInWater(this, rider)) {
            case SUCCESS: {
                return true;
            }
            case FAIL: {
                return false;
            }
        }
        return false;
    }

    public boolean canRiderInteract() {
        return true;
    }

    public void setJumpPower(int jumpPowerIn) {
        if (this.TALENTS.getLevel(ModTalents.WOLF_MOUNT) > 0) {
            this.jumpPower = 1.0f;
        }
    }

    public boolean canJump() {
        return this.TALENTS.getLevel(ModTalents.WOLF_MOUNT) > 0;
    }

    public void func_213352_e(Vec3d travelVec) {
        double prevX = this.field_70165_t;
        double prevY = this.field_70163_u;
        double prevZ = this.field_70161_v;
        if (this.func_70089_S()) {
            if (this.func_184207_aI() && this.func_82171_bF() && this.TALENTS.getLevel(ModTalents.WOLF_MOUNT) > 0) {
                LivingEntity livingentity = (LivingEntity)this.func_184179_bs();
                this.field_70126_B = this.field_70177_z = livingentity.field_70177_z;
                this.field_70125_A = livingentity.field_70125_A * 0.5f;
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
                this.field_70759_as = this.field_70761_aq = this.field_70177_z;
                float f = livingentity.field_70702_br * 0.7f;
                float f1 = livingentity.field_191988_bg;
                if (f1 <= 0.0f) {
                    f1 *= 0.5f;
                }
                if (this.jumpPower > 0.0f && !this.isDogJumping() && this.field_70122_E) {
                    double d0 = this.getDogJumpStrength() * (double)this.jumpPower;
                    double d1 = this.func_70644_a(Effects.field_76430_j) ? d0 + (double)((float)(this.func_70660_b(Effects.field_76430_j).func_76458_c() + 1) * 0.1f) : d0;
                    Vec3d vec3d = this.func_213322_ci();
                    this.func_213293_j(vec3d.field_72450_a, d1, vec3d.field_72449_c);
                    this.setDogJumping(true);
                    this.field_70160_al = true;
                    if (f1 > 0.0f) {
                        float f2 = MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180)));
                        float f3 = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)));
                        this.func_213317_d(this.func_213322_ci().func_72441_c((double)(-0.4f * f2 * this.jumpPower), 0.0, (double)(0.4f * f3 * this.jumpPower)));
                    }
                    this.jumpPower = 0.0f;
                }
                this.field_70747_aH = this.func_70689_ay() * 0.1f;
                if (this.func_184186_bw()) {
                    this.func_70659_e((float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e() * 0.5f);
                    super.func_213352_e(new Vec3d((double)f, travelVec.field_72448_b, (double)f1));
                } else if (livingentity instanceof PlayerEntity) {
                    this.func_213317_d(Vec3d.field_186680_a);
                }
                if (this.field_70122_E) {
                    this.jumpPower = 0.0f;
                    this.setDogJumping(false);
                }
                this.field_184618_aE = this.field_70721_aZ;
                double d2 = this.field_70165_t - this.field_70169_q;
                double d3 = this.field_70161_v - this.field_70166_s;
                float f4 = MathHelper.func_76133_a((double)(d2 * d2 + d3 * d3)) * 4.0f;
                if (f4 > 1.0f) {
                    f4 = 1.0f;
                }
                this.field_70721_aZ += (f4 - this.field_70721_aZ) * 0.4f;
                this.field_184619_aG += this.field_70721_aZ;
            } else {
                this.field_70747_aH = 0.02f;
                super.func_213352_e(travelVec);
            }
            this.addMovementStat(this.field_70165_t - prevX, this.field_70163_u - prevY, this.field_70161_v - prevZ);
        }
    }

    public void addMovementStat(double xD, double yD, double zD) {
        int j;
        if (this.func_184207_aI()) {
            j = Math.round(MathHelper.func_76133_a((double)(xD * xD + zD * zD)) * 100.0f);
            this.STATS.increaseDistanceRidden(j);
        }
        if (!this.func_184218_aH()) {
            if (this.func_213290_a(FluidTags.field_206959_a, true)) {
                j = Math.round(MathHelper.func_76133_a((double)(xD * xD + yD * yD + zD * zD)) * 100.0f);
                if (j > 0) {
                    this.STATS.increaseDistanceOnWater(j);
                }
            } else if (this.func_70090_H()) {
                int k = Math.round(MathHelper.func_76133_a((double)(xD * xD + zD * zD)) * 100.0f);
                if (k > 0) {
                    this.STATS.increaseDistanceInWater(k);
                }
            } else if (this.field_70122_E) {
                int l = Math.round(MathHelper.func_76133_a((double)(xD * xD + zD * zD)) * 100.0f);
                if (l > 0) {
                    if (this.func_70051_ag()) {
                        this.STATS.increaseDistanceSprint(l);
                    } else if (this.func_70093_af()) {
                        this.STATS.increaseDistanceSneaking(l);
                    } else {
                        this.STATS.increaseDistanceWalk(l);
                    }
                }
            } else {
                int n = Math.round(MathHelper.func_76133_a((double)(xD * xD + zD * zD)) * 100.0f);
            }
        }
    }

    @Override
    public ICoordFeature getCoordFeature() {
        return this.COORDS;
    }

    @Override
    public IGenderFeature getGenderFeature() {
        return this.GENDER;
    }

    @Override
    public ILevelFeature getLevelFeature() {
        return this.LEVELS;
    }

    @Override
    public IModeFeature getModeFeature() {
        return this.MODE;
    }

    @Override
    public IStatsFeature getStatsFeature() {
        return this.STATS;
    }

    @Override
    public ITalentFeature getTalentFeature() {
        return this.TALENTS;
    }

    @Override
    public IHungerFeature getHungerFeature() {
        return this.HUNGER;
    }

    @Override
    public <T> void putObject(String key, T value) {
        this.objects.put(key, value);
    }

    @Override
    public <T> T getObject(String key, Class<T> type) {
        return (T)this.objects.get(key);
    }
}

