/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.entity.ai;

import doggytalents.DoggyTalentsMod;
import doggytalents.api.feature.EnumGender;
import doggytalents.entity.EntityDog;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.DimensionSavedDataManager;
import net.minecraft.world.storage.WorldSavedData;

public class DogLocationManager
extends WorldSavedData {
    private Set<DogLocation> locations = new HashSet<DogLocation>();

    public DogLocationManager() {
        super("dog_locations");
    }

    public List<DogLocation> getList(DimensionType type, Predicate<DogLocation> selector) {
        return this.getStream(type, selector).collect(Collectors.toList());
    }

    public Stream<DogLocation> getStream(DimensionType type, Predicate<DogLocation> selector) {
        return this.locations.stream().filter(loc -> ((DogLocation)loc).type == type).filter(selector);
    }

    public static DogLocationManager getHandler(@Nonnull ServerWorld world) {
        return DogLocationManager.getHandler(world.func_73046_m().func_71218_a(DimensionType.field_223227_a_).func_217481_x());
    }

    public static DogLocationManager getHandler(DimensionSavedDataManager storage) {
        return (DogLocationManager)storage.func_215752_a(DogLocationManager::new, "dog_locations");
    }

    public void update(EntityDog dog) {
        DogLocation temp = new DogLocation(dog);
        boolean isUpdate = this.locations.remove((Object)temp);
        this.locations.add(temp);
        this.func_76185_a();
    }

    public void remove(EntityDog dog) {
        DogLocation temp = new DogLocation(dog);
        if (this.locations.remove((Object)temp)) {
            this.func_76185_a();
            DoggyTalentsMod.LOGGER.debug("REMOVED DATA: " + (Object)((Object)temp));
        }
    }

    public void func_76184_a(CompoundNBT nbt) {
        if (nbt.func_150297_b("dog_locations", 9)) {
            ListNBT nbtlist = nbt.func_150295_c("dog_locations", 10);
            for (int i = 0; i < nbtlist.size(); ++i) {
                DogLocation location = new DogLocation(nbtlist.func_150305_b(i));
                DoggyTalentsMod.LOGGER.debug("Loaded: " + (Object)((Object)location));
                if (location.entityId == null) continue;
                this.locations.add(location);
            }
        }
    }

    public CompoundNBT func_189551_b(CompoundNBT compound) {
        ListNBT nbtlist = new ListNBT();
        for (DogLocation location : this.locations) {
            nbtlist.add((Object)location.write(new CompoundNBT()));
        }
        compound.func_218657_a("dog_locations", (INBT)nbtlist);
        return compound;
    }

    public class DogLocation
    extends Vec3d {
        private DimensionType type;
        @Nonnull
        private UUID entityId;
        @Nullable
        private UUID owner;
        private ITextComponent name;
        private EnumGender gender;
        private boolean hasRadarCollar;

        public DogLocation(CompoundNBT compound) {
            super(compound.func_74769_h("x"), compound.func_74769_h("y"), compound.func_74769_h("z"));
            if (compound.func_150297_b("dimension", 8)) {
                this.type = (DimensionType)Registry.field_212622_k.func_82594_a(new ResourceLocation(compound.func_74779_i("dimension")));
            }
            this.entityId = compound.func_186857_a("entityId");
            if (compound.func_186855_b("ownerId")) {
                this.owner = compound.func_186857_a("ownerId");
            }
            if (compound.func_150297_b("name_text_component", 8)) {
                this.name = ITextComponent.Serializer.func_150699_a((String)compound.func_74779_i("name_text_component"));
            } else if (compound.func_150297_b("name", 8)) {
                this.name = new StringTextComponent(compound.func_74779_i("name"));
            }
            this.gender = EnumGender.bySaveName(compound.func_74779_i("gender"));
            this.hasRadarCollar = compound.func_74767_n("collar");
        }

        public DogLocation(EntityDog dog) {
            super(dog.field_70165_t, dog.field_70163_u, dog.field_70161_v);
            this.type = dog.field_71093_bK;
            this.entityId = dog.func_110124_au();
            this.owner = dog.func_184753_b();
            this.name = dog.func_200200_C_();
            this.gender = dog.getGender();
            this.hasRadarCollar = dog.hasRadarCollar();
        }

        public CompoundNBT write(CompoundNBT compound) {
            compound.func_74780_a("x", this.field_72450_a);
            compound.func_74780_a("y", this.field_72448_b);
            compound.func_74780_a("z", this.field_72449_c);
            if (this.type != null) {
                compound.func_74778_a("dimension", Registry.field_212622_k.func_177774_c((Object)this.type).toString());
            }
            compound.func_186854_a("entityId", this.entityId);
            if (this.owner != null) {
                compound.func_186854_a("ownerId", this.owner);
            }
            compound.func_74778_a("name_text_component", ITextComponent.Serializer.func_150696_a((ITextComponent)this.name));
            compound.func_74778_a("gender", this.gender.getSaveName());
            compound.func_74757_a("collar", this.hasRadarCollar);
            return compound;
        }

        public EntityDog getDog(World world) {
            if (!(world instanceof ServerWorld)) {
                DoggyTalentsMod.LOGGER.warn("Something when wrong. Tried to call DogLocation#getDog(PlayerEntity) on what looks like the client side");
                return null;
            }
            Entity entity = ((ServerWorld)world).func_217461_a(this.entityId);
            if (entity == null) {
                return null;
            }
            if (!(entity instanceof EntityDog)) {
                DoggyTalentsMod.LOGGER.warn("Something when wrong. The saved dog UUID is not an EntityDog");
                return null;
            }
            return (EntityDog)entity;
        }

        public LivingEntity getOwner(World world) {
            EntityDog dog = this.getDog(world);
            if (dog != null) {
                return dog.func_70902_q();
            }
            if (this.owner != null) {
                return world.func_217371_b(this.owner);
            }
            return null;
        }

        public ITextComponent getName(World world) {
            EntityDog dog = this.getDog(world);
            if (dog != null) {
                return dog.func_145748_c_();
            }
            if (this.owner != null) {
                return this.name;
            }
            return null;
        }

        public boolean hasRadioCollar(World world) {
            EntityDog dog = this.getDog(world);
            if (dog != null) {
                return dog.hasRadarCollar();
            }
            return this.hasRadarCollar;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DogLocation)) {
                return false;
            }
            DogLocation other = (DogLocation)((Object)obj);
            return this.entityId != null && other.entityId != null && this.entityId.equals(other.entityId);
        }

        public int hashCode() {
            return Objects.hash(this.entityId);
        }

        public String toString() {
            return String.format("DogLocation [id=%s, x=%f,y=%f, z=%f]", this.entityId.toString(), this.field_72450_a, this.field_72448_b, this.field_72449_c);
        }
    }
}

