/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.entity.ai;

import doggytalents.entity.EntityDog;
import java.util.EnumSet;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public class EntityAIDogWander
extends Goal {
    protected final EntityDog dog;
    protected boolean wandering;
    protected double x;
    protected double y;
    protected double z;
    protected final double speed;
    protected int executionChance;
    protected boolean mustUpdate;

    public EntityAIDogWander(EntityDog dogIn, double speedIn) {
        this.dog = dogIn;
        this.speed = speedIn;
        this.wandering = false;
        this.executionChance = 60;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean func_75250_a() {
        if (this.dog.func_184207_aI()) {
            return false;
        }
        if (this.dog.func_70654_ax() >= 100) {
            return false;
        }
        if (this.dog.func_70681_au().nextInt(this.executionChance) != 0) {
            return false;
        }
        if (!this.dog.canWander()) {
            return false;
        }
        Vec3d vec3d = this.getPosition();
        if (vec3d == null) {
            return false;
        }
        this.x = vec3d.field_72450_a;
        this.y = vec3d.field_72448_b;
        this.z = vec3d.field_72449_c;
        return true;
    }

    @Nullable
    protected Vec3d getPosition() {
        PathNavigator pathnavigate = this.dog.func_70661_as();
        Random random = this.dog.func_70681_au();
        int xzRange = 5;
        int yRange = 3;
        float bestWeight = -99999.0f;
        BlockPos bestPos = this.dog.COORDS.getBowlPos();
        for (int attempt = 0; attempt < 10; ++attempt) {
            float weight;
            int l = random.nextInt(2 * xzRange + 1) - xzRange;
            int i1 = random.nextInt(2 * yRange + 1) - yRange;
            int j1 = random.nextInt(2 * xzRange + 1) - xzRange;
            BlockPos testPos = this.dog.COORDS.getBowlPos().func_177982_a(l, i1, j1);
            if (!pathnavigate.func_188555_b(testPos) || !((weight = this.dog.func_180484_a(testPos)) > bestWeight)) continue;
            bestWeight = weight;
            bestPos = testPos;
        }
        return new Vec3d((double)bestPos.func_177958_n(), (double)bestPos.func_177956_o(), (double)bestPos.func_177952_p());
    }

    public boolean func_75253_b() {
        return !this.dog.func_70661_as().func_75500_f();
    }

    public void func_75249_e() {
        this.dog.func_70661_as().func_75492_a(this.x, this.y, this.z, this.speed);
    }
}

