/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.handler;

import com.google.common.collect.ImmutableList;
import doggytalents.DoggyTalentsMod;
import doggytalents.ModEntities;
import doggytalents.ModItems;
import doggytalents.helper.Compatibility;
import java.util.Objects;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class MissingMappings {
    @SubscribeEvent
    public void remapMissingEntities(RegistryEvent.MissingMappings<EntityType<?>> event) {
        if (event.getAllMappings() == null) {
            return;
        }
        ImmutableList mappings = event.getAllMappings();
        mappings.forEach(mapping -> {
            if (Objects.equals(mapping.key, Compatibility.DOGGY_BEAM)) {
                mapping.remap(ModEntities.DOG_BEAM);
                DoggyTalentsMod.LOGGER.debug("Remapped Dog Beam id");
            }
        });
    }

    @SubscribeEvent
    public void remapMissingItems(RegistryEvent.MissingMappings<Item> event) {
        if (event.getAllMappings() == null) {
            return;
        }
        ImmutableList mappings = event.getAllMappings();
        mappings.forEach(mapping -> {
            if (Objects.equals(mapping.key, Compatibility.COMMAND_EMBLEM)) {
                mapping.remap((IForgeRegistryEntry)ModItems.WHISTLE);
                DoggyTalentsMod.LOGGER.debug("Remapped Command Emblem to Whistle");
            }
        });
    }
}

