/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.helper;

import doggytalents.api.inferface.IDogFoodItem;
import doggytalents.entity.EntityDog;
import java.util.Comparator;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class DogUtil {
    public static void teleportDogToOwner(Entity owner, Entity entity, World world, PathNavigator pathfinder, int radius) {
        DogUtil.teleportDogToPos(owner.field_70165_t, owner.func_174813_aQ().field_72338_b, owner.field_70161_v, entity, world, pathfinder, radius);
    }

    public static void teleportDogToOwner(Entity owner, Entity entity, World world, PathNavigator pathfinder) {
        DogUtil.teleportDogToPos(owner.field_70165_t, owner.func_174813_aQ().field_72338_b, owner.field_70161_v, entity, world, pathfinder, 2);
    }

    public static void teleportDogToPos(double x, double y, double z, Entity entity, World world, PathNavigator pathfinder, int radius) {
        int i = MathHelper.func_76128_c((double)x) - radius;
        int j = MathHelper.func_76128_c((double)z) - radius;
        int k = MathHelper.func_76128_c((double)y);
        for (int l = 0; l <= radius * 2; ++l) {
            for (int i1 = 0; i1 <= radius * 2; ++i1) {
                if (l >= 1 && i1 >= 1 && l <= radius * 2 - 1 && i1 <= radius * 2 - 1 || !DogUtil.isTeleportFriendlyBlock(entity, world, i, j, k, l, i1)) continue;
                entity.func_70012_b((double)((float)(i + l) + 0.5f), (double)k, (double)((float)(j + i1) + 0.5f), entity.field_70177_z, entity.field_70125_A);
                pathfinder.func_75499_g();
                return;
            }
        }
    }

    public static boolean isTeleportFriendlyBlock(Entity entity, World world, int xBase, int zBase, int y, int xAdd, int zAdd) {
        BlockPos blockpos = new BlockPos(xBase + xAdd, y - 1, zBase + zAdd);
        BlockState iblockstate = world.func_180495_p(blockpos);
        return iblockstate.func_215688_a((IBlockReader)world, blockpos, entity.func_200600_R()) && world.func_175623_d(blockpos.func_177984_a()) && world.func_175623_d(blockpos.func_177981_b(2));
    }

    public static boolean feedDogFrom(EntityDog dogIn, IItemHandler source) {
        for (int i = 0; i < source.getSlots(); ++i) {
            ItemStack stack = source.extractItem(i, 1, true);
            int foodValue = 0;
            foodValue = dogIn.foodValue(stack, null);
            if (foodValue <= 0) continue;
            stack = source.extractItem(i, 1, false);
            dogIn.setDogHunger(dogIn.getDogHunger() + foodValue);
            if (stack.func_77973_b() instanceof IDogFoodItem) {
                IDogFoodItem dogFood = (IDogFoodItem)stack.func_77973_b();
                dogFood.onItemConsumed(dogIn, stack, null);
            }
            return true;
        }
        return false;
    }

    public static boolean isHolding(Entity entity, Item item, Predicate<CompoundNBT> nbtPredicate) {
        return DogUtil.isHolding(entity, (ItemStack stack) -> stack.func_77973_b() == item && stack.func_77942_o() && nbtPredicate.test(stack.func_77978_p()));
    }

    public static boolean isHolding(Entity entity, Item item) {
        return DogUtil.isHolding(entity, (ItemStack stack) -> stack.func_77973_b() == item);
    }

    public static boolean isHolding(Entity entity, Predicate<ItemStack> matcher) {
        if (entity == null) {
            return false;
        }
        for (ItemStack stack : entity.func_184214_aD()) {
            if (!matcher.test(stack)) continue;
            return true;
        }
        return false;
    }

    public static float[] rgbIntToFloatArray(int rgbInt) {
        int r = rgbInt >> 16 & 0xFF;
        int g = rgbInt >> 8 & 0xFF;
        int b = rgbInt >> 0 & 0xFF;
        return new float[]{(float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f};
    }

    public static int[] rgbIntToIntArray(int rgbInt) {
        int r = rgbInt >> 16 & 0xFF;
        int g = rgbInt >> 8 & 0xFF;
        int b = rgbInt >> 0 & 0xFF;
        return new int[]{r, g, b};
    }

    public static void transferStacks(IItemHandlerModifiable source, IItemHandler target) {
        for (int i = 0; i < source.getSlots(); ++i) {
            source.setStackInSlot(i, DogUtil.addItem(target, source.getStackInSlot(i)));
        }
    }

    public static ItemStack addItem(IItemHandler target, ItemStack remaining) {
        for (int i = 0; i < target.getSlots() && !(remaining = target.insertItem(i, remaining, false)).func_190926_b(); ++i) {
        }
        return remaining;
    }

    public static class Sorter
    implements Comparator<Entity> {
        private final Entity entity;

        public Sorter(Entity entityIn) {
            this.entity = entityIn;
        }

        @Override
        public int compare(Entity entity1, Entity entity2) {
            double d1;
            double d0 = this.entity.func_70068_e(entity1);
            if (d0 < (d1 = this.entity.func_70068_e(entity2))) {
                return -1;
            }
            return d0 > d1 ? 1 : 0;
        }
    }
}

