/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.inventory;

import doggytalents.DoggyTalentsMod;
import doggytalents.ModItems;
import doggytalents.api.inferface.IDogItem;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemStackInventory
implements IItemHandler,
IItemHandlerModifiable {
    private final ItemStack itemStack;
    private int size;

    public ItemStackInventory(ItemStack itemStack, int size) {
        this.itemStack = itemStack;
        this.size = size;
    }

    private CompoundNBT getTag() {
        if (!this.itemStack.func_77942_o()) {
            this.itemStack.func_77982_d(new CompoundNBT());
        }
        return this.itemStack.func_77978_p();
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        boolean hasStack;
        this.validateSlotIndex(slot);
        DoggyTalentsMod.LOGGER.info("" + stack);
        CompoundNBT itemTag = null;
        boolean bl = hasStack = !stack.func_190926_b();
        if (hasStack) {
            itemTag = new CompoundNBT();
            itemTag.func_74768_a("Slot", slot);
            stack.func_77955_b(itemTag);
        }
        boolean foundSlot = false;
        ListNBT tagList = this.getTag().func_150295_c("Items", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundNBT existing = tagList.func_150305_b(i);
            if (existing.func_74762_e("Slot") != slot) continue;
            foundSlot = true;
            if (hasStack) {
                tagList.set(i, (INBT)itemTag);
                continue;
            }
            tagList.remove(i);
        }
        DoggyTalentsMod.LOGGER.info("{}", (Object)tagList.toString());
        if (hasStack && !foundSlot) {
            tagList.add((Object)itemTag);
        }
        this.getTag().func_218657_a("Items", (INBT)tagList);
        this.onContentsChanged(slot);
    }

    public int getSlots() {
        return this.size;
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        this.validateSlotIndex(slot);
        ListNBT tagList = this.getTag().func_150295_c("Items", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundNBT itemTags = tagList.func_150305_b(i);
            if (itemTags.func_74762_e("Slot") != slot) continue;
            return ItemStack.func_199557_a((CompoundNBT)itemTags);
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        boolean reachedLimit;
        DoggyTalentsMod.LOGGER.info("DA: " + stack);
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (!this.isItemValid(slot, stack)) {
            return stack;
        }
        this.validateSlotIndex(slot);
        ItemStack existing = this.getStackInSlot(slot);
        int limit = this.getStackLimit(slot, stack);
        if (!existing.func_190926_b()) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)existing)) {
                return stack;
            }
            limit -= existing.func_190916_E();
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.func_190916_E() > limit;
        if (!simulate) {
            if (existing.func_190926_b()) {
                this.setStackInSlot(slot, reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)limit) : stack);
            } else {
                DoggyTalentsMod.LOGGER.info("" + existing);
                existing.func_190917_f(reachedLimit ? limit : stack.func_190916_E());
                DoggyTalentsMod.LOGGER.info("" + existing);
                this.setStackInSlot(slot, existing);
            }
            this.onContentsChanged(slot);
        }
        return reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.func_190916_E() - limit)) : ItemStack.field_190927_a;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.field_190927_a;
        }
        this.validateSlotIndex(slot);
        ItemStack existing = this.getStackInSlot(slot);
        if (existing.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        int toExtract = Math.min(amount, existing.func_77976_d());
        if (existing.func_190916_E() <= toExtract) {
            if (!simulate) {
                this.setStackInSlot(slot, ItemStack.field_190927_a);
                this.onContentsChanged(slot);
            }
            return existing;
        }
        if (!simulate) {
            this.setStackInSlot(slot, ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)(existing.func_190916_E() - toExtract)));
            this.onContentsChanged(slot);
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)toExtract);
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
        return Math.min(this.getSlotLimit(slot), stack.func_77976_d());
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return stack.func_77973_b() instanceof IDogItem || stack.func_77973_b() == ModItems.CHEW_STICK || stack.func_77973_b() == Items.field_151078_bh || stack.func_77973_b().func_219971_r() && stack.func_77973_b().func_219967_s().func_221467_c();
    }

    protected void validateSlotIndex(int slot) {
        if (slot < 0 || slot >= this.size) {
            throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.size + ")");
        }
    }

    protected void onContentsChanged(int slot) {
    }
}

