/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.network.client;

import doggytalents.entity.EntityDog;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketDogName {
    private final int entityId;
    private final String name;

    public PacketDogName(int entityId, String name) {
        this.entityId = entityId;
        this.name = name;
    }

    public static void encode(PacketDogName msg, PacketBuffer buf) {
        buf.writeInt(msg.entityId);
        buf.func_211400_a(msg.name, 64);
    }

    public static PacketDogName decode(PacketBuffer buf) {
        int entityId = buf.readInt();
        String name = buf.func_150789_c(64);
        return new PacketDogName(entityId, name);
    }

    public static class Handler {
        public static void handle(PacketDogName message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                Entity target = ((NetworkEvent.Context)ctx.get()).getSender().field_70170_p.func_73045_a(message.entityId);
                if (!(target instanceof EntityDog)) {
                    return;
                }
                EntityDog dog = (EntityDog)target;
                if (!dog.canInteract((LivingEntity)((NetworkEvent.Context)ctx.get()).getSender())) {
                    return;
                }
                if (message.name.isEmpty()) {
                    dog.func_200203_b(null);
                } else {
                    dog.func_200203_b((ITextComponent)new StringTextComponent(message.name));
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

