/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.tileentity;

import doggytalents.ModTileEntities;
import doggytalents.entity.EntityDog;
import doggytalents.helper.CapabilityHelper;
import doggytalents.helper.DogUtil;
import doggytalents.inventory.container.ContainerFoodBowl;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityFoodBowl
extends TileEntity
implements INamedContainerProvider,
ITickableTileEntity {
    private LazyOptional<ItemStackHandler> itemStackHandler = LazyOptional.of(() -> new ItemStackHandler(5){

        protected void onContentsChanged(int slot) {
            TileEntityFoodBowl.this.func_70296_d();
        }
    });
    public int timeoutCounter;

    public TileEntityFoodBowl() {
        super(ModTileEntities.FOOD_BOWL);
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        this.itemStackHandler.ifPresent(h -> h.deserializeNBT(compound));
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        this.itemStackHandler.ifPresent(h -> compound.func_197643_a(h.serializeNBT()));
        return compound;
    }

    public void func_73660_a() {
        if (++this.timeoutCounter < 5) {
            return;
        }
        List dogList = this.field_145850_b.func_217357_a(EntityDog.class, new AxisAlignedBB(this.field_174879_c).func_72314_b(5.0, 5.0, 5.0));
        IItemHandler inventory = (IItemHandler)CapabilityHelper.getOrThrow(this, CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
        for (EntityDog dog : dogList) {
            if (!dog.COORDS.hasBowlPos()) {
                dog.COORDS.setBowlPos(this.field_174879_c);
            }
            if (dog.getDogHunger() >= 60) continue;
            DogUtil.feedDogFrom(dog, inventory);
        }
        this.timeoutCounter = 0;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemStackHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("container.doggytalents.food_bowl", new Object[0]);
    }

    public Container createMenu(int windowId, PlayerInventory playerInventory, PlayerEntity playerIn) {
        return new ContainerFoodBowl(windowId, this.field_145850_b, this.field_174879_c, playerInventory, playerIn);
    }
}

