/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.api.feature;

import com.google.common.collect.Lists;
import doggytalents.api.inferface.AbstractDogEntity;
import doggytalents.api.inferface.IDogFoodHandler;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;

public class FoodHandler {
    private static final List<IDogFoodHandler> HANDLERS = Lists.newArrayList();

    public static void registerHandler(IDogFoodHandler handler) {
        HANDLERS.add(handler);
    }

    public static Optional<IDogFoodHandler> isFood(ItemStack stackIn) {
        if (stackIn.func_77973_b() instanceof IDogFoodHandler && ((IDogFoodHandler)stackIn.func_77973_b()).isFood(stackIn)) {
            return Optional.of((IDogFoodHandler)stackIn.func_77973_b());
        }
        for (IDogFoodHandler handler : HANDLERS) {
            if (!handler.isFood(stackIn)) continue;
            return Optional.of(handler);
        }
        return Optional.empty();
    }

    public static Optional<IDogFoodHandler> getMatch(@Nullable AbstractDogEntity dogIn, ItemStack stackIn, @Nullable Entity entityIn) {
        if (stackIn.func_77973_b() instanceof IDogFoodHandler && ((IDogFoodHandler)stackIn.func_77973_b()).canConsume(dogIn, stackIn, entityIn)) {
            return Optional.of((IDogFoodHandler)stackIn.func_77973_b());
        }
        for (IDogFoodHandler handler : HANDLERS) {
            if (!handler.canConsume(dogIn, stackIn, entityIn)) continue;
            return Optional.of(handler);
        }
        return Optional.empty();
    }
}

