/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.entity.render;

import com.google.common.collect.Maps;
import doggytalents.api.client.render.IAccessoryRenderer;
import doggytalents.api.client.render.ITalentRenderer;
import doggytalents.api.registry.Accessory;
import doggytalents.api.registry.Talent;
import java.util.Map;
import javax.annotation.Nullable;

public class CollarRenderManager {
    private static Map<Accessory, IAccessoryRenderer<?>> accessoryRendererMap = Maps.newConcurrentMap();
    private static Map<Talent, ITalentRenderer<?>> talentRendererMap = Maps.newConcurrentMap();

    public static void registerRenderer(Accessory entityClass, IAccessoryRenderer<?> shader) {
        accessoryRendererMap.put(entityClass, shader);
    }

    public static void registerRenderer(Talent entityClass, ITalentRenderer<?> shader) {
        talentRendererMap.put(entityClass, shader);
    }

    public static boolean hasRenderer(Accessory type) {
        return accessoryRendererMap.containsKey((Object)type);
    }

    @Nullable
    public static IAccessoryRenderer<?> getRendererFor(Accessory type) {
        return accessoryRendererMap.get((Object)type);
    }

    @Nullable
    public static ITalentRenderer<?> getRendererFor(Talent talent) {
        return talentRendererMap.get(talent);
    }
}

