/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.block;

import doggytalents.DoggyEntityTypes;
import doggytalents.DoggyTalents2;
import doggytalents.api.DoggyTalentsAPI;
import doggytalents.api.registry.IBeddingMaterial;
import doggytalents.api.registry.ICasingMaterial;
import doggytalents.common.block.tileentity.DogBedTileEntity;
import doggytalents.common.entity.DogEntity;
import doggytalents.common.storage.DogRespawnData;
import doggytalents.common.storage.DogRespawnStorage;
import doggytalents.common.util.DogBedUtil;
import doggytalents.common.util.EntityUtil;
import doggytalents.common.util.NBTUtil;
import doggytalents.common.util.WorldUtil;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;

public class DogBedBlock
extends Block {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0);
    protected static final VoxelShape SHAPE_COLLISION = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0);

    public DogBedBlock() {
        super(Block.Properties.func_200945_a((Material)Material.field_151575_d).func_200948_a(3.0f, 5.0f).func_200947_a(SoundType.field_185848_a));
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)FACING, (Comparable)Direction.NORTH)).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING, WATERLOGGED});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext selectionContext) {
        return SHAPE_COLLISION;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new DogBedTileEntity();
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        return Block.func_220055_a((IWorldReader)worldIn, (BlockPos)pos.func_177977_b(), (Direction)Direction.UP);
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        state = (BlockState)state.func_206870_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
        DogBedTileEntity dogBedTileEntity = WorldUtil.getTileEntity((IBlockReader)worldIn, pos, DogBedTileEntity.class);
        if (dogBedTileEntity != null) {
            DogBedUtil.setBedVariant(dogBedTileEntity, stack);
            dogBedTileEntity.setPlacer(placer);
            CompoundNBT tag = stack.func_179543_a("doggytalents");
            if (tag != null) {
                ITextComponent name = NBTUtil.getTextComponent(tag, "name");
                ITextComponent ownerName = NBTUtil.getTextComponent(tag, "ownerName");
                UUID ownerId = NBTUtil.getUniqueId(tag, "ownerId");
                dogBedTileEntity.setBedName(name);
                dogBedTileEntity.setOwnerName(ownerName);
                dogBedTileEntity.setOwner(ownerId);
            }
        }
        worldIn.func_180501_a(pos, state, 2);
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return facing == Direction.DOWN && !stateIn.func_196955_c((IWorldReader)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public IFluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((IProperty)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    @Deprecated
    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (worldIn.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        if (handIn == Hand.MAIN_HAND) {
            DogBedTileEntity dogBedTileEntity = WorldUtil.getTileEntity((IBlockReader)worldIn, pos, DogBedTileEntity.class);
            if (dogBedTileEntity != null) {
                ItemStack stack = player.func_184586_b(handIn);
                if (stack.func_77973_b() == Items.field_151057_cb && stack.func_82837_s()) {
                    dogBedTileEntity.setBedName(stack.func_200301_q());
                    if (!player.field_71075_bZ.field_75098_d) {
                        stack.func_190918_g(1);
                    }
                    worldIn.func_184138_a(pos, state, state, 3);
                    return ActionResultType.SUCCESS;
                }
                if (player.func_225608_bj_() && dogBedTileEntity.getOwnerUUID() == null) {
                    DogEntity closests;
                    List dogs = worldIn.func_217394_a((EntityType)DoggyEntityTypes.DOG.get(), new AxisAlignedBB(pos).func_186662_g(10.0), dog -> dog.func_70089_S() && dog.func_152114_e((LivingEntity)player));
                    Collections.sort(dogs, new EntityUtil.Sorter(new Vec3d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p())));
                    DogEntity closestStanding = null;
                    DogEntity closestSitting = null;
                    for (DogEntity dog2 : dogs) {
                        if (closestSitting != null && closestSitting != null) break;
                        if (closestSitting == null && dog2.func_70906_o()) {
                            closestSitting = dog2;
                            continue;
                        }
                        if (closestStanding != null || dog2.func_70906_o()) continue;
                        closestStanding = dog2;
                    }
                    DogEntity dogEntity = closests = closestStanding != null ? closestStanding : closestSitting;
                    if (closests != null) {
                        closests.setTargetBlock(pos);
                    }
                } else {
                    if (dogBedTileEntity.getOwnerUUID() != null) {
                        DogRespawnData storage = DogRespawnStorage.get(worldIn).remove(dogBedTileEntity.getOwnerUUID());
                        if (storage != null) {
                            DogEntity dog3 = storage.respawn(worldIn, player, pos.func_177984_a());
                            dogBedTileEntity.setOwner(dog3);
                            dog3.setBedPos(dog3.field_71093_bK, pos);
                            return ActionResultType.SUCCESS;
                        }
                        ITextComponent name = dogBedTileEntity.getOwnerName();
                        player.func_145747_a((ITextComponent)new TranslationTextComponent("block.doggytalents.dog_bed.owner", new Object[]{name != null ? name : "someone"}));
                        return ActionResultType.FAIL;
                    }
                    player.func_145747_a((ITextComponent)new TranslationTextComponent("block.doggytalents.dog_bed.set_owner_help", new Object[0]));
                    return ActionResultType.SUCCESS;
                }
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
        Pair<ICasingMaterial, IBeddingMaterial> materials = DogBedUtil.getMaterials(stack);
        tooltip.add(((ICasingMaterial)((Object)materials.getLeft())).getTooltip());
        tooltip.add(((IBeddingMaterial)((Object)materials.getRight())).getTooltip());
        CompoundNBT tag = stack.func_179543_a("doggytalents");
        if (tag != null) {
            UUID ownerId = NBTUtil.getUniqueId(tag, "ownerId");
            ITextComponent name = NBTUtil.getTextComponent(tag, "name");
            ITextComponent ownerName = NBTUtil.getTextComponent(tag, "ownerName");
            if (name != null) {
                tooltip.add(new StringTextComponent("Bed Name: ").func_211708_a(TextFormatting.WHITE).func_150257_a(name));
            }
            if (ownerName != null) {
                tooltip.add(new StringTextComponent("Name: ").func_211708_a(TextFormatting.DARK_AQUA).func_150257_a(ownerName));
            }
            if (ownerId != null && (flagIn.func_194127_a() || Screen.hasShiftDown())) {
                tooltip.add(new StringTextComponent("UUID: ").func_211708_a(TextFormatting.AQUA).func_150257_a((ITextComponent)new StringTextComponent(ownerId.toString())));
            }
        }
    }

    public void func_149666_a(ItemGroup group, NonNullList<ItemStack> items) {
        for (IBeddingMaterial beddingId : DoggyTalentsAPI.BEDDING_MATERIAL.getValues()) {
            for (ICasingMaterial casingId : DoggyTalentsAPI.CASING_MATERIAL.getValues()) {
                items.add((Object)DogBedUtil.createItemStack(casingId, beddingId));
            }
        }
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        DogBedTileEntity dogBedTileEntity = WorldUtil.getTileEntity(world, pos, DogBedTileEntity.class);
        if (dogBedTileEntity != null) {
            return DogBedUtil.createItemStack(dogBedTileEntity.getCasing(), dogBedTileEntity.getBedding());
        }
        DoggyTalents2.LOGGER.debug("Unable to pick block on dog bed.");
        return ItemStack.field_190927_a;
    }
}

