/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.block.tileentity;

import doggytalents.DoggyTileEntityTypes;
import doggytalents.api.feature.FoodHandler;
import doggytalents.common.block.tileentity.PlacedTileEntity;
import doggytalents.common.entity.DogEntity;
import doggytalents.common.inventory.container.FoodBowlContainer;
import doggytalents.common.util.InventoryUtil;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class FoodBowlTileEntity
extends PlacedTileEntity
implements INamedContainerProvider,
ITickableTileEntity {
    private final ItemStackHandler inventory = new ItemStackHandler(5){

        protected void onContentsChanged(int slot) {
            FoodBowlTileEntity.this.func_70296_d();
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return FoodHandler.isFood(stack).isPresent();
        }
    };
    private final LazyOptional<ItemStackHandler> itemStackHandler = LazyOptional.of(() -> this.inventory);
    public int timeoutCounter;

    public FoodBowlTileEntity() {
        super((TileEntityType)DoggyTileEntityTypes.FOOD_BOWL.get());
    }

    @Override
    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        this.inventory.deserializeNBT(compound);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_197643_a(this.inventory.serializeNBT());
        return compound;
    }

    public void func_73660_a() {
        if (++this.timeoutCounter < 5) {
            return;
        }
        List dogList = this.field_145850_b.func_217357_a(DogEntity.class, new AxisAlignedBB(this.field_174879_c).func_72314_b(5.0, 5.0, 5.0));
        for (DogEntity dog : dogList) {
            UUID placerId = this.getPlacerId();
            if (placerId != null && placerId.equals(dog.func_184753_b()) && !dog.getBowlPos().isPresent()) {
                dog.setBowlPos(this.field_174879_c);
            }
            if (!(dog.getDogHunger() < dog.getMaxHunger() / 2.0f)) continue;
            InventoryUtil.feedDogFrom(dog, null, (IItemHandlerModifiable)this.inventory);
        }
        this.timeoutCounter = 0;
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemStackHandler;
        }
        return super.getCapability(cap, side);
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("container.doggytalents.food_bowl", new Object[0]);
    }

    public Container createMenu(int windowId, PlayerInventory playerInventory, PlayerEntity playerIn) {
        return new FoodBowlContainer(windowId, this.field_145850_b, this.field_174879_c, playerInventory, playerIn);
    }
}

