/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.data;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import doggytalents.DoggyEntityTypes;
import doggytalents.DoggyItems;
import doggytalents.common.data.DisplayInfoBuilder;
import doggytalents.common.util.Util;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.IRequirementsStrategy;
import net.minecraft.advancements.criterion.EntityPredicate;
import net.minecraft.advancements.criterion.InventoryChangeTrigger;
import net.minecraft.advancements.criterion.TameAnimalTrigger;
import net.minecraft.block.Blocks;
import net.minecraft.data.AdvancementProvider;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DTAdvancementProvider
extends AdvancementProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final DataGenerator generator;

    public DTAdvancementProvider(DataGenerator generatorIn) {
        super(generatorIn);
        this.generator = generatorIn;
    }

    public String func_200397_b() {
        return "DoggyTalents Advancements";
    }

    public void func_200398_a(DirectoryCache cache) throws IOException {
        Path path = this.generator.func_200391_b();
        HashSet set = Sets.newHashSet();
        Consumer<Advancement> consumer = p_204017_3_ -> {
            if (!set.add(p_204017_3_.func_192067_g())) {
                throw new IllegalStateException("Duplicate advancement " + p_204017_3_.func_192067_g());
            }
            Path path1 = DTAdvancementProvider.getPath(path, p_204017_3_);
            try {
                IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)p_204017_3_.func_192075_a().func_200273_b(), (Path)path1);
            }
            catch (IOException ioexception) {
                LOGGER.error("Couldn't save advancement {}", (Object)path1, (Object)ioexception);
            }
        };
        Advancement advancement = Advancement.Builder.func_200278_a().func_203903_a(DisplayInfoBuilder.create().icon((Supplier<? extends IItemProvider>)DoggyItems.TRAINING_TREAT).frame(FrameType.TASK).translate("dog.root").background("stone.png").noToast().noAnnouncement().build()).func_200275_a("tame_dog", (ICriterionInstance)TameAnimalTrigger.Instance.func_215124_a((EntityPredicate)EntityPredicate.Builder.func_203996_a().func_203998_a((EntityType)DoggyEntityTypes.DOG.get()).func_204000_b())).func_200270_a(IRequirementsStrategy.field_223215_b_).func_203904_a(consumer, Util.getResourcePath("default/tame_dog"));
        Advancement advancement1 = Advancement.Builder.func_200278_a().func_203905_a(advancement).func_203903_a(DisplayInfoBuilder.create().icon((IItemProvider)Items.field_151039_o).frame(FrameType.TASK).translate("dog.level_talent").build()).func_200275_a("level_talent", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{Blocks.field_150347_e})).func_203904_a(consumer, Util.getResourcePath("default/level_talent"));
        Advancement advancement2 = Advancement.Builder.func_200278_a().func_203905_a(advancement1).func_203903_a(DisplayInfoBuilder.create().icon((Supplier<? extends IItemProvider>)DoggyItems.CAPE).frame(FrameType.TASK).translate("dog.accessorise").build()).func_200275_a("accessorise", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{Items.field_151050_s})).func_203904_a(consumer, Util.getResourcePath("default/accessorise"));
        Advancement advancement3 = Advancement.Builder.func_200278_a().func_203905_a(advancement2).func_203903_a(DisplayInfoBuilder.create().icon((Supplier<? extends IItemProvider>)DoggyItems.RADIO_COLLAR).frame(FrameType.TASK).translate("dog.radio_collar").build()).func_200275_a("iron", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{Items.field_151042_j})).func_203904_a(consumer, Util.getResourcePath("default/radio_collar"));
    }

    private static Path getPath(Path pathIn, Advancement advancementIn) {
        return pathIn.resolve("data/" + advancementIn.func_192067_g().func_110624_b() + "/advancements/" + advancementIn.func_192067_g().func_110623_a() + ".json");
    }
}

