/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.data;

import com.google.common.collect.Maps;
import doggytalents.DoggyItems;
import doggytalents.common.util.Util;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.IRequirementsStrategy;
import net.minecraft.advancements.criterion.InventoryChangeTrigger;
import net.minecraft.block.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class DoggyTalentsAdvancements
implements Consumer<Consumer<Advancement>> {
    @Override
    public void accept(Consumer<Advancement> register) {
        Advancement advancement = Advancement.Builder.func_200278_a().func_203902_a((IItemProvider)DoggyItems.TRAINING_TREAT.get(), (ITextComponent)new TranslationTextComponent("advancements.dog.root.title", new Object[0]), (ITextComponent)new TranslationTextComponent("advancements.dog.root.description", new Object[0]), new ResourceLocation("textures/gui/advancements/backgrounds/stone.png"), FrameType.TASK, false, false, false).func_200275_a("crafting_table", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{Blocks.field_150462_ai})).func_203904_a(register, Util.getResourcePath("dog/find_dog"));
        Advancement advancement1 = Advancement.Builder.func_200278_a().func_203905_a(advancement).func_203902_a((IItemProvider)Items.field_151039_o, (ITextComponent)new TranslationTextComponent("advancements.dog.mine_stone.title", new Object[0]), (ITextComponent)new TranslationTextComponent("advancements.dog.mine_stone.description", new Object[0]), (ResourceLocation)null, FrameType.TASK, true, true, false).func_200275_a("get_stone", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{Blocks.field_150347_e})).func_203904_a(register, Util.getResourcePath("dog/level_talent"));
        Advancement advancement2 = Advancement.Builder.func_200278_a().func_203905_a(advancement1).func_203902_a((IItemProvider)DoggyItems.CAPE.get(), (ITextComponent)new TranslationTextComponent("advancements.dog.upgrade_tools.title", new Object[0]), (ITextComponent)new TranslationTextComponent("advancements.dog.upgrade_tools.description", new Object[0]), (ResourceLocation)null, FrameType.TASK, true, true, false).func_200275_a("stone_pickaxe", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{Items.field_151050_s})).func_203904_a(register, Util.getResourcePath("dog/accessorise"));
        Advancement advancement3 = Advancement.Builder.func_200278_a().func_203905_a(advancement2).func_203902_a((IItemProvider)DoggyItems.RADIO_COLLAR.get(), (ITextComponent)new TranslationTextComponent("advancements.dog.smelt_iron.title", new Object[0]), (ITextComponent)new TranslationTextComponent("advancements.dog.smelt_iron.description", new Object[0]), (ResourceLocation)null, FrameType.TASK, true, true, false).func_200275_a("iron", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{Items.field_151042_j})).func_203904_a(register, Util.getResourcePath("dog/radio_collar"));
    }

    public static class Builder {
        private ResourceLocation parentId;
        private Advancement parent;
        private DisplayInfo display;
        private AdvancementRewards rewards = AdvancementRewards.field_192114_a;
        private Map<String, Criterion> criteria = Maps.newLinkedHashMap();
        private String[][] requirements;
        private IRequirementsStrategy requirementsStrategy = IRequirementsStrategy.field_223214_a_;

        private Builder(@Nullable ResourceLocation parentIdIn, @Nullable DisplayInfo displayIn, AdvancementRewards rewardsIn, Map<String, Criterion> criteriaIn, String[][] requirementsIn) {
            this.parentId = parentIdIn;
            this.display = displayIn;
            this.rewards = rewardsIn;
            this.criteria = criteriaIn;
            this.requirements = requirementsIn;
        }

        private Builder() {
        }

        public static Builder builder() {
            return new Builder();
        }

        public Builder withParent(Advancement parentIn) {
            this.parent = parentIn;
            return this;
        }

        public Builder withParentId(ResourceLocation parentIdIn) {
            this.parentId = parentIdIn;
            return this;
        }

        public Builder withDisplay(ItemStack stack, ITextComponent title, ITextComponent description, @Nullable ResourceLocation background, FrameType frame, boolean showToast, boolean announceToChat, boolean hidden) {
            return this.withDisplay(new DisplayInfo(stack, title, description, background, frame, showToast, announceToChat, hidden));
        }

        public Builder withDisplay(IItemProvider itemIn, ITextComponent title, ITextComponent description, @Nullable ResourceLocation background, FrameType frame, boolean showToast, boolean announceToChat, boolean hidden) {
            return this.withDisplay(new DisplayInfo(new ItemStack((IItemProvider)itemIn.func_199767_j()), title, description, background, frame, showToast, announceToChat, hidden));
        }

        public Builder withDisplay(DisplayInfo displayIn) {
            this.display = displayIn;
            return this;
        }

        public Builder withRewards(AdvancementRewards.Builder rewardsBuilder) {
            return this.withRewards(rewardsBuilder.func_200281_a());
        }

        public Builder withRewards(AdvancementRewards p_200274_1_) {
            this.rewards = p_200274_1_;
            return this;
        }

        public Builder withCriterion(String key, ICriterionInstance criterionIn) {
            return this.withCriterion(key, new Criterion(criterionIn));
        }

        public Builder withCriterion(String key, Criterion criterionIn) {
            if (this.criteria.containsKey(key)) {
                throw new IllegalArgumentException("Duplicate criterion " + key);
            }
            this.criteria.put(key, criterionIn);
            return this;
        }

        public Builder withRequirementsStrategy(IRequirementsStrategy strategy) {
            this.requirementsStrategy = strategy;
            return this;
        }

        public boolean resolveParent(Function<ResourceLocation, Advancement> lookup) {
            if (this.parentId == null) {
                return true;
            }
            if (this.parent == null) {
                this.parent = lookup.apply(this.parentId);
            }
            return this.parent != null;
        }

        public Advancement build(ResourceLocation id) {
            if (!this.resolveParent(p_199750_0_ -> null)) {
                throw new IllegalStateException("Tried to build incomplete advancement!");
            }
            if (this.requirements == null) {
                this.requirements = this.requirementsStrategy.createRequirements(this.criteria.keySet());
            }
            return new Advancement(id, this.parent, this.display, this.rewards, this.criteria, this.requirements);
        }

        public Advancement register(Consumer<Advancement> consumer, String id) {
            Advancement advancement = this.build(new ResourceLocation(id));
            consumer.accept(advancement);
            return advancement;
        }
    }
}

