/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity;

import com.google.common.base.Predicates;
import doggytalents.DoggyEntityTypes;
import doggytalents.api.feature.EnumMode;
import doggytalents.common.entity.DogEntity;
import doggytalents.common.util.EntityUtil;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;

public class DoggyBeamEntity
extends ThrowableEntity
implements IEntityAdditionalSpawnData {
    public DoggyBeamEntity(EntityType<? extends ThrowableEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public DoggyBeamEntity(World worldIn, LivingEntity livingEntityIn) {
        super((EntityType)DoggyEntityTypes.DOG_BEAM.get(), livingEntityIn, worldIn);
    }

    public DoggyBeamEntity(FMLPlayMessages.SpawnEntity packet, World worldIn) {
        super((EntityType)DoggyEntityTypes.DOG_BEAM.get(), worldIn);
    }

    protected void func_70184_a(RayTraceResult result) {
        if (result.func_216346_c() == RayTraceResult.Type.ENTITY) {
            Entity entityHit = ((EntityRayTraceResult)result).func_216348_a();
            LivingEntity thrower = this.func_85052_h();
            if (thrower != null && entityHit instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entityHit;
                this.field_70170_p.func_217357_a(DogEntity.class, this.func_174813_aQ().func_72314_b(64.0, 16.0, 64.0)).stream().filter(Predicates.not(TameableEntity::func_70906_o)).filter(d -> d.isMode(EnumMode.AGGRESIVE, EnumMode.TACTICAL, EnumMode.BERSERKER)).filter(d -> d.canInteract(thrower)).filter(d -> d != livingEntity && d.func_142018_a(livingEntity, d.func_70902_q())).filter(d -> (double)d.func_70032_d(entityHit) < EntityUtil.getFollowRange((LivingEntity)d)).forEach(d -> d.func_70624_b(livingEntity));
            }
            for (int j = 0; j < 8; ++j) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197593_D, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.0, 0.0, 0.0);
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)3);
            this.func_70106_y();
        }
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(PacketBuffer buffer) {
        UUID ownerId = this.field_200218_h;
        buffer.writeBoolean(ownerId != null);
        if (ownerId != null) {
            buffer.func_179252_a(ownerId);
        }
    }

    public void readSpawnData(PacketBuffer buffer) {
        boolean hasThrower = buffer.readBoolean();
        if (hasThrower) {
            this.field_200218_h = buffer.func_179253_g();
        }
    }

    protected void func_70088_a() {
    }
}

