/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.item;

import com.google.common.collect.Lists;
import doggytalents.DoggyItems;
import doggytalents.common.storage.DogLocationData;
import doggytalents.common.storage.DogLocationStorage;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;

public class RadarItem
extends Item {
    public RadarItem(Item.Properties properties) {
        super(properties);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (!worldIn.field_72995_K) {
            if (playerIn.func_225608_bj_()) {
                DogLocationStorage locationManager = DogLocationStorage.get(worldIn);
                for (UUID uuid : locationManager.getAllUUID()) {
                    playerIn.func_145747_a((ITextComponent)new StringTextComponent(locationManager.getData(uuid).toString()));
                }
                return new ActionResult(ActionResultType.FAIL, (Object)playerIn.func_184586_b(handIn));
            }
            DimensionType dimCurr = playerIn.field_71093_bK;
            playerIn.func_145747_a((ITextComponent)new StringTextComponent(""));
            DogLocationStorage locationManager = DogLocationStorage.get(worldIn);
            List ownDogs = locationManager.getDogs((LivingEntity)playerIn, worldIn.func_201675_m().func_186058_p()).collect(Collectors.toList());
            if (ownDogs.isEmpty()) {
                playerIn.func_145747_a((ITextComponent)new TranslationTextComponent("dogradar.errornull", new Object[]{String.valueOf(DimensionType.func_212678_a((DimensionType)dimCurr))}));
            } else {
                boolean flag = false;
                for (DogLocationData loc : ownDogs) {
                    if (!loc.shouldDisplay(worldIn, playerIn, handIn)) continue;
                    flag = true;
                    String translateStr = RadarItem.getDirectionTranslationKey(loc, (Entity)playerIn);
                    int distance = MathHelper.func_76143_f((double)(loc.getPos() != null ? loc.getPos().func_72438_d(playerIn.func_174791_d()) : -1.0));
                    playerIn.func_145747_a((ITextComponent)new TranslationTextComponent(translateStr, new Object[]{loc.getName(worldIn), distance}));
                }
                if (!flag) {
                    playerIn.func_145747_a((ITextComponent)new TranslationTextComponent("dogradar.errornoradio", new Object[0]));
                }
            }
            ArrayList otherDogs = Lists.newArrayList();
            ArrayList noDogs = Lists.newArrayList();
            for (DimensionType dimType : DimensionType.func_212681_b()) {
                if (dimCurr == dimType) continue;
                ownDogs = locationManager.getDogs((LivingEntity)playerIn, dimType).collect(Collectors.toList());
                (ownDogs.size() > 0 ? otherDogs : noDogs).add(dimType);
            }
            if (otherDogs.size() > 0) {
                playerIn.func_145747_a((ITextComponent)new TranslationTextComponent("dogradar.notindim", new Object[]{otherDogs.stream().map(dim -> String.valueOf(DimensionType.func_212678_a((DimensionType)dim))).collect(Collectors.joining(", "))}));
            }
            if (noDogs.size() > 0 && stack.func_77973_b() == DoggyItems.CREATIVE_RADAR.get()) {
                playerIn.func_145747_a((ITextComponent)new TranslationTextComponent("dogradar.errornull", new Object[]{noDogs.stream().map(dim -> String.valueOf(DimensionType.func_212678_a((DimensionType)dim))).collect(Collectors.joining(", "))}));
            }
        }
        return new ActionResult(ActionResultType.FAIL, (Object)stack);
    }

    public static String getDirectionTranslationKey(DogLocationData loc, Entity entity) {
        if (loc.getPos() == null) {
            return "dogradar.unknown";
        }
        Vec3d diff = loc.getPos().func_178787_e(entity.func_174791_d().func_216371_e());
        double angle = MathHelper.func_181159_b((double)diff.func_82615_a(), (double)diff.func_82616_c());
        if (angle < -2.748893571891069) {
            return "dogradar.north";
        }
        if (angle < -1.9634954084936207) {
            return "dogradar.north.west";
        }
        if (angle < -1.1780972450961724) {
            return "dogradar.west";
        }
        if (angle < -0.39269908169872414) {
            return "dogradar.south.west";
        }
        if (angle < 0.39269908169872414) {
            return "dogradar.south";
        }
        if (angle < 1.178097245096172) {
            return "dogradar.south.east";
        }
        if (angle < 1.9634954084936211) {
            return "dogradar.east";
        }
        if (angle < 2.7488935718910685) {
            return "dogradar.north.east";
        }
        return "dogradar.north";
    }
}

