/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.item;

import doggytalents.api.feature.DogLevel;
import doggytalents.api.inferface.AbstractDogEntity;
import doggytalents.api.inferface.IDogItem;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class TreatItem
extends Item
implements IDogItem {
    private final int maxLevel;
    private final DogLevel.Type type;

    public TreatItem(int maxLevel, DogLevel.Type typeIn, Item.Properties properties) {
        super(properties);
        this.maxLevel = maxLevel;
        this.type = typeIn;
    }

    @Override
    public ActionResultType processInteract(AbstractDogEntity dogIn, World worldIn, PlayerEntity playerIn, Hand handIn) {
        if (!dogIn.func_70909_n() || !dogIn.canInteract((LivingEntity)playerIn)) {
            return ActionResultType.FAIL;
        }
        DogLevel dogLevel = dogIn.getLevel();
        if (dogIn.func_70874_b() < 0) {
            if (!worldIn.field_72995_K) {
                worldIn.func_72960_a((Entity)dogIn, (byte)6);
                playerIn.func_145747_a((ITextComponent)new TranslationTextComponent("treat." + this.type.getName() + ".too_young", new Object[0]));
            }
            return ActionResultType.CONSUME;
        }
        if (!dogLevel.canIncrease(this.type)) {
            if (!worldIn.field_72995_K) {
                worldIn.func_72960_a((Entity)dogIn, (byte)6);
                playerIn.func_145747_a((ITextComponent)new TranslationTextComponent("treat." + this.type.getName() + ".low_level", new Object[0]));
            }
            return ActionResultType.CONSUME;
        }
        if (dogLevel.getLevel(this.type) < this.maxLevel) {
            if (!playerIn.field_70170_p.field_72995_K) {
                if (!playerIn.field_71075_bZ.field_75098_d) {
                    playerIn.func_184586_b(handIn).func_190918_g(1);
                }
                dogIn.increaseLevel(this.type);
                dogIn.func_70606_j(dogIn.func_110138_aP());
                dogIn.func_70907_r().func_75270_a(true);
                worldIn.func_72960_a((Entity)dogIn, (byte)7);
                playerIn.func_145747_a((ITextComponent)new TranslationTextComponent("treat." + this.type.getName() + ".level_up", new Object[0]));
            }
            return ActionResultType.SUCCESS;
        }
        if (!worldIn.field_72995_K) {
            worldIn.func_72960_a((Entity)dogIn, (byte)6);
            playerIn.func_145747_a((ITextComponent)new TranslationTextComponent("treat." + this.type.getName() + ".max_level", new Object[0]));
        }
        return ActionResultType.CONSUME;
    }
}

