/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.network.packet;

import doggytalents.DoggyTalents2;
import doggytalents.api.DoggyTalentsAPI;
import doggytalents.api.registry.Talent;
import doggytalents.common.config.ConfigValues;
import doggytalents.common.entity.DogEntity;
import doggytalents.common.network.packet.DogPacket;
import doggytalents.common.network.packet.data.DogTalentData;
import java.util.function.Supplier;
import net.minecraft.entity.LivingEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class DogTalentPacket
extends DogPacket<DogTalentData> {
    @Override
    public void encode(DogTalentData data, PacketBuffer buf) {
        super.encode(data, buf);
        buf.writeRegistryIdUnsafe(DoggyTalentsAPI.TALENTS, (IForgeRegistryEntry)data.talent);
    }

    @Override
    public DogTalentData decode(PacketBuffer buf) {
        int entityId = buf.readInt();
        Talent talent = (Talent)buf.readRegistryIdUnsafe(DoggyTalentsAPI.TALENTS);
        return new DogTalentData(entityId, talent);
    }

    @Override
    public void handleDog(DogEntity dogIn, DogTalentData data, Supplier<NetworkEvent.Context> ctx) {
        if (!dogIn.canInteract((LivingEntity)ctx.get().getSender())) {
            return;
        }
        if (ConfigValues.DISABLED_TALENTS.contains(data.talent)) {
            DoggyTalents2.LOGGER.info("{} tried to level a disabled talent ({})", (Object)ctx.get().getSender().func_146103_bH().getName(), (Object)data.talent.getRegistryName());
            return;
        }
        int level = dogIn.getLevel(data.talent);
        if (level < data.talent.getMaxLevel() && dogIn.canSpendPoints(data.talent.getLevelCost(level + 1))) {
            dogIn.setTalentLevel(data.talent, level + 1);
        }
    }
}

