/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.storage;

import com.google.common.collect.Maps;
import doggytalents.DoggyTalents2;
import doggytalents.common.entity.DogEntity;
import doggytalents.common.storage.DogLocationData;
import doggytalents.common.util.NBTUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.DimensionSavedDataManager;
import net.minecraft.world.storage.WorldSavedData;

public class DogLocationStorage
extends WorldSavedData {
    private Map<UUID, DogLocationData> locationDataMap = Maps.newConcurrentMap();

    public DogLocationStorage() {
        super("dog_locations");
    }

    public static DogLocationStorage get(World world) {
        if (!(world instanceof ServerWorld)) {
            throw new RuntimeException("Tried to access dog location data from the client. This should not happen...");
        }
        ServerWorld overworld = world.func_73046_m().func_71218_a(DimensionType.field_223227_a_);
        DimensionSavedDataManager storage = overworld.func_217481_x();
        return (DogLocationStorage)storage.func_215752_a(DogLocationStorage::new, "dog_locations");
    }

    public Stream<DogLocationData> getDogs(LivingEntity owner) {
        UUID ownerId = owner.func_110124_au();
        return this.locationDataMap.values().stream().filter(data -> ownerId.equals(data.getOwnerId()));
    }

    public Stream<DogLocationData> getDogs(LivingEntity owner, DimensionType type) {
        UUID ownerId = owner.func_110124_au();
        return this.locationDataMap.values().stream().filter(data -> ownerId.equals(data.getOwnerId())).filter(data -> type.equals(data.getDimension()));
    }

    @Nullable
    public DogLocationData getData(DogEntity dogIn) {
        return this.getData(dogIn.func_110124_au());
    }

    @Nullable
    public DogLocationData getData(UUID uuid) {
        if (this.locationDataMap.containsKey(uuid)) {
            return this.locationDataMap.get(uuid);
        }
        return null;
    }

    @Nullable
    public DogLocationData remove(DogEntity dogIn) {
        return this.remove(dogIn.func_110124_au());
    }

    @Nullable
    public DogLocationData getOrCreateData(DogEntity dogIn) {
        UUID uuid = dogIn.func_110124_au();
        return this.locationDataMap.computeIfAbsent(uuid, $ -> {
            this.func_76185_a();
            return DogLocationData.from(this, dogIn);
        });
    }

    @Nullable
    public DogLocationData remove(UUID uuid) {
        if (this.locationDataMap.containsKey(uuid)) {
            DogLocationData storage = this.locationDataMap.remove(uuid);
            this.func_76185_a();
            return storage;
        }
        return null;
    }

    @Nullable
    public DogLocationData putData(DogEntity dogIn) {
        UUID uuid = dogIn.func_110124_au();
        DogLocationData storage = new DogLocationData(this, uuid);
        this.locationDataMap.put(uuid, storage);
        this.func_76185_a();
        return storage;
    }

    public Set<UUID> getAllUUID() {
        return Collections.unmodifiableSet(this.locationDataMap.keySet());
    }

    public Collection<DogLocationData> getAll() {
        return Collections.unmodifiableCollection(this.locationDataMap.values());
    }

    public void func_76184_a(CompoundNBT nbt) {
        this.locationDataMap.clear();
        ListNBT list = nbt.func_150295_c("locationData", 10);
        if (list.isEmpty()) {
            list = nbt.func_150295_c("dog_locations", 10);
        }
        for (int i = 0; i < list.size(); ++i) {
            CompoundNBT locationCompound = list.func_150305_b(i);
            UUID uuid = NBTUtil.getUniqueId(locationCompound, "uuid");
            if (uuid == null) {
                uuid = NBTUtil.getUniqueId(locationCompound, "entityId");
            }
            DogLocationData locationData = new DogLocationData(this, uuid);
            locationData.read(locationCompound);
            if (uuid == null) {
                DoggyTalents2.LOGGER.info("Failed to load dog location data. Please report to mod author...");
                DoggyTalents2.LOGGER.info((Object)locationData);
                continue;
            }
            this.locationDataMap.put(uuid, locationData);
        }
    }

    public CompoundNBT func_189551_b(CompoundNBT compound) {
        ListNBT list = new ListNBT();
        for (Map.Entry<UUID, DogLocationData> entry : this.locationDataMap.entrySet()) {
            CompoundNBT locationCompound = new CompoundNBT();
            DogLocationData locationData = entry.getValue();
            NBTUtil.putUniqueId(locationCompound, "uuid", entry.getKey());
            locationData.write(locationCompound);
            list.add((Object)locationCompound);
        }
        compound.func_218657_a("locationData", (INBT)list);
        return compound;
    }
}

