/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.talent;

import doggytalents.api.inferface.AbstractDogEntity;
import doggytalents.api.registry.Talent;
import java.util.UUID;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;

public class BlackPeltTalent
extends Talent {
    private static final UUID BLACK_PELT_DAMAGE_ID = UUID.fromString("9abeafa9-3913-4b4c-b46e-0f1548fb19b3");
    private static final UUID BLACK_PELT_CRIT_CHANCE_ID = UUID.fromString("f07b5d39-a8cc-4d32-b458-6efdf1dc6836");
    private static final UUID BLACK_PELT_CRIT_BONUS_ID = UUID.fromString("e19e0d42-6ee3-4ee1-af1c-7519af4354cd");

    @Override
    public void init(AbstractDogEntity dogIn) {
        dogIn.setAttributeModifier(SharedMonsterAttributes.field_111264_e, BLACK_PELT_DAMAGE_ID, this::createPeltModifier);
        dogIn.setAttributeModifier(AbstractDogEntity.CRIT_CHANCE, BLACK_PELT_CRIT_CHANCE_ID, this::createPeltCritChance);
        dogIn.setAttributeModifier(AbstractDogEntity.CRIT_BONUS, BLACK_PELT_CRIT_BONUS_ID, this::createPeltCritBonus);
    }

    @Override
    public void set(AbstractDogEntity dogIn, int level) {
        dogIn.setAttributeModifier(SharedMonsterAttributes.field_111264_e, BLACK_PELT_DAMAGE_ID, this::createPeltModifier);
        dogIn.setAttributeModifier(AbstractDogEntity.CRIT_CHANCE, BLACK_PELT_CRIT_CHANCE_ID, this::createPeltCritChance);
        dogIn.setAttributeModifier(AbstractDogEntity.CRIT_BONUS, BLACK_PELT_CRIT_BONUS_ID, this::createPeltCritBonus);
    }

    @Override
    public void removed(AbstractDogEntity dogIn, int preLevel) {
        dogIn.removeAttributeModifier(SharedMonsterAttributes.field_111264_e, BLACK_PELT_DAMAGE_ID);
        dogIn.removeAttributeModifier(AbstractDogEntity.CRIT_CHANCE, BLACK_PELT_CRIT_CHANCE_ID);
        dogIn.removeAttributeModifier(AbstractDogEntity.CRIT_BONUS, BLACK_PELT_CRIT_BONUS_ID);
    }

    public AttributeModifier createPeltModifier(AbstractDogEntity dogIn, UUID uuidIn) {
        int level = dogIn.getLevel(this);
        if (level > 0) {
            double damageBonus = level;
            if (level >= 5) {
                damageBonus += 2.0;
            }
            return new AttributeModifier(uuidIn, "Black Pelt", damageBonus, AttributeModifier.Operation.ADDITION).func_111168_a(false);
        }
        return null;
    }

    public AttributeModifier createPeltCritChance(AbstractDogEntity dogIn, UUID uuidIn) {
        int level = dogIn.getLevel(this);
        if (level <= 0) {
            return null;
        }
        double damageBonus = 0.15 * (double)level;
        if (level >= 5) {
            damageBonus = 1.0;
        }
        return new AttributeModifier(uuidIn, "Black Pelt Crit Chance", damageBonus, AttributeModifier.Operation.ADDITION).func_111168_a(false);
    }

    public AttributeModifier createPeltCritBonus(AbstractDogEntity dogIn, UUID uuidIn) {
        int level = dogIn.getLevel(this);
        if (level <= 0) {
            return null;
        }
        return new AttributeModifier(uuidIn, "Black Pelt Crit Bonus", 1.0, AttributeModifier.Operation.MULTIPLY_TOTAL).func_111168_a(false);
    }
}

