/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.talent;

import doggytalents.DoggyTags;
import doggytalents.DoggyTalents;
import doggytalents.api.feature.DataKey;
import doggytalents.api.inferface.AbstractDogEntity;
import doggytalents.api.registry.Talent;
import doggytalents.common.inventory.PackPuppyItemHandler;
import doggytalents.common.util.InventoryUtil;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;

public class PackPuppyTalent
extends Talent {
    @CapabilityInject(value=PackPuppyItemHandler.class)
    public static Capability<PackPuppyItemHandler> PACK_PUPPY_CAPABILITY = null;
    public static DataKey<PackPuppyItemHandler> PACK_PUPPY_HANDLER = DataKey.makeFinal();
    public static DataKey<LazyOptional<?>> LAZY_PACK_PUPPY_HANDLER = DataKey.makeFinal();
    public static Predicate<ItemEntity> SHOULD_PICKUP_ENTITY_ITEM = entity -> entity.func_70089_S() && !entity.func_174874_s() && !entity.func_92059_d().func_77973_b().func_206844_a(DoggyTags.PACK_PUPPY_BLACKLIST);

    @Override
    public void tick(AbstractDogEntity dogIn) {
        List list;
        if (dogIn.func_70089_S() && !dogIn.field_70170_p.field_72995_K && dogIn.getLevel(this) >= 5 && !(list = dogIn.field_70170_p.func_175647_a(ItemEntity.class, dogIn.func_174813_aQ().func_72314_b(2.5, 1.0, 2.5), SHOULD_PICKUP_ENTITY_ITEM)).isEmpty()) {
            IItemHandler inventory = (IItemHandler)dogIn.getData(PACK_PUPPY_HANDLER);
            for (ItemEntity entityItem : list) {
                ItemStack remaining = InventoryUtil.addItem(inventory, entityItem.func_92059_d());
                if (!remaining.func_190926_b()) {
                    entityItem.func_92058_a(remaining);
                    continue;
                }
                entityItem.func_70106_y();
                dogIn.func_184185_a(SoundEvents.field_187638_cR, 0.25f, ((dogIn.field_70170_p.field_73012_v.nextFloat() - dogIn.field_70170_p.field_73012_v.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            }
        }
    }

    @Override
    public void init(AbstractDogEntity dog) {
        PackPuppyItemHandler handler = new PackPuppyItemHandler(dog);
        dog.setDataIfEmpty(PACK_PUPPY_HANDLER, (Object)handler);
        dog.setDataIfEmpty(LAZY_PACK_PUPPY_HANDLER, LazyOptional.of(() -> handler));
    }

    @Override
    public ActionResultType processInteract(AbstractDogEntity dogIn, World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        int level = dogIn.getLevel(this);
        if (dogIn.func_70909_n() && level > 0 && playerIn.func_225608_bj_() && stack.func_190926_b() && dogIn.canInteract((LivingEntity)playerIn)) {
            if (!playerIn.field_70170_p.field_72995_K) {
                playerIn.func_146105_b((ITextComponent)new TranslationTextComponent("talent.doggytalents.pack_puppy.version_migration", new Object[0]), false);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    @Override
    public void removed(AbstractDogEntity dog, int preLevel) {
        if (preLevel > 0) {
            this.dropInventory(dog);
        }
    }

    @Override
    public void dropInventory(AbstractDogEntity dogIn) {
        PackPuppyItemHandler inventory = (PackPuppyItemHandler)((Object)dogIn.getData(PACK_PUPPY_HANDLER));
        for (int i = 0; i < inventory.getSlots(); ++i) {
            InventoryHelper.func_180173_a((World)dogIn.field_70170_p, (double)dogIn.func_226277_ct_(), (double)dogIn.func_226278_cu_(), (double)dogIn.func_226281_cx_(), (ItemStack)inventory.getStackInSlot(i));
            inventory.setStackInSlot(i, ItemStack.field_190927_a);
        }
    }

    @Override
    public void write(AbstractDogEntity dogIn, CompoundNBT compound) {
        PackPuppyItemHandler inventory = (PackPuppyItemHandler)((Object)dogIn.getData(PACK_PUPPY_HANDLER));
        compound.func_197643_a(inventory.serializeNBT());
    }

    @Override
    public void read(AbstractDogEntity dogIn, CompoundNBT compound) {
        PackPuppyItemHandler inventory = (PackPuppyItemHandler)((Object)dogIn.getData(PACK_PUPPY_HANDLER));
        inventory.deserializeNBT(compound);
    }

    @Override
    public <T> LazyOptional<T> getCapability(AbstractDogEntity dogIn, Capability<T> cap, Direction side) {
        if (cap == PACK_PUPPY_CAPABILITY) {
            return (LazyOptional)dogIn.getData(LAZY_PACK_PUPPY_HANDLER);
        }
        return null;
    }

    @Override
    public void invalidateCapabilities(AbstractDogEntity dogIn) {
        ((LazyOptional)dogIn.getData(LAZY_PACK_PUPPY_HANDLER)).invalidate();
    }

    @Override
    public boolean hasRenderer() {
        return true;
    }

    public static boolean hasInventory(AbstractDogEntity dogIn) {
        return dogIn.func_70089_S() && dogIn.getData(PACK_PUPPY_HANDLER) != null && dogIn.getLevel((Supplier)DoggyTalents.PACK_PUPPY) > 0;
    }
}

