/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.talent;

import doggytalents.api.feature.DataKey;
import doggytalents.api.inferface.AbstractDogEntity;
import doggytalents.api.registry.Talent;
import doggytalents.common.util.EntityUtil;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class PuppyEyesTalent
extends Talent {
    private static DataKey<Integer> COOLDOWN = DataKey.make();

    @Override
    public void init(AbstractDogEntity dogIn) {
        dogIn.setDataIfEmpty(COOLDOWN, dogIn.field_70173_aa);
    }

    @Override
    public void write(AbstractDogEntity dogIn, CompoundNBT compound) {
        int timeLeft = (Integer)dogIn.getDataOrDefault(COOLDOWN, dogIn.field_70173_aa) - dogIn.field_70173_aa;
        compound.func_74768_a("charmercharge", timeLeft);
    }

    @Override
    public void read(AbstractDogEntity dogIn, CompoundNBT compound) {
        dogIn.setData(COOLDOWN, dogIn.field_70173_aa + compound.func_74762_e("charmercharge"));
    }

    @Override
    public void livingTick(AbstractDogEntity dogIn) {
        if (dogIn.field_70173_aa % 40 != 0) {
            return;
        }
        if (dogIn.field_70170_p.field_72995_K || !dogIn.func_70909_n()) {
            return;
        }
        int level = dogIn.getLevel(this);
        if (level <= 0) {
            return;
        }
        int timeLeft = (Integer)dogIn.getDataOrDefault(COOLDOWN, dogIn.field_70173_aa) - dogIn.field_70173_aa;
        if (timeLeft <= 0) {
            LivingEntity owner = dogIn.func_70902_q();
            if (owner == null) {
                return;
            }
            LivingEntity villager = this.getClosestVisibleVillager(dogIn, 5.0);
            if (villager != null) {
                int rewardId = dogIn.func_70681_au().nextInt(level) + (level >= 5 ? 1 : 0);
                if (rewardId == 0) {
                    owner.func_145747_a((ITextComponent)new TranslationTextComponent("talent.doggytalents.puppy_eyes.msg.1.line.1", new Object[]{dogIn.getGenderPronoun()}));
                    owner.func_145747_a((ITextComponent)new TranslationTextComponent("talent.doggytalents.puppy_eyes.msg.1.line.2", new Object[]{dogIn.getGenderSubject()}));
                    villager.func_199702_a((IItemProvider)Items.field_151147_al, 2);
                } else if (rewardId == 1) {
                    owner.func_145747_a((ITextComponent)new TranslationTextComponent("talent.doggytalents.puppy_eyes.msg.2.line.1", new Object[]{dogIn.getGenderTitle()}));
                    owner.func_145747_a((ITextComponent)new TranslationTextComponent("talent.doggytalents.puppy_eyes.msg.2.line.2", new Object[]{dogIn.getGenderTitle()}));
                    owner.func_145747_a((ITextComponent)new TranslationTextComponent("talent.doggytalents.puppy_eyes.msg.2.line.3", new Object[]{dogIn.getGenderTitle()}));
                    villager.func_199702_a((IItemProvider)Items.field_151147_al, 5);
                } else if (rewardId == 2) {
                    owner.func_145747_a((ITextComponent)new TranslationTextComponent("talent.doggytalents.puppy_eyes.msg.3.line.1", new Object[0]));
                    owner.func_145747_a((ITextComponent)new TranslationTextComponent("talent.doggytalents.puppy_eyes.msg.3.line.2", new Object[0]));
                    owner.func_145747_a((ITextComponent)new TranslationTextComponent("talent.doggytalents.puppy_eyes.msg.3.line.3", new Object[0]));
                    villager.func_199702_a((IItemProvider)Items.field_151042_j, 3);
                } else if (rewardId == 3) {
                    owner.func_145747_a((ITextComponent)new TranslationTextComponent("talent.doggytalents.puppy_eyes.msg.4.line.1", new Object[0]));
                    owner.func_145747_a((ITextComponent)new TranslationTextComponent("talent.doggytalents.puppy_eyes.msg.4.line.2", new Object[0]));
                    owner.func_145747_a((ITextComponent)new TranslationTextComponent("talent.doggytalents.puppy_eyes.msg.4.line.3", new Object[0]));
                    villager.func_199702_a((IItemProvider)Items.field_151043_k, 2);
                } else if (rewardId == 4) {
                    owner.func_145747_a((ITextComponent)new TranslationTextComponent("talent.doggytalents.puppy_eyes.msg.5.line.1", new Object[0]));
                    owner.func_145747_a((ITextComponent)new TranslationTextComponent("talent.doggytalents.puppy_eyes.msg.5.line.2", new Object[0]));
                    owner.func_145747_a((ITextComponent)new TranslationTextComponent("talent.doggytalents.puppy_eyes.msg.5.line.3", new Object[0]));
                    villager.func_199702_a((IItemProvider)Items.field_151045_i, 1);
                } else if (rewardId == 5) {
                    owner.func_145747_a((ITextComponent)new TranslationTextComponent("talent.doggytalents.puppy_eyes.msg.6.line.1", new Object[0]));
                    owner.func_145747_a((ITextComponent)new TranslationTextComponent("talent.doggytalents.puppy_eyes.msg.6.line.2", new Object[0]));
                    owner.func_145747_a((ITextComponent)new TranslationTextComponent("talent.doggytalents.puppy_eyes.msg.6.line.3", new Object[0]));
                    villager.func_199702_a((IItemProvider)Items.field_151034_e, 1);
                    villager.func_199702_a((IItemProvider)Blocks.field_150414_aQ, 1);
                    villager.func_199702_a((IItemProvider)Items.field_151123_aH, 3);
                    villager.func_199702_a((IItemProvider)Items.field_151147_al, 5);
                }
                dogIn.setData(COOLDOWN, dogIn.field_70173_aa + (level >= 5 ? 24000 : 48000));
            }
        }
    }

    public LivingEntity getClosestVisibleVillager(AbstractDogEntity dogIn, double radiusIn) {
        List list = dogIn.field_70170_p.func_175647_a(AbstractVillagerEntity.class, dogIn.func_174813_aQ().func_72314_b(radiusIn, radiusIn, radiusIn), village -> village.func_70685_l((Entity)dogIn));
        Collections.sort(list, new EntityUtil.Sorter((Entity)dogIn));
        if (list.isEmpty()) {
            return null;
        }
        return (LivingEntity)list.get(0);
    }
}

