/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.util;

import doggytalents.common.util.Util;

public class ColourCache {
    private final int color;
    private float[] floatArray;

    protected ColourCache(int color) {
        this.color = color;
    }

    public int get() {
        return this.color;
    }

    public float[] getFloatArray() {
        if (this.floatArray == null) {
            this.floatArray = Util.rgbIntToFloatArray(this.color);
        }
        return this.floatArray;
    }

    public static ColourCache make(int color) {
        return new ColourCache(color);
    }

    public int hashCode() {
        return this.color;
    }

    public boolean equals(Object obj) {
        if (obj.getClass() != ColourCache.class) {
            return false;
        }
        if (!(obj instanceof ColourCache)) {
            return false;
        }
        ColourCache other = (ColourCache)obj;
        return other.color == this.color;
    }

    public boolean is(int colorIn) {
        return this.color == colorIn;
    }
}

