/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.entity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import doggytalents.api.DoggyTalentsAPI;
import doggytalents.entity.EntityDog;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public abstract class EntityAbstractDog
extends EntityTameable {
    private float headRotationCourse;
    private float headRotationCourseOld;
    private boolean isWet;
    public boolean isShaking;
    private float timeWolfIsShaking;
    private float prevTimeWolfIsShaking;

    public EntityAbstractDog(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.6f, 0.85f);
    }

    protected void func_70629_bd() {
        super.func_70629_bd();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(25, (Object)new Integer(0));
    }

    public boolean func_70650_aV() {
        return true;
    }

    protected void func_145780_a(int x, int y, int z, Block block) {
        this.func_85030_a("mob.wolf.step", 0.15f, 1.0f);
    }

    protected String func_70639_aQ() {
        return this.field_70146_Z.nextInt(3) == 0 ? (this.func_70909_n() && this.func_110143_aJ() < this.func_110138_aP() / 2.0f ? "mob.wolf.whine" : "mob.wolf.panting") : "mob.wolf.bark";
    }

    protected String func_70621_aR() {
        return "mob.wolf.hurt";
    }

    protected String func_70673_aS() {
        return "mob.wolf.death";
    }

    public float func_70599_aP() {
        return 0.4f;
    }

    protected Item func_146068_u() {
        return Item.func_150899_d((int)-1);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && this.isWet && !this.isShaking && !this.func_70781_l() && this.field_70122_E) {
            this.isShaking = true;
            this.timeWolfIsShaking = 0.0f;
            this.prevTimeWolfIsShaking = 0.0f;
            this.field_70170_p.func_72960_a((Entity)this, (byte)8);
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.headRotationCourseOld = this.headRotationCourse;
        this.headRotationCourse = this.isBegging() ? (this.headRotationCourse += (1.0f - this.headRotationCourse) * 0.4f) : (this.headRotationCourse += (0.0f - this.headRotationCourse) * 0.4f);
        if (this.func_70026_G()) {
            this.isWet = true;
            this.isShaking = false;
            this.timeWolfIsShaking = 0.0f;
            this.prevTimeWolfIsShaking = 0.0f;
        } else if ((this.isWet || this.isShaking) && this.isShaking) {
            if (this.timeWolfIsShaking == 0.0f) {
                this.func_85030_a("mob.wolf.shake", this.func_70599_aP(), (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            }
            this.prevTimeWolfIsShaking = this.timeWolfIsShaking;
            this.timeWolfIsShaking += 0.05f;
            if (this.prevTimeWolfIsShaking >= 2.0f) {
                this.isWet = false;
                this.isShaking = false;
                this.prevTimeWolfIsShaking = 0.0f;
                this.timeWolfIsShaking = 0.0f;
                this.onFinishShaking();
            }
            if (this.timeWolfIsShaking > 0.4f) {
                float f = (float)this.field_70121_D.field_72338_b;
                int i = (int)(MathHelper.func_76126_a((float)((this.timeWolfIsShaking - 0.4f) * (float)Math.PI)) * 7.0f);
                for (int j = 0; j < i; ++j) {
                    float f1 = (this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * this.field_70130_N * 0.5f;
                    float f2 = (this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * this.field_70130_N * 0.5f;
                    this.field_70170_p.func_72869_a("splash", this.field_70165_t + (double)f1, (double)(f + 0.8f), this.field_70161_v + (double)f2, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isDogWet() {
        return this.isWet;
    }

    @SideOnly(value=Side.CLIENT)
    public float getShadingWhileWet(float partialTickTime) {
        return 0.75f + (this.prevTimeWolfIsShaking + (this.timeWolfIsShaking - this.prevTimeWolfIsShaking) * partialTickTime) / 2.0f * 0.25f;
    }

    @SideOnly(value=Side.CLIENT)
    public float getShakeAngle(float partialTickTime, float p_70923_2_) {
        float f = (this.prevTimeWolfIsShaking + (this.timeWolfIsShaking - this.prevTimeWolfIsShaking) * partialTickTime + p_70923_2_) / 1.8f;
        f = MathHelper.func_76131_a((float)f, (float)0.0f, (float)1.0f);
        return MathHelper.func_76126_a((float)(f * (float)Math.PI)) * MathHelper.func_76126_a((float)(f * (float)Math.PI * 11.0f)) * 0.15f * (float)Math.PI;
    }

    @SideOnly(value=Side.CLIENT)
    public float getInterestedAngle(float partialTickTime) {
        return (this.headRotationCourseOld + (this.headRotationCourse - this.headRotationCourseOld) * partialTickTime) * 0.15f * (float)Math.PI;
    }

    @SideOnly(value=Side.CLIENT)
    public float getTailRotation() {
        return this.func_70909_n() ? (0.55f - (this.func_110138_aP() - this.func_110143_aJ()) / (this.func_110138_aP() / 20.0f) * 0.02f) * (float)Math.PI : 0.62831855f;
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.8f;
    }

    public int func_70646_bf() {
        return this.func_70906_o() ? 20 : super.func_70646_bf();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 8) {
            this.isShaking = true;
            this.timeWolfIsShaking = 0.0f;
            this.prevTimeWolfIsShaking = 0.0f;
        } else {
            super.func_70103_a(id);
        }
    }

    public double func_70033_W() {
        return this.field_70154_o instanceof EntityPlayer ? -1.0 : 0.0;
    }

    public boolean isBegging() {
        return this.getCustomData(5);
    }

    public void setBegging(boolean beg) {
        this.setCustomData(5, beg);
    }

    public void setCustomData(int BIT, boolean flag) {
        int in = this.field_70180_af.func_75679_c(25);
        in = flag ? (in |= 1 << BIT) : (in &= ~(1 << BIT));
        this.field_70180_af.func_75692_b(25, (Object)in);
    }

    public boolean getCustomData(int BIT) {
        return (this.field_70180_af.func_75679_c(25) & 1 << BIT) == 1 << BIT;
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack != null && DoggyTalentsAPI.BREED_WHITELIST.containsItem(stack);
    }

    public boolean func_70878_b(EntityAnimal otherAnimal) {
        if (otherAnimal == this) {
            return false;
        }
        if (!this.func_70909_n()) {
            return false;
        }
        if (!(otherAnimal instanceof EntityAbstractDog)) {
            return false;
        }
        EntityAbstractDog entitydog = (EntityAbstractDog)otherAnimal;
        return !entitydog.func_70909_n() ? false : (entitydog.func_70906_o() ? false : this.func_70880_s() && entitydog.func_70880_s());
    }

    public boolean canRiderInteract() {
        return true;
    }

    public boolean func_82171_bF() {
        return this.field_70153_n instanceof EntityPlayer;
    }

    public boolean func_142018_a(EntityLivingBase target, EntityLivingBase owner) {
        if (!(target instanceof EntityCreeper) && !(target instanceof EntityGhast)) {
            EntityWolf entitywolf;
            EntityDog entitydog;
            if (target instanceof EntityDog ? (entitydog = (EntityDog)target).func_70909_n() && entitydog.func_70902_q() == owner : target instanceof EntityWolf && (entitywolf = (EntityWolf)target).func_70909_n() && entitywolf.func_70902_q() == owner) {
                return false;
            }
            if (target instanceof EntityPlayer && owner instanceof EntityPlayer && !((EntityPlayer)owner).func_96122_a((EntityPlayer)target)) {
                return false;
            }
            if (target == owner) {
                return false;
            }
            return !(target instanceof EntityHorse) || !((EntityHorse)target).func_110248_bS();
        }
        return false;
    }

    private void onFinishShaking() {
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
    }
}

