/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.entity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import doggytalents.DoggyTalents;
import doggytalents.ModBlocks;
import doggytalents.ModItems;
import doggytalents.api.IDogTreat;
import doggytalents.entity.CoordUtil;
import doggytalents.entity.EntityAbstractDog;
import doggytalents.entity.LevelUtil;
import doggytalents.entity.ModeUtil;
import doggytalents.entity.TalentHelper;
import doggytalents.entity.TalentUtil;
import doggytalents.entity.ai.EntityAIDogBeg;
import doggytalents.entity.ai.EntityAIDogWander;
import doggytalents.entity.ai.EntityAIFetch;
import doggytalents.entity.ai.EntityAIFollowOwner;
import doggytalents.entity.ai.EntityAIModeAttackTarget;
import doggytalents.entity.ai.EntityAIOwnerHurtByTarget;
import doggytalents.entity.ai.EntityAIOwnerHurtTarget;
import doggytalents.entity.ai.EntityAIShepherdDog;
import doggytalents.helper.DogUtil;
import doggytalents.inventory.InventoryTreatBag;
import doggytalents.lib.Constants;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.BlockColored;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAISit;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITargetNonTamed;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EntityDog
extends EntityAbstractDog {
    private float timeWolfIsHappy;
    private float prevTimeWolfIsHappy;
    private boolean isWolfHappy;
    public boolean hiyaMaster;
    private int reversionTime;
    private boolean hasBone;
    public EntityAIFetch aiFetchBone;
    public TalentUtil talents;
    public LevelUtil levels;
    public ModeUtil mode;
    public CoordUtil coords;
    public Map<String, Object> objects = new HashMap<String, Object>();
    private int hungerTick;
    private int prevHungerTick;
    private int healingTick;
    private int prevHealingTick;
    private int regenerationTick;
    private int prevRegenerationTick;
    private int foodBowlCheck;

    public EntityDog(World word) {
        super(word);
        this.field_70911_d = new EntityAISit((EntityTameable)this);
        this.aiFetchBone = new EntityAIFetch(this, 1.0, 20.0f);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.field_70911_d);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.4f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIFollowOwner(this, 1.0, 10.0f, 2.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)this.aiFetchBone);
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIDogWander(this, 1.0));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIDogBeg(this, 8.0f));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIOwnerHurtByTarget(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIOwnerHurtTarget(this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIModeAttackTarget(this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAITargetNonTamed((EntityTameable)this, EntitySheep.class, 200, false));
        this.field_70715_bh.func_75776_a(6, (EntityAIBase)new EntityAIShepherdDog(this, EntityAnimal.class, 0, false));
        this.func_70903_f(false);
        TalentHelper.onClassCreation(this);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.3f);
        this.updateEntityAttributes();
    }

    public void updateEntityAttributes() {
        if (this.func_70909_n()) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(8.0);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_94059_bO() {
        return this.func_94056_bM();
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.talents = new TalentUtil(this);
        this.levels = new LevelUtil(this);
        this.mode = new ModeUtil(this);
        this.coords = new CoordUtil(this);
        this.field_70180_af.func_75682_a(19, (Object)new Integer(-2));
        this.field_70180_af.func_75682_a(20, (Object)new Integer(-2));
        this.field_70180_af.func_75682_a(21, (Object)new String(""));
        this.field_70180_af.func_75682_a(22, (Object)new String(""));
        this.field_70180_af.func_75682_a(23, (Object)new Integer(60));
        this.field_70180_af.func_75682_a(24, (Object)new String("0:0"));
        this.field_70180_af.func_75682_a(26, (Object)0);
        this.field_70180_af.func_75682_a(27, (Object)new Integer(0));
        this.field_70180_af.func_75682_a(28, (Object)"-1:-1:-1:-1:-1:-1");
        this.field_70180_af.func_75682_a(29, (Object)3);
        this.field_70180_af.func_75682_a(30, (Object)-1);
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74778_a("version", "1.14.2.317");
        tagCompound.func_74768_a("doggyTex", this.getTameSkin());
        tagCompound.func_74768_a("collarColour", this.getCollarData());
        tagCompound.func_74768_a("dogHunger", this.getDogHunger());
        tagCompound.func_74757_a("willObey", this.willObeyOthers());
        tagCompound.func_74757_a("friendlyFire", this.canFriendlyFire());
        tagCompound.func_74757_a("radioCollar", this.hasRadarCollar());
        tagCompound.func_74757_a("sunglasses", this.hasSunglasses());
        tagCompound.func_74768_a("capeData", this.getCapeData());
        tagCompound.func_74768_a("dogSize", this.getDogSize());
        this.talents.writeTalentsToNBT(tagCompound);
        this.levels.writeTalentsToNBT(tagCompound);
        this.mode.writeToNBT(tagCompound);
        this.coords.writeToNBT(tagCompound);
        TalentHelper.writeToNBT(this, tagCompound);
    }

    public void func_70037_a(NBTTagCompound tagCompound) {
        super.func_70037_a(tagCompound);
        String lastVersion = tagCompound.func_74779_i("version");
        this.setTameSkin(tagCompound.func_74762_e("doggyTex"));
        if (tagCompound.func_150297_b("collarColour", 99)) {
            this.setCollarData(tagCompound.func_74762_e("collarColour"));
        }
        this.setDogHunger(tagCompound.func_74762_e("dogHunger"));
        this.setWillObeyOthers(tagCompound.func_74767_n("willObey"));
        this.setFriendlyFire(tagCompound.func_74767_n("friendlyFire"));
        this.hasRadarCollar(tagCompound.func_74767_n("radioCollar"));
        this.setHasSunglasses(tagCompound.func_74767_n("sunglasses"));
        if (tagCompound.func_150297_b("capeData", 99)) {
            this.setCapeData(tagCompound.func_74762_e("capeData"));
        }
        if (tagCompound.func_150297_b("dogSize", 99)) {
            this.setDogSize(tagCompound.func_74762_e("dogSize"));
        }
        this.talents.readTalentsFromNBT(tagCompound);
        this.levels.readTalentsFromNBT(tagCompound);
        this.mode.readFromNBT(tagCompound);
        this.coords.readFromNBT(tagCompound);
        TalentHelper.readFromNBT(this, tagCompound);
        if (tagCompound.func_74764_b("dogName")) {
            this.func_94058_c(tagCompound.func_74779_i("dogName"));
        }
    }

    @Override
    protected String func_70639_aQ() {
        String sound = TalentHelper.getLivingSound(this);
        return sound != null ? sound : super.func_70639_aQ();
    }

    public EntityAISit getSitAI() {
        return this.field_70911_d;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (Constants.IS_HUNGER_ON) {
            this.prevHungerTick = this.hungerTick++;
            if (this.field_70153_n != null || !this.func_70906_o()) {
                // empty if block
            }
            this.hungerTick += TalentHelper.onHungerTick(this, this.hungerTick - this.prevHungerTick);
            if (this.hungerTick > 400) {
                this.setDogHunger(this.getDogHunger() - 1);
                this.hungerTick -= 400;
            }
        }
        if (Constants.DOGS_IMMORTAL) {
            this.prevRegenerationTick = this.regenerationTick++;
            if (this.func_70906_o()) {
                this.regenerationTick += TalentHelper.onRegenerationTick(this, this.regenerationTick - this.prevRegenerationTick);
            } else if (!this.func_70906_o()) {
                this.regenerationTick = 0;
            }
            if (this.regenerationTick >= 2400 && this.isIncapacicated()) {
                this.func_70606_j(2.0f);
                this.setDogHunger(1);
            } else if (this.regenerationTick >= 2400 && !this.isIncapacicated() && this.regenerationTick >= 4400 && this.getDogHunger() < 60) {
                this.setDogHunger(this.getDogHunger() + 1);
                this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                this.regenerationTick = 2400;
            }
        }
        if (this.func_110143_aJ() != 1.0f) {
            this.prevHealingTick = this.healingTick;
            this.healingTick += this.nourishment();
            if (this.healingTick >= 6000) {
                if (this.func_110143_aJ() < this.func_110138_aP()) {
                    this.func_70606_j(this.func_110143_aJ() + 1.0f);
                }
                this.healingTick = 0;
            }
        }
        if (this.func_110143_aJ() <= 0.0f && this.isImmortal()) {
            this.field_70725_aQ = 0;
            this.func_70606_j(1.0f);
        }
        if (this.getDogHunger() <= 0 && this.field_70170_p.func_72912_H().func_76073_f() % 100L == 0L && this.func_110143_aJ() > 1.0f) {
            this.func_70097_a(DamageSource.field_76377_j, 1.0f);
        }
        if (this.levels.isDireDog() && Constants.DIRE_PARTICLES) {
            for (int i = 0; i < 2; ++i) {
                this.field_70170_p.func_72869_a("portal", this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O - 0.25, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, (this.field_70146_Z.nextDouble() - 0.5) * 2.0, -this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0);
            }
        }
        if (this.reversionTime > 0) {
            --this.reversionTime;
        }
        if (this.field_70154_o instanceof EntityPlayer && this.field_70154_o.func_70093_af()) {
            this.field_70154_o.field_70153_n = null;
            this.field_70154_o = null;
        }
        if (this.coords.hasBowlPos() && this.foodBowlCheck++ > 50) {
            if (this.field_70170_p.func_72899_e(this.coords.getBowlX(), this.coords.getBowlY(), this.coords.getBowlZ()) && this.field_70170_p.func_147439_a(this.coords.getBowlX(), this.coords.getBowlY(), this.coords.getBowlZ()) != ModBlocks.FOOD_BOWL) {
                this.coords.resetBowlPosition();
            }
            this.foodBowlCheck = 0;
        }
        this.updateBoundingBox();
        TalentHelper.onLivingUpdate(this);
    }

    @Override
    public void func_70071_h_() {
        float distanceToOwner;
        EntityPlayer player;
        super.func_70071_h_();
        if (this.field_70146_Z.nextInt(200) == 0) {
            this.hiyaMaster = true;
        }
        if ((this.isBegging() || this.hiyaMaster) && !this.isWolfHappy) {
            this.isWolfHappy = true;
            this.timeWolfIsHappy = 0.0f;
            this.prevTimeWolfIsHappy = 0.0f;
        } else {
            this.hiyaMaster = false;
        }
        if (this.isWolfHappy) {
            if (this.timeWolfIsHappy % 1.0f == 0.0f) {
                this.field_70170_p.func_72956_a((Entity)this, "mob.wolf.panting", this.func_70599_aP(), (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            }
            this.prevTimeWolfIsHappy = this.timeWolfIsHappy;
            this.timeWolfIsHappy += 0.05f;
            if (this.prevTimeWolfIsHappy >= 8.0f) {
                this.isWolfHappy = false;
                this.prevTimeWolfIsHappy = 0.0f;
                this.timeWolfIsHappy = 0.0f;
            }
        }
        if (this.func_70909_n() && (player = (EntityPlayer)this.func_70902_q()) != null && (distanceToOwner = player.func_70032_d((Entity)this)) <= 2.0f && this.hasBone()) {
            if (!this.field_70170_p.field_72995_K) {
                ItemStack fetchItem = new ItemStack((Item)null);
                switch (this.getBoneVariant()) {
                    case 0: {
                        fetchItem = new ItemStack(ModItems.THROW_BONE, 1, 1);
                        break;
                    }
                    case 1: {
                        fetchItem = new ItemStack(ModItems.THROW_BONE, 1, 3);
                    }
                }
                this.func_70099_a(fetchItem, 0.0f);
            }
            this.setNoFetchItem();
        }
        TalentHelper.onUpdate(this);
    }

    public boolean isControllingPassengerPlayer() {
        return this.field_70153_n instanceof EntityPlayer;
    }

    public void func_70612_e(float strafe, float forward) {
        if (this.isControllingPassengerPlayer()) {
            EntityLivingBase entitylivingbase = (EntityLivingBase)this.field_70153_n;
            this.field_70126_B = this.field_70177_z = entitylivingbase.field_70177_z;
            this.field_70125_A = entitylivingbase.field_70125_A * 0.5f;
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            this.field_70759_as = this.field_70761_aq = this.field_70177_z;
            strafe = entitylivingbase.field_70702_br * 0.75f;
            forward = entitylivingbase.field_70701_bs;
            if (forward <= 0.0f) {
                forward *= 0.5f;
            }
            if (this.field_70122_E && forward > 0.0f) {
                float f2 = MathHelper.func_76126_a((float)(this.field_70177_z * (float)Math.PI / 180.0f));
                float f3 = MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f));
                this.field_70159_w += (double)(-0.4f * f2 * 0.05f);
                this.field_70179_y += (double)(0.4f * f3 * 0.05f);
            }
            this.field_70138_W = 1.0f;
            this.field_70747_aH = this.func_70689_ay() * 0.3f;
            if (entitylivingbase instanceof EntityPlayer) {
                float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e() * 0.5f;
                this.func_70659_e(f);
                super.func_70612_e(strafe, forward);
            } else if (entitylivingbase instanceof EntityPlayer) {
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
                this.field_70179_y = 0.0;
            }
            this.field_70722_aY = this.field_70721_aZ;
            double d0 = this.field_70165_t - this.field_70169_q;
            double d1 = this.field_70161_v - this.field_70166_s;
            float f4 = MathHelper.func_76129_c((float)((float)(d0 * d0 + d1 * d1))) * 4.0f;
            if (f4 > 1.0f) {
                f4 = 1.0f;
            }
            this.field_70721_aZ += (f4 - this.field_70721_aZ) * 0.4f;
            this.field_70754_ba += this.field_70721_aZ;
        } else {
            this.field_70138_W = 0.5f;
            this.field_70747_aH = 0.02f;
            super.func_70612_e(strafe, forward);
        }
    }

    public boolean isImmortal() {
        return this.func_70909_n() && Constants.DOGS_IMMORTAL || this.levels.isDireDog();
    }

    public void func_70069_a(float distance) {
        if (!TalentHelper.isImmuneToFalls(this)) {
            super.func_70069_a(distance - (float)TalentHelper.fallProtection(this) - (float)(this.field_70153_n instanceof EntityPlayer ? 1 : 0));
        }
    }

    public boolean func_70097_a(DamageSource damageSource, float damage) {
        if (this.func_85032_ar()) {
            return false;
        }
        Entity entity = damageSource.func_76346_g();
        if (!this.canFriendlyFire() && entity instanceof EntityPlayer && (this.willObeyOthers() || this.func_152114_e((EntityLivingBase)((EntityPlayer)entity)))) {
            return false;
        }
        if (!TalentHelper.attackEntityFrom(this, damageSource, damage)) {
            return false;
        }
        if (this.field_70911_d != null) {
            this.field_70911_d.func_75270_a(false);
        }
        if (entity != null && !(entity instanceof EntityPlayer) && !(entity instanceof EntityArrow)) {
            damage = (damage + 1.0f) / 2.0f;
        }
        return super.func_70097_a(damageSource, damage);
    }

    public boolean func_70652_k(Entity entity) {
        if (!TalentHelper.shouldDamageMob(this, entity)) {
            return false;
        }
        int damage = 4 + (MathHelper.func_76128_c((double)this.effectiveLevel()) + 1) / 2;
        damage = TalentHelper.attackEntityAsMob(this, entity, damage);
        if (entity instanceof EntityZombie) {
            ((EntityZombie)entity).func_70624_b((EntityLivingBase)this);
        }
        return entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)damage);
    }

    public void func_70903_f(boolean p_70903_1_) {
        super.func_70903_f(p_70903_1_);
        if (p_70903_1_) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(8.0);
        }
    }

    public boolean func_70085_c(EntityPlayer player) {
        ItemStack stack = player.func_70694_bm();
        if (TalentHelper.interactWithPlayer(this, player)) {
            return true;
        }
        if (this.func_70909_n()) {
            if (stack != null) {
                int foodValue = this.foodValue(stack);
                if (foodValue != 0 && this.getDogHunger() < 120 && this.canInteract(player) && !this.isIncapacicated()) {
                    if (!player.field_71075_bZ.field_75098_d) {
                        --stack.field_77994_a;
                    }
                    this.setDogHunger(this.getDogHunger() + foodValue);
                    if (stack.func_77973_b() == ModItems.CHEW_STICK) {
                        this.func_70690_d(new PotionEffect(Potion.field_76424_c.func_76396_c(), 200, 6, false));
                        this.func_70690_d(new PotionEffect(Potion.field_76428_l.func_76396_c(), 100, 2, false));
                    }
                    return true;
                }
                if (stack.func_77973_b() == Items.field_151103_aS && this.canInteract(player)) {
                    if (!this.field_70170_p.field_72995_K) {
                        if (this.field_70154_o != null) {
                            this.func_70078_a(null);
                        } else {
                            this.func_70078_a((Entity)player);
                        }
                    }
                    if (this.field_70911_d != null) {
                        this.field_70911_d.func_75270_a(true);
                    }
                    return true;
                }
                if (stack.func_77973_b() == Items.field_151055_y && this.canInteract(player) && !this.isIncapacicated()) {
                    player.openGui((Object)DoggyTalents.INSTANCE, 1, this.field_70170_p, this.func_145782_y(), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v));
                    return true;
                }
                if (stack.func_77973_b() == ModItems.RADIO_COLLAR && this.canInteract(player) && !this.hasRadarCollar() && !this.isIncapacicated()) {
                    this.hasRadarCollar(true);
                    if (!player.field_71075_bZ.field_75098_d) {
                        --stack.field_77994_a;
                    }
                    return true;
                }
                if (stack.func_77973_b() == ModItems.WOOL_COLLAR && this.canInteract(player) && !this.hasCollar() && !this.isIncapacicated()) {
                    int colour = -1;
                    if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("collar_colour")) {
                        colour = stack.func_77978_p().func_74762_e("collar_colour");
                    }
                    this.setCollarData(colour);
                    if (!player.field_71075_bZ.field_75098_d) {
                        --stack.field_77994_a;
                    }
                    return true;
                }
                if (stack.func_77973_b() == ModItems.FANCY_COLLAR && this.canInteract(player) && !this.hasCollar() && !this.isIncapacicated()) {
                    this.setCollarData(-3 - stack.func_77960_j());
                    if (!player.field_71075_bZ.field_75098_d) {
                        --stack.field_77994_a;
                    }
                    return true;
                }
                if (stack.func_77973_b() == ModItems.CAPE && this.canInteract(player) && !this.hasCape() && !this.isIncapacicated()) {
                    this.setFancyCape();
                    if (!player.field_71075_bZ.field_75098_d) {
                        --stack.field_77994_a;
                    }
                    return true;
                }
                if (stack.func_77973_b() == ModItems.CAPE_COLOURED && this.canInteract(player) && !this.hasCape() && !this.isIncapacicated()) {
                    int colour = -1;
                    if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("cape_colour")) {
                        colour = stack.func_77978_p().func_74762_e("cape_colour");
                    }
                    this.setCapeData(colour);
                    if (!player.field_71075_bZ.field_75098_d) {
                        --stack.field_77994_a;
                    }
                    return true;
                }
                if (stack.func_77973_b() == ModItems.SUNGLASSES && this.canInteract(player) && !this.hasSunglasses() && !this.isIncapacicated()) {
                    this.setHasSunglasses(true);
                    if (!player.field_71075_bZ.field_75098_d) {
                        --stack.field_77994_a;
                    }
                    return true;
                }
                if (stack.func_77973_b() == ModItems.LEATHER_JACKET && this.canInteract(player) && !this.hasCape() && !this.isIncapacicated()) {
                    this.setLeatherJacket();
                    if (!player.field_71075_bZ.field_75098_d) {
                        --stack.field_77994_a;
                    }
                    return true;
                }
                if (stack.func_77973_b() instanceof IDogTreat && this.canInteract(player) && !this.isIncapacicated()) {
                    IDogTreat treat = (IDogTreat)stack.func_77973_b();
                    IDogTreat.EnumFeedBack type = treat.canGiveToDog(player, this, this.levels.getLevel(), this.levels.getDireLevel());
                    treat.giveTreat(type, player, stack, this);
                    return true;
                }
                if (stack.func_77973_b() == ModItems.COLLAR_SHEARS && this.canInteract(player)) {
                    if (!this.field_70170_p.field_72995_K) {
                        if (this.hasCollar() || this.hasSunglasses() || this.hasCape()) {
                            this.reversionTime = 40;
                            if (this.hasCollarColoured()) {
                                ItemStack collarDrop = new ItemStack(ModItems.WOOL_COLLAR, 1, 0);
                                if (this.isCollarColoured()) {
                                    collarDrop.func_77982_d(new NBTTagCompound());
                                    collarDrop.func_77978_p().func_74768_a("collar_colour", this.getCollarData());
                                }
                                this.func_70099_a(collarDrop, 1.0f);
                                this.setNoCollar();
                            }
                            if (this.hasFancyCollar()) {
                                this.func_70099_a(new ItemStack(ModItems.FANCY_COLLAR, 1, this.getFancyCollarIndex()), 1.0f);
                                this.setNoCollar();
                            }
                            if (this.hasFancyCape()) {
                                this.func_70099_a(new ItemStack(ModItems.CAPE, 1, 0), 1.0f);
                                this.setNoCape();
                            }
                            if (this.hasCapeColoured()) {
                                ItemStack capeDrop = new ItemStack(ModItems.CAPE_COLOURED, 1, 0);
                                if (this.isCapeColoured()) {
                                    capeDrop.func_77982_d(new NBTTagCompound());
                                    capeDrop.func_77978_p().func_74768_a("cape_colour", this.getCapeData());
                                }
                                this.func_70099_a(capeDrop, 1.0f);
                                this.setNoCape();
                            }
                            if (this.hasLeatherJacket()) {
                                this.func_70099_a(new ItemStack(ModItems.LEATHER_JACKET, 1, 0), 1.0f);
                                this.setNoCape();
                            }
                            if (this.hasSunglasses()) {
                                this.func_70099_a(new ItemStack(ModItems.SUNGLASSES, 1, 0), 1.0f);
                                this.setHasSunglasses(false);
                            }
                        } else if (this.reversionTime < 1) {
                            this.func_70903_f(false);
                            this.func_70661_as().func_75499_g();
                            this.func_70904_g(false);
                            this.func_70606_j(8.0f);
                            this.talents.resetTalents();
                            this.func_152115_b(UUID.randomUUID().toString());
                            this.setWillObeyOthers(false);
                            this.mode.setMode(ModeUtil.EnumMode.DOCILE);
                            if (this.hasRadarCollar()) {
                                this.func_145779_a(ModItems.RADIO_COLLAR, 1);
                            }
                            this.hasRadarCollar(false);
                            this.reversionTime = 40;
                        }
                    }
                    return true;
                }
                if (stack.func_77973_b() == Items.field_151105_aU && this.canInteract(player) && this.isIncapacicated()) {
                    if (!player.field_71075_bZ.field_75098_d) {
                        --stack.field_77994_a;
                    }
                    if (!this.field_70170_p.field_72995_K) {
                        this.field_70911_d.func_75270_a(true);
                        this.func_70606_j(this.func_110138_aP());
                        this.setDogHunger(120);
                        this.regenerationTick = 0;
                        this.func_70624_b(null);
                        this.func_70908_e(true);
                        this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                    }
                    return true;
                }
                if (stack.func_77973_b() == Items.field_151100_aR && this.canInteract(player)) {
                    if (!this.hasCollarColoured()) {
                        return true;
                    }
                    if (this.isCollarColoured()) {
                        float[] rgb = EntitySheep.field_70898_d[BlockColored.func_150032_b((int)stack.func_77960_j())];
                        int i1 = (int)(rgb[0] * 255.0f);
                        int j1 = (int)(rgb[1] * 255.0f);
                        int k1 = (int)(rgb[2] * 255.0f);
                        this.setCollarData(((i1 << 8) + j1 << 8) + k1);
                    } else {
                        int[] aint = new int[3];
                        int i = 0;
                        int count = 2;
                        int l = this.getCollarData();
                        float f = (float)(l >> 16 & 0xFF) / 255.0f;
                        float f1 = (float)(l >> 8 & 0xFF) / 255.0f;
                        float f2 = (float)(l & 0xFF) / 255.0f;
                        i = (int)((float)i + Math.max(f, Math.max(f1, f2)) * 255.0f);
                        aint[0] = (int)((float)aint[0] + f * 255.0f);
                        aint[1] = (int)((float)aint[1] + f1 * 255.0f);
                        aint[2] = (int)((float)aint[2] + f2 * 255.0f);
                        float[] afloat = EntitySheep.field_70898_d[BlockColored.func_150032_b((int)stack.func_77960_j())];
                        int l1 = (int)(afloat[0] * 255.0f);
                        int i2 = (int)(afloat[1] * 255.0f);
                        int j2 = (int)(afloat[2] * 255.0f);
                        i += Math.max(l1, Math.max(i2, j2));
                        aint[0] = aint[0] + l1;
                        aint[1] = aint[1] + i2;
                        aint[2] = aint[2] + j2;
                        int i1 = aint[0] / count;
                        int j1 = aint[1] / count;
                        int k1 = aint[2] / count;
                        float f3 = (float)i / (float)count;
                        float f4 = Math.max(i1, Math.max(j1, k1));
                        i1 = (int)((float)i1 * f3 / f4);
                        j1 = (int)((float)j1 * f3 / f4);
                        k1 = (int)((float)k1 * f3 / f4);
                        int k2 = (i1 << 8) + j1;
                        k2 = (k2 << 8) + k1;
                        this.setCollarData(k2);
                    }
                    return true;
                }
                if (stack.func_77973_b() == ModItems.TREAT_BAG && this.getDogHunger() < 120 && this.canInteract(player)) {
                    InventoryTreatBag treatBag = new InventoryTreatBag(player, player.field_71071_by.field_70461_c, stack);
                    treatBag.func_70295_k_();
                    int slotIndex = DogUtil.getFirstSlotWithFood(this, (IInventory)treatBag);
                    if (slotIndex >= 0) {
                        DogUtil.feedDog(this, (IInventory)treatBag, slotIndex);
                    }
                    treatBag.func_70305_f();
                    return true;
                }
            }
            if (!this.field_70170_p.field_72995_K && !this.func_70877_b(stack) && this.canInteract(player)) {
                this.field_70911_d.func_75270_a(!this.func_70906_o());
                this.field_70703_bu = false;
                this.func_70661_as().func_75499_g();
                this.func_70624_b(null);
                return true;
            }
        } else {
            if (stack != null && stack.func_77973_b() == ModItems.COLLAR_SHEARS && this.reversionTime < 1 && !this.field_70170_p.field_72995_K) {
                this.func_70106_y();
                EntityWolf wolf = new EntityWolf(this.field_70170_p);
                wolf.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
                this.field_70170_p.func_72838_d((Entity)wolf);
                return true;
            }
            if (stack != null && stack.func_77973_b() == Items.field_151103_aS) {
                if (!player.field_71075_bZ.field_75098_d) {
                    --stack.field_77994_a;
                }
                if (!this.field_70170_p.field_72995_K) {
                    if (this.field_70146_Z.nextInt(3) == 0) {
                        this.func_70903_f(true);
                        this.func_70661_as().func_75499_g();
                        this.func_70624_b(null);
                        this.field_70911_d.func_75270_a(true);
                        this.func_70606_j(20.0f);
                        this.func_152115_b(player.func_110124_au().toString());
                        this.func_70908_e(true);
                        this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                    } else {
                        this.func_70908_e(false);
                        this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                    }
                }
                return true;
            }
        }
        return false;
    }

    protected boolean func_70610_aX() {
        return this.func_70608_bn() || super.func_70610_aX();
    }

    public boolean func_70687_e(PotionEffect potionEffect) {
        if (this.isIncapacicated()) {
            return false;
        }
        return TalentHelper.isPostionApplicable(this, potionEffect);
    }

    public void func_70015_d(int amount) {
        if (TalentHelper.setFire(this, amount)) {
            super.func_70015_d(amount);
        }
    }

    public int foodValue(ItemStack stack) {
        if (stack == null) {
            return 0;
        }
        int foodValue = 0;
        Item item = stack.func_77973_b();
        if (stack.func_77973_b() != Items.field_151078_bh && item instanceof ItemFood) {
            ItemFood itemfood = (ItemFood)item;
            if (itemfood.func_77845_h()) {
                foodValue = 40;
            }
        } else if (stack.func_77973_b() == ModItems.CHEW_STICK) {
            return 10;
        }
        foodValue = TalentHelper.changeFoodValue(this, stack, foodValue);
        return foodValue;
    }

    public int masterOrder() {
        int order = 0;
        EntityPlayer player = (EntityPlayer)this.func_70902_q();
        if (player != null) {
            float distanceAway = player.func_70032_d((Entity)this);
            ItemStack itemstack = player.field_71071_by.func_70448_g();
            if (itemstack != null && itemstack.func_77973_b() instanceof ItemTool && distanceAway <= 20.0f) {
                order = 1;
            }
            if (itemstack != null && (itemstack.func_77973_b() instanceof ItemSword || itemstack.func_77973_b() instanceof ItemBow)) {
                order = 2;
            }
            if (itemstack != null && itemstack.func_77973_b() == Items.field_151015_O) {
                order = 3;
            }
        }
        return order;
    }

    public float getWagAngle(float partialTickTime, float offset) {
        float f = (this.prevTimeWolfIsHappy + (this.timeWolfIsHappy - this.prevTimeWolfIsHappy) * partialTickTime + offset) / 2.0f;
        if (f < 0.0f) {
            f = 0.0f;
        } else if (f > 2.0f) {
            f %= 2.0f;
        }
        return MathHelper.func_76126_a((float)(f * (float)Math.PI * 11.0f)) * 0.3f * (float)Math.PI;
    }

    public boolean func_70608_bn() {
        return false;
    }

    public boolean func_70648_aU() {
        return TalentHelper.canBreatheUnderwater(this);
    }

    protected boolean func_70041_e_() {
        return TalentHelper.canTriggerWalking(this);
    }

    public boolean canInteract(EntityPlayer player) {
        return this.func_152114_e((EntityLivingBase)player) || this.willObeyOthers();
    }

    public int nourishment() {
        int amount = 0;
        if (this.getDogHunger() > 0) {
            amount = 40 + 4 * (MathHelper.func_76128_c((double)this.effectiveLevel()) + 1);
            if (this.func_70906_o() && this.talents.getLevel("quickhealer") == 5) {
                amount += 20 + 2 * (MathHelper.func_76128_c((double)this.effectiveLevel()) + 1);
            }
            if (!this.func_70906_o()) {
                amount *= 5 + this.talents.getLevel("quickhealer");
                amount /= 10;
            }
        }
        return amount;
    }

    public void func_70908_e(boolean successful) {
        super.func_70908_e(successful);
    }

    public double effectiveLevel() {
        return (double)(this.levels.getLevel() + this.levels.getDireLevel()) / 10.0;
    }

    public int getTameSkin() {
        return this.field_70180_af.func_75679_c(26);
    }

    public void setTameSkin(int index) {
        this.field_70180_af.func_75692_b(26, (Object)index);
    }

    public void setWillObeyOthers(boolean flag) {
        this.setCustomData(4, flag);
    }

    public boolean willObeyOthers() {
        return this.getCustomData(4);
    }

    public void setFriendlyFire(boolean flag) {
        this.setCustomData(2, flag);
    }

    public boolean canFriendlyFire() {
        return this.getCustomData(2);
    }

    public int points() {
        return this.isCreativeCollar() ? 1000 : this.levels.getLevel() + this.levels.getDireLevel() + (this.levels.isDireDog() ? 15 : 0) + (this.func_70874_b() < 0 ? 0 : 15);
    }

    public int spendablePoints() {
        return this.points() - this.usedPoints();
    }

    public int usedPoints() {
        return TalentHelper.getUsedPoints(this);
    }

    public int deductive(int par1) {
        boolean byte0 = false;
        switch (par1) {
            case 1: {
                return 1;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 6;
            }
            case 4: {
                return 10;
            }
            case 5: {
                return 15;
            }
        }
        return 0;
    }

    public EntityDog createChild(EntityAgeable entityAgeable) {
        EntityDog entitydog = new EntityDog(this.field_70170_p);
        String uuid = this.func_152113_b();
        if (uuid != null && uuid.trim().length() > 0) {
            entitydog.func_152115_b(uuid);
            entitydog.func_70903_f(true);
        }
        entitydog.func_70873_a(-24000 * (Constants.TEN_DAY_PUPS ? 10 : 1));
        return entitydog;
    }

    public int getDogHunger() {
        return this.field_70180_af.func_75679_c(23);
    }

    public void setDogHunger(int par1) {
        this.field_70180_af.func_75692_b(23, (Object)MathHelper.func_76125_a((int)par1, (int)0, (int)120));
    }

    public void hasRadarCollar(boolean flag) {
        this.setCustomData(1, flag);
    }

    public boolean hasRadarCollar() {
        return this.getCustomData(1);
    }

    public void setHasSunglasses(boolean hasSunglasses) {
        this.setCustomData(3, hasSunglasses);
    }

    public boolean hasSunglasses() {
        return this.getCustomData(3);
    }

    public void setNoFetchItem() {
        this.field_70180_af.func_75692_b(30, (Object)-1);
    }

    public int getBoneVariant() {
        return this.field_70180_af.func_75679_c(30);
    }

    public void setBoneVariant(int value) {
        this.field_70180_af.func_75692_b(30, (Object)value);
    }

    public boolean hasBone() {
        return this.getBoneVariant() >= 0;
    }

    @Override
    public boolean func_142018_a(EntityLivingBase entityToAttack, EntityLivingBase owner) {
        if (TalentHelper.canAttackEntity(this, (Entity)entityToAttack)) {
            return true;
        }
        return super.func_142018_a(entityToAttack, owner);
    }

    public boolean func_70686_a(Class cls) {
        if (TalentHelper.canAttackClass(this, cls)) {
            return true;
        }
        return super.func_70686_a(cls);
    }

    public boolean isIncapacicated() {
        return Constants.DOGS_IMMORTAL && this.func_110143_aJ() <= 1.0f;
    }

    public boolean shouldDismountInWater(Entity rider) {
        if (!TalentHelper.shouldDismountInWater(this, rider)) {
            return false;
        }
        return super.shouldDismountInWater(rider);
    }

    public int getCollarData() {
        return this.field_70180_af.func_75679_c(20);
    }

    public void setCollarData(int rgb) {
        this.field_70180_af.func_75692_b(20, (Object)rgb);
    }

    public void setNoCollar() {
        this.setCollarData(-2);
    }

    public boolean hasCollar() {
        return this.getCollarData() != -2;
    }

    public boolean hasCollarColoured() {
        return this.getCollarData() >= -1;
    }

    public boolean isCollarColoured() {
        return this.getCollarData() > -1;
    }

    public void setHasCollar() {
        this.setCollarData(-1);
    }

    public boolean hasFancyCollar() {
        return this.getCollarData() < -2;
    }

    public int getFancyCollarIndex() {
        return -3 - this.getCollarData();
    }

    public boolean isCreativeCollar() {
        return this.getCollarData() == -3;
    }

    public float[] getCollar() {
        int argb = this.getCollarData();
        int r = argb >> 16 & 0xFF;
        int g = argb >> 8 & 0xFF;
        int b = argb >> 0 & 0xFF;
        return new float[]{(float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f};
    }

    public int getCapeData() {
        return this.field_70180_af.func_75679_c(19);
    }

    public void setCapeData(int rgb) {
        this.field_70180_af.func_75692_b(19, (Object)rgb);
    }

    public boolean hasCape() {
        return this.getCapeData() != -2;
    }

    public boolean hasCapeColoured() {
        return this.getCapeData() >= -1;
    }

    public boolean hasFancyCape() {
        return this.getCapeData() == -3;
    }

    public boolean hasLeatherJacket() {
        return this.getCapeData() == -4;
    }

    public boolean isCapeColoured() {
        return this.getCapeData() > -1;
    }

    public void setFancyCape() {
        this.setCapeData(-3);
    }

    public void setLeatherJacket() {
        this.setCapeData(-4);
    }

    public void setCapeColoured() {
        this.setCapeData(-1);
    }

    public void setNoCape() {
        this.setCapeData(-2);
    }

    public float[] getCapeColour() {
        int argb = this.getCapeData();
        int r = argb >> 16 & 0xFF;
        int g = argb >> 8 & 0xFF;
        int b = argb >> 0 & 0xFF;
        return new float[]{(float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f};
    }

    public int getDogSize() {
        return this.field_70180_af.func_75679_c(29);
    }

    public void setDogSize(int value) {
        this.field_70180_af.func_75692_b(29, (Object)Math.min(5, Math.max(1, value)));
    }

    public void updateBoundingBox() {
        switch (this.getDogSize()) {
            case 1: {
                this.func_98055_j(0.5f);
                break;
            }
            case 2: {
                this.func_98055_j(0.7f);
                break;
            }
            case 3: {
                this.func_98055_j(1.0f);
                break;
            }
            case 4: {
                this.func_98055_j(1.3f);
                break;
            }
            case 5: {
                this.func_98055_j(1.6f);
            }
        }
    }

    private void onFinishShaking() {
        if (!this.field_70170_p.field_72995_K) {
            int lvlFisherDog = this.talents.getLevel("fisherdog");
            int lvlHellHound = this.talents.getLevel("hellhound");
            if (this.field_70146_Z.nextInt(15) < lvlFisherDog * 2) {
                this.func_145779_a(this.field_70146_Z.nextInt(15) < lvlHellHound * 2 ? Items.field_151101_aQ : Items.field_151115_aP, 1);
            }
        }
    }
}

