/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.entity;

import doggytalents.entity.EntityDog;
import net.minecraft.nbt.NBTTagCompound;

public class ModeUtil {
    public EntityDog dog;

    public ModeUtil(EntityDog dog) {
        this.dog = dog;
    }

    public EnumMode getMode() {
        return EnumMode.values()[this.getModeID()];
    }

    public EnumMode getMode(int index) {
        return EnumMode.values()[index];
    }

    public static int getId(EnumMode mode) {
        return mode.ordinal();
    }

    public boolean isMode(EnumMode mode) {
        return this.getMode() == mode;
    }

    public void setMode(EnumMode mode) {
        this.setMode(ModeUtil.getId(mode));
    }

    public void setMode(int mode) {
        this.dog.func_70096_w().func_75692_b(27, (Object)mode);
    }

    protected int getModeID() {
        return this.dog.func_70096_w().func_75679_c(27);
    }

    public void writeToNBT(NBTTagCompound tagCompound) {
        tagCompound.func_74768_a("mode", this.getModeID());
    }

    public void readFromNBT(NBTTagCompound tagCompound) {
        this.setMode(tagCompound.func_74762_e("mode"));
    }

    public static enum EnumMode {
        DOCILE("docile"),
        WANDERING("wandering", false),
        AGGRESIVE("aggressive"),
        BERSERKER("berserker"),
        TACTICAL("tactical");

        private String unlocalisedTip;
        private String unlocalisedName;
        private String unlocalisedInfo;
        public boolean followsOwner;

        private EnumMode(String name) {
            this(name, true);
        }

        private EnumMode(String name, boolean followsOwner) {
            this("doggui.modename." + name, "doggui.modetip." + name, "doggui.modeinfo." + name, followsOwner);
        }

        private EnumMode(String name, String tip, String info) {
            this(name, tip, info, true);
        }

        private EnumMode(String unlocalisedName, String tip, String info, boolean followsOwner) {
            this.unlocalisedName = unlocalisedName;
            this.unlocalisedTip = tip;
            this.unlocalisedInfo = info;
            this.followsOwner = followsOwner;
        }

        public String getTip() {
            return this.unlocalisedTip;
        }

        public String getUnlocalisedName() {
            return this.unlocalisedName;
        }

        public String getUnlocalisedInfo() {
            return this.unlocalisedInfo;
        }

        public boolean doesFollowOwner() {
            return this.followsOwner;
        }
    }
}

