/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.base.b;

import doggytalents.DoggyTalents;
import doggytalents.ModItems;
import doggytalents.api.registry.DogBedRegistry;
import doggytalents.base.b.ParticleCustomDigging;
import doggytalents.base.b.PropertyStringListed;
import doggytalents.block.BlockDogBath;
import doggytalents.block.BlockDogBed;
import doggytalents.block.BlockFoodBowl;
import doggytalents.entity.EntityDog;
import doggytalents.inventory.InventoryTreatBag;
import doggytalents.tileentity.TileEntityDogBed;
import doggytalents.tileentity.TileEntityFoodBowl;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockWrapper {
    public static final PropertyStringListed VERSION = PropertyStringListed.create("version");

    public static class BlockFoodBowlWrapper
    extends BlockFoodBowl {
        public BlockFoodBowlWrapper() {
            this.func_149676_a(0.0625f, 0.0f, 0.0625f, 0.9375f, 0.5f, 0.9375f);
            this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)VERSION, (Comparable)((Object)"1.8")));
        }

        protected BlockState func_180661_e() {
            return new BlockState((Block)this, new IProperty[]{VERSION});
        }

        public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
            return state.func_177226_a((IProperty)VERSION, (Comparable)((Object)"1.8"));
        }

        public int func_176201_c(IBlockState state) {
            return 0;
        }

        public int func_149645_b() {
            return 3;
        }

        public boolean func_149686_d() {
            return false;
        }

        public boolean func_149662_c() {
            return false;
        }

        public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumFacing facing, float hitX, float hitY, float hitZ) {
            if (worldIn.field_72995_K) {
                return true;
            }
            ItemStack stack = playerIn.func_70694_bm();
            if (stack != null && stack.func_77973_b() == ModItems.TREAT_BAG) {
                TileEntityFoodBowl tileentitydogfoodbowl = (TileEntityFoodBowl)worldIn.func_175625_s(pos);
                InventoryTreatBag treatBag = new InventoryTreatBag(playerIn, playerIn.field_71071_by.field_70461_c, stack);
                treatBag.func_174889_b(playerIn);
                for (int i = 0; i < treatBag.func_70302_i_(); ++i) {
                    treatBag.func_70299_a(i, this.addItem((IInventory)tileentitydogfoodbowl.inventory, treatBag.func_70301_a(i)));
                }
                treatBag.func_174886_c(playerIn);
                return true;
            }
            TileEntityFoodBowl tileentitydogfoodbowl = (TileEntityFoodBowl)worldIn.func_175625_s(pos);
            playerIn.openGui((Object)DoggyTalents.INSTANCE, 3, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            return true;
        }

        public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
            TileEntityFoodBowl foodBowl = (TileEntityFoodBowl)worldIn.func_175625_s(pos);
            if (entityIn instanceof EntityItem) {
                EntityItem entityItem = (EntityItem)entityIn;
                ItemStack itemstack = entityItem.func_92059_d().func_77946_l();
                ItemStack itemstack1 = this.addItem((IInventory)foodBowl.inventory, entityItem.func_92059_d());
                if (itemstack1 != null && itemstack1.field_77994_a != 0) {
                    entityItem.func_92058_a(itemstack1);
                } else {
                    entityItem.func_70106_y();
                    worldIn.func_72908_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, "random.pop", 0.25f, ((worldIn.field_73012_v.nextFloat() - worldIn.field_73012_v.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                }
            }
        }

        public boolean func_176196_c(World worldIn, BlockPos pos) {
            return super.func_176196_c(worldIn, pos) ? this.canBlockStay(worldIn, pos) : false;
        }

        public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
            if (!this.canBlockStay((World)world, pos)) {
                this.func_176226_b((World)world, pos, world.func_180495_p(pos), 0);
                ((World)world).func_175698_g(pos);
            }
        }

        public boolean canBlockStay(World world, BlockPos pos) {
            IBlockState blockstate = world.func_180495_p(pos.func_177977_b());
            return blockstate.func_177230_c().isSideSolid((IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP);
        }

        public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
            TileEntity tileentity = worldIn.func_175625_s(pos);
            if (tileentity instanceof TileEntityFoodBowl) {
                InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)((TileEntityFoodBowl)tileentity).inventory);
                worldIn.func_175666_e(pos, (Block)this);
            }
            super.func_180663_b(worldIn, pos, state);
        }

        public boolean func_149740_M() {
            return true;
        }

        public int func_180641_l(World worldIn, BlockPos pos) {
            return Container.func_94526_b((IInventory)((TileEntityFoodBowl)worldIn.func_175625_s((BlockPos)pos)).inventory);
        }

        public ItemStack addItem(IInventory inventory, ItemStack stack) {
            if (stack == null) {
                return null;
            }
            ItemStack itemstack = stack.func_77946_l();
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                int j;
                int k;
                ItemStack itemstack1 = inventory.func_70301_a(i);
                if (itemstack1 == null) {
                    inventory.func_70299_a(i, itemstack);
                    inventory.func_70296_d();
                    return null;
                }
                if (!ItemStack.func_77989_b((ItemStack)itemstack1, (ItemStack)itemstack) || (k = Math.min(itemstack.field_77994_a, (j = Math.min(inventory.func_70297_j_(), itemstack1.func_77976_d())) - itemstack1.field_77994_a)) <= 0) continue;
                itemstack1.field_77994_a += k;
                itemstack.field_77994_a -= k;
                if (itemstack.field_77994_a != 0) continue;
                inventory.func_70296_d();
                return null;
            }
            if (itemstack.field_77994_a != stack.field_77994_a) {
                inventory.func_70296_d();
            }
            return itemstack;
        }
    }

    public static class BlockDogBedWrapper
    extends BlockDogBed {
        public final ThreadLocal<ItemStack> drops = new ThreadLocal();

        public BlockDogBedWrapper() {
            this.func_149672_a(Block.field_149766_f);
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.6f, 1.0f);
            this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)VERSION, (Comparable)((Object)"1.8")));
        }

        public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
        }

        public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()), 2);
            if (stack != null && stack.func_77942_o() && stack.func_77978_p().func_74764_b("doggytalents")) {
                String beddingId;
                NBTTagCompound tag = stack.func_77978_p().func_74775_l("doggytalents");
                String casingId = tag.func_74779_i("casingId");
                if (DogBedRegistry.CASINGS.isValidId(casingId)) {
                    ((TileEntityDogBed)worldIn.func_175625_s(pos)).setCasingId(casingId);
                }
                if (DogBedRegistry.BEDDINGS.isValidId(beddingId = tag.func_74779_i("beddingId"))) {
                    ((TileEntityDogBed)worldIn.func_175625_s(pos)).setBeddingId(beddingId);
                }
            }
        }

        @SideOnly(value=Side.CLIENT)
        public IBlockState func_176217_b(IBlockState state) {
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.SOUTH);
        }

        public IBlockState func_176203_a(int meta) {
            EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
            if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
                enumfacing = EnumFacing.NORTH;
            }
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
        }

        public int func_176201_c(IBlockState state) {
            return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
        }

        protected BlockState func_180661_e() {
            return new ExtendedBlockState((Block)this, new IProperty[]{FACING, VERSION}, new IUnlistedProperty[]{CASING, BEDDING});
        }

        public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
            TileEntity te = world.func_175625_s(pos);
            if (te instanceof TileEntityDogBed && state instanceof IExtendedBlockState) {
                IExtendedBlockState stateExtended = (IExtendedBlockState)state;
                TileEntityDogBed dogBed = (TileEntityDogBed)te;
                return stateExtended.withProperty((IUnlistedProperty)CASING, (Object)dogBed.getCasingId()).withProperty((IUnlistedProperty)BEDDING, (Object)dogBed.getBeddingId());
            }
            return super.getExtendedState(state, world, pos);
        }

        public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
            return state.func_177226_a((IProperty)VERSION, (Comparable)((Object)"1.8"));
        }

        @SideOnly(value=Side.CLIENT)
        public int func_176207_c(IBlockAccess worldIn, BlockPos pos) {
            return worldIn.func_175626_b(pos, 0);
        }

        public int func_149645_b() {
            return 3;
        }

        public boolean func_149686_d() {
            return false;
        }

        public boolean func_149662_c() {
            return false;
        }

        public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn) {
            TileEntity tileentity = worldIn.func_175625_s(pos);
            if (tileentity instanceof TileEntityDogBed) {
                TileEntityDogBed dogBed = (TileEntityDogBed)tileentity;
                if (!playerIn.field_71075_bZ.field_75098_d) {
                    this.drops.set(DogBedRegistry.createItemStack(dogBed.getCasingId(), dogBed.getBeddingId()));
                }
            }
        }

        public ItemStack getPickBlock(MovingObjectPosition target, World world, BlockPos pos) {
            TileEntity tile = world.func_175625_s(pos);
            if (!(tile instanceof TileEntityDogBed)) {
                return null;
            }
            TileEntityDogBed dogBed = (TileEntityDogBed)tile;
            return DogBedRegistry.createItemStack(dogBed.getCasingId(), dogBed.getBeddingId());
        }

        public boolean func_176196_c(World worldIn, BlockPos pos) {
            return super.func_176196_c(worldIn, pos) ? this.canBlockStay(worldIn, pos) : false;
        }

        public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
            TileEntity tile;
            if (!this.canBlockStay((World)world, pos) && (tile = world.func_175625_s(pos)) instanceof TileEntityDogBed) {
                TileEntityDogBed dogBed = (TileEntityDogBed)tile;
                BlockDogBedWrapper.func_180635_a((World)((World)world), (BlockPos)pos, (ItemStack)DogBedRegistry.createItemStack(dogBed.getCasingId(), dogBed.getBeddingId()));
                ((World)world).func_175698_g(pos);
            }
        }

        public boolean canBlockStay(World world, BlockPos pos) {
            IBlockState blockstate = world.func_180495_p(pos.func_177977_b());
            return blockstate.func_177230_c().isSideSolid((IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP);
        }

        @SideOnly(value=Side.CLIENT)
        public boolean addDestroyEffects(World world, BlockPos pos, EffectRenderer manager) {
            IBlockState state = world.func_180495_p(pos);
            IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_175022_a(state, (IBlockAccess)world, pos);
            TextureAtlasSprite sprite = model.func_177554_e();
            if (sprite != null) {
                for (int j = 0; j < 4; ++j) {
                    for (int k = 0; k < 4; ++k) {
                        for (int l = 0; l < 4; ++l) {
                            double d0 = ((double)j + 0.5) / 4.0;
                            double d1 = ((double)k + 0.5) / 4.0;
                            double d2 = ((double)l + 0.5) / 4.0;
                            manager.func_78873_a((EntityFX)new ParticleCustomDigging(world, (double)pos.func_177958_n() + d0, (double)pos.func_177956_o() + d1, (double)pos.func_177952_p() + d2, d0 - 0.5, d1 - 0.5, d2 - 0.5, state, pos, sprite));
                        }
                    }
                }
                return true;
            }
            return false;
        }

        @SideOnly(value=Side.CLIENT)
        public boolean addHitEffects(World world, MovingObjectPosition target, EffectRenderer manager) {
            IBlockState state = world.func_180495_p(target.func_178782_a());
            IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_175022_a(state, (IBlockAccess)world, target.func_178782_a());
            BlockPos pos = target.func_178782_a();
            EnumFacing side = target.field_178784_b;
            TextureAtlasSprite sprite = model.func_177554_e();
            if (sprite != null) {
                int x = pos.func_177958_n();
                int y = pos.func_177956_o();
                int z = pos.func_177952_p();
                float f = 0.1f;
                double d0 = (double)x + RANDOM.nextDouble() * (this.func_149753_y() - this.func_149704_x() - (double)(f * 2.0f)) + (double)f + this.func_149704_x();
                double d1 = (double)y + RANDOM.nextDouble() * (this.func_149669_A() - this.func_149665_z() - (double)(f * 2.0f)) + (double)f + this.func_149665_z();
                double d2 = (double)z + RANDOM.nextDouble() * (this.func_149693_C() - this.func_149706_B() - (double)(f * 2.0f)) + (double)f + this.func_149706_B();
                if (side == EnumFacing.DOWN) {
                    d1 = (double)y + this.func_149665_z() - (double)f;
                }
                if (side == EnumFacing.UP) {
                    d1 = (double)y + this.func_149669_A() + (double)f;
                }
                if (side == EnumFacing.NORTH) {
                    d2 = (double)z + this.func_149706_B() - (double)f;
                }
                if (side == EnumFacing.SOUTH) {
                    d2 = (double)z + this.func_149693_C() + (double)f;
                }
                if (side == EnumFacing.WEST) {
                    d0 = (double)x + this.func_149704_x() - (double)f;
                }
                if (side == EnumFacing.EAST) {
                    d0 = (double)x + this.func_149753_y() + (double)f;
                }
                EntityFX particle = new ParticleCustomDigging(world, d0, d1, d2, 0.0, 0.0, 0.0, state, pos, sprite).func_70543_e(0.2f).func_70541_f(0.6f);
                manager.func_78873_a(particle);
                return true;
            }
            return false;
        }
    }

    public static class BlockDogBathWrapper
    extends BlockDogBath {
        public BlockDogBathWrapper() {
            this.func_149672_a(Block.field_149777_j);
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f);
            this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)VERSION, (Comparable)((Object)"1.8")));
        }

        protected BlockState func_180661_e() {
            return new BlockState((Block)this, new IProperty[]{VERSION});
        }

        public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
            return state.func_177226_a((IProperty)VERSION, (Comparable)((Object)"1.8"));
        }

        public int func_176201_c(IBlockState state) {
            return 0;
        }

        public int func_149645_b() {
            return 3;
        }

        public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
            if (entity instanceof EntityDog) {
                EntityDog dog = (EntityDog)entity;
                dog.isShaking = true;
            }
        }

        public boolean func_149662_c() {
            return false;
        }

        public boolean func_149686_d() {
            return false;
        }

        public boolean func_176196_c(World worldIn, BlockPos pos) {
            return super.func_176196_c(worldIn, pos) ? this.canBlockStay(worldIn, pos) : false;
        }

        public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
            if (!this.canBlockStay((World)world, pos)) {
                this.func_176226_b((World)world, pos, world.func_180495_p(pos), 0);
                ((World)world).func_175698_g(pos);
            }
        }

        public boolean canBlockStay(World world, BlockPos pos) {
            IBlockState blockstate = world.func_180495_p(pos.func_177977_b());
            return blockstate.func_177230_c().isSideSolid((IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP);
        }
    }
}

