/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.entity;

import doggytalents.api.DoggyTalentsAPI;
import doggytalents.base.IDataTracker;
import doggytalents.base.ObjectLib;
import doggytalents.base.VersionControl;
import doggytalents.entity.EntityDog;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class EntityAbstractDog
extends EntityTameable {
    private float headRotationCourse;
    private float headRotationCourseOld;
    private boolean isWet;
    public boolean isShaking;
    private float timeWolfIsShaking;
    private float prevTimeWolfIsShaking;
    public IDataTracker dataTracker;

    public EntityAbstractDog(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.6f, 0.85f);
    }

    public abstract Entity getEntityWeAreRiding();

    public abstract void dismountEntityWeAreRiding();

    public abstract Entity getControllingPassenger();

    public abstract boolean isBeingRidden();

    public abstract void removeEntityRidingUs();

    protected void func_70088_a() {
        super.func_70088_a();
        this.dataTracker = VersionControl.createObject("DataTrackerWrapper", IDataTracker.class, EntityDog.class, (Object)this);
    }

    public float func_70599_aP() {
        return 0.4f;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && this.isWet && !this.isShaking && !this.func_70781_l() && this.field_70122_E) {
            this.isShaking = true;
            this.timeWolfIsShaking = 0.0f;
            this.prevTimeWolfIsShaking = 0.0f;
            this.field_70170_p.func_72960_a((Entity)this, (byte)8);
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.headRotationCourseOld = this.headRotationCourse;
        this.headRotationCourse = this.isBegging() ? (this.headRotationCourse += (1.0f - this.headRotationCourse) * 0.4f) : (this.headRotationCourse += (0.0f - this.headRotationCourse) * 0.4f);
        if (this.func_70026_G()) {
            this.isWet = true;
            this.isShaking = false;
            this.timeWolfIsShaking = 0.0f;
            this.prevTimeWolfIsShaking = 0.0f;
        } else if ((this.isWet || this.isShaking) && this.isShaking) {
            if (this.timeWolfIsShaking == 0.0f) {
                ObjectLib.BRIDGE.playSound((Entity)this, "mob.wolf.shake", this.func_70599_aP(), (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            }
            this.prevTimeWolfIsShaking = this.timeWolfIsShaking;
            this.timeWolfIsShaking += 0.05f;
            if (this.prevTimeWolfIsShaking >= 2.0f) {
                this.isWet = false;
                this.isShaking = false;
                this.prevTimeWolfIsShaking = 0.0f;
                this.timeWolfIsShaking = 0.0f;
                this.onFinishShaking();
            }
            if (this.timeWolfIsShaking > 0.4f) {
                float f = (float)this.func_174813_aQ().field_72338_b;
                int i = (int)(ObjectLib.BRIDGE.sin((this.timeWolfIsShaking - 0.4f) * (float)Math.PI) * 7.0f);
                for (int j = 0; j < i; ++j) {
                    float f1 = (this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * this.field_70130_N * 0.5f;
                    float f2 = (this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * this.field_70130_N * 0.5f;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_SPLASH, this.field_70165_t + (double)f1, (double)(f + 0.8f), this.field_70161_v + (double)f2, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isDogWet() {
        return this.isWet;
    }

    @SideOnly(value=Side.CLIENT)
    public float getShadingWhileWet(float partialTickTime) {
        return 0.75f + (this.prevTimeWolfIsShaking + (this.timeWolfIsShaking - this.prevTimeWolfIsShaking) * partialTickTime) / 2.0f * 0.25f;
    }

    @SideOnly(value=Side.CLIENT)
    public float getShakeAngle(float partialTickTime, float p_70923_2_) {
        float f = (this.prevTimeWolfIsShaking + (this.timeWolfIsShaking - this.prevTimeWolfIsShaking) * partialTickTime + p_70923_2_) / 1.8f;
        f = ObjectLib.BRIDGE.clamp(f, 0.0f, 1.0f);
        return ObjectLib.BRIDGE.sin(f * (float)Math.PI) * ObjectLib.BRIDGE.sin(f * (float)Math.PI * 11.0f) * 0.15f * (float)Math.PI;
    }

    @SideOnly(value=Side.CLIENT)
    public float getInterestedAngle(float partialTickTime) {
        return (this.headRotationCourseOld + (this.headRotationCourse - this.headRotationCourseOld) * partialTickTime) * 0.15f * (float)Math.PI;
    }

    @SideOnly(value=Side.CLIENT)
    public float getTailRotation() {
        return this.func_70909_n() ? (0.55f - (this.func_110138_aP() - this.func_110143_aJ()) / (this.func_110138_aP() / 20.0f) * 0.02f) * (float)Math.PI : 0.62831855f;
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.8f;
    }

    public int func_70646_bf() {
        return this.func_70906_o() ? 20 : super.func_70646_bf();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 8) {
            this.isShaking = true;
            this.timeWolfIsShaking = 0.0f;
            this.prevTimeWolfIsShaking = 0.0f;
        } else {
            super.func_70103_a(id);
        }
    }

    public double func_70033_W() {
        return this.getEntityWeAreRiding() instanceof EntityPlayer ? 0.5 : 0.0;
    }

    public boolean isBegging() {
        return this.dataTracker.isBegging();
    }

    public void setBegging(boolean flag) {
        this.dataTracker.setBegging(flag);
    }

    public boolean func_70877_b(ItemStack stack) {
        return !ObjectLib.STACK_UTIL.isEmpty(stack) && DoggyTalentsAPI.BREED_WHITELIST.containsItem(stack);
    }

    public boolean func_70878_b(EntityAnimal otherAnimal) {
        if (otherAnimal == this) {
            return false;
        }
        if (!this.func_70909_n()) {
            return false;
        }
        if (!(otherAnimal instanceof EntityAbstractDog)) {
            return false;
        }
        EntityAbstractDog entitydog = (EntityAbstractDog)otherAnimal;
        return !entitydog.func_70909_n() ? false : (entitydog.func_70906_o() ? false : this.func_70880_s() && entitydog.func_70880_s());
    }

    public boolean canRiderInteract() {
        return true;
    }

    public boolean func_82171_bF() {
        return this.getControllingPassenger() instanceof EntityPlayer;
    }

    private void onFinishShaking() {
    }

    public void func_70645_a(DamageSource cause) {
    }
}

