/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.block;

import com.google.common.base.Predicate;
import doggytalents.api.DoggyTalentsAPI;
import doggytalents.api.registry.DogBedRegistry;
import doggytalents.block.PropertyString;
import doggytalents.entity.EntityDog;
import doggytalents.tileentity.TileEntityDogBed;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockDogBed
extends BlockContainer {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final PropertyString CASING = PropertyString.create("casing");
    public static final PropertyString BEDDING = PropertyString.create("bedding");

    public BlockDogBed() {
        super(Material.field_151575_d);
        this.func_149711_c(2.0f);
        this.func_149752_b(5.0f);
        this.func_149672_a(Block.field_149766_f);
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.6f, 1.0f);
        this.func_149647_a(DoggyTalentsAPI.CREATIVE_TAB);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityDogBed();
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()), 2);
        if (stack != null && stack.func_77942_o() && stack.func_77978_p().func_74764_b("doggytalents")) {
            String beddingId;
            NBTTagCompound tag = stack.func_77978_p().func_74775_l("doggytalents");
            String casingId = tag.func_74779_i("casingId");
            if (DogBedRegistry.CASINGS.isValidId(casingId)) {
                ((TileEntityDogBed)worldIn.func_175625_s(pos)).setCasingId(casingId);
            }
            if (DogBedRegistry.BEDDINGS.isValidId(beddingId = tag.func_74779_i("beddingId"))) {
                ((TileEntityDogBed)worldIn.func_175625_s(pos)).setBeddingId(beddingId);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IBlockState func_176217_b(IBlockState state) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.SOUTH);
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    protected BlockState func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[]{FACING}, new IUnlistedProperty[]{CASING, BEDDING});
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityDogBed && state instanceof IExtendedBlockState) {
            IExtendedBlockState stateExtended = (IExtendedBlockState)state;
            TileEntityDogBed dogBed = (TileEntityDogBed)te;
            return stateExtended.withProperty((IUnlistedProperty)CASING, (Object)dogBed.getCasingId()).withProperty((IUnlistedProperty)BEDDING, (Object)dogBed.getBeddingId());
        }
        return state;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(World world, MovingObjectPosition target, EffectRenderer effectRenderer) {
        BlockPos pos = target.func_178782_a();
        IBlockState iblockstate = world.func_180495_p(pos);
        Block block = iblockstate.func_177230_c();
        EnumFacing side = target.field_178784_b;
        int i = pos.func_177958_n();
        int j = pos.func_177956_o();
        int k = pos.func_177952_p();
        float f = 0.1f;
        double d0 = (double)i + world.field_73012_v.nextDouble() * (block.func_149753_y() - block.func_149704_x() - (double)(f * 2.0f)) + (double)f + block.func_149704_x();
        double d1 = (double)j + world.field_73012_v.nextDouble() * (block.func_149669_A() - block.func_149665_z() - (double)(f * 2.0f)) + (double)f + block.func_149665_z();
        double d2 = (double)k + world.field_73012_v.nextDouble() * (block.func_149693_C() - block.func_149706_B() - (double)(f * 2.0f)) + (double)f + block.func_149706_B();
        if (side == EnumFacing.DOWN) {
            d1 = (double)j + block.func_149665_z() - (double)f;
        }
        if (side == EnumFacing.UP) {
            d1 = (double)j + block.func_149669_A() + (double)f;
        }
        if (side == EnumFacing.NORTH) {
            d2 = (double)k + block.func_149706_B() - (double)f;
        }
        if (side == EnumFacing.SOUTH) {
            d2 = (double)k + block.func_149693_C() + (double)f;
        }
        if (side == EnumFacing.WEST) {
            d0 = (double)i + block.func_149704_x() - (double)f;
        }
        if (side == EnumFacing.EAST) {
            d0 = (double)i + block.func_149753_y() + (double)f;
        }
        world.func_175688_a(EnumParticleTypes.BLOCK_CRACK, d0, d1, d2, 0.0, 0.0, 0.0, new int[]{Block.func_176210_f((IBlockState)iblockstate)});
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_176207_c(IBlockAccess worldIn, BlockPos pos) {
        Block block = worldIn.func_180495_p(pos).func_177230_c();
        int i = worldIn.func_175626_b(pos, 0);
        return i;
    }

    public void func_180638_a(World worldIn, BlockPos pos, IBlockState state, AxisAlignedBB mask, List list, Entity collidingEntity) {
        if (!(collidingEntity instanceof EntityDog)) {
            super.func_180638_a(worldIn, pos, state, mask, list, collidingEntity);
        }
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149730_j() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return 3;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        TileEntity target = world.func_175625_s(pos);
        if (!(target instanceof TileEntityDogBed)) {
            return ret;
        }
        TileEntityDogBed dogBed = (TileEntityDogBed)target;
        ItemStack stack = DogBedRegistry.createItemStack(dogBed.getCasingId(), dogBed.getBeddingId());
        ret.add(stack);
        return ret;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (!(tile instanceof TileEntityDogBed)) {
            return null;
        }
        TileEntityDogBed dogBed = (TileEntityDogBed)tile;
        return DogBedRegistry.createItemStack(dogBed.getCasingId(), dogBed.getBeddingId());
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return super.func_176196_c(worldIn, pos) ? this.canBlockStay(worldIn, pos) : false;
    }

    public void func_176204_a(World worldIn, BlockPos pos, IBlockState state, Block neighborBlock) {
        TileEntity tile;
        if (!this.canBlockStay(worldIn, pos) && (tile = worldIn.func_175625_s(pos)) instanceof TileEntityDogBed) {
            TileEntityDogBed dogBed = (TileEntityDogBed)tile;
            BlockDogBed.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)DogBedRegistry.createItemStack(dogBed.getCasingId(), dogBed.getBeddingId()));
            worldIn.func_175698_g(pos);
        }
    }

    public boolean canBlockStay(World world, BlockPos pos) {
        IBlockState blockstate = world.func_180495_p(pos.func_177977_b());
        return blockstate.func_177230_c().isSideSolid((IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs creativeTab, List stackList) {
        for (String casingId : DogBedRegistry.CASINGS.getKeys()) {
            stackList.add(DogBedRegistry.createItemStack(casingId, Block.field_149771_c.func_177774_c((Object)Blocks.field_150325_L) + ".0"));
        }
    }
}

