/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.renderer.block;

import com.google.common.collect.Lists;
import doggytalents.api.registry.DogBedRegistry;
import doggytalents.block.BlockDogBed;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BreakingFour;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.client.resources.model.SimpleBakedModel;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.model.ISmartBlockModel;
import net.minecraftforge.client.model.ISmartItemModel;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public class DogBedModelTexture
extends SimpleBakedModel
implements ISmartBlockModel,
ISmartItemModel {
    private final Map<List<String>, IBakedModel> cache = new HashMap<List<String>, IBakedModel>();

    public DogBedModelTexture(List p_i46077_1_, List p_i46077_2_, boolean p_i46077_3_, boolean p_i46077_4_, TextureAtlasSprite particleTexture, ItemCameraTransforms p_i46077_6_) {
        super(p_i46077_1_, p_i46077_2_, p_i46077_3_, p_i46077_4_, particleTexture, p_i46077_6_);
    }

    public IBakedModel handleBlockState(IBlockState blockstate) {
        if (blockstate instanceof IExtendedBlockState) {
            IExtendedBlockState exState = (IExtendedBlockState)blockstate;
            String casingId = (String)exState.getValue((IUnlistedProperty)BlockDogBed.CASING);
            String beddingId = (String)exState.getValue((IUnlistedProperty)BlockDogBed.BEDDING);
            return this.getCachedModel(casingId, beddingId);
        }
        return this;
    }

    public IBakedModel handleItemState(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("doggytalents")) {
            NBTTagCompound tag = stack.func_77978_p().func_74775_l("doggytalents");
            String casingId = tag.func_74779_i("casingId");
            String beddingId = tag.func_74779_i("beddingId");
            return this.getCachedModel(casingId, beddingId);
        }
        return this;
    }

    public IBakedModel getCachedModel(String casingId, String beddingId) {
        List<String> key = Arrays.asList(casingId, beddingId);
        if (!this.cache.containsKey(key)) {
            TextureAtlasSprite casingTexture = Minecraft.func_71410_x().func_147117_R().func_110572_b(DogBedRegistry.CASINGS.getTexture(casingId));
            TextureAtlasSprite beddingTexture = Minecraft.func_71410_x().func_147117_R().func_110572_b(DogBedRegistry.BEDDINGS.getTexture(beddingId));
            this.cache.put(key, new Builder((IBakedModel)this, casingTexture, beddingTexture).makeBakedModel());
        }
        return this.cache.get(key);
    }

    public static class Builder {
        private final List builderGeneralQuads = Lists.newArrayList();
        private final List builderFaceQuads = Lists.newArrayListWithCapacity((int)6);
        private final boolean builderAmbientOcclusion;
        private TextureAtlasSprite builderTexture;
        private boolean builderGui3d;
        private ItemCameraTransforms builderCameraTransforms;

        public Builder(IBakedModel p_i46075_1_, TextureAtlasSprite casingTexture, TextureAtlasSprite beddingTexture) {
            this(p_i46075_1_.func_177555_b(), p_i46075_1_.func_177556_c(), p_i46075_1_.func_177552_f());
            this.builderTexture = casingTexture;
            for (EnumFacing enumfacing : EnumFacing.values()) {
                this.addFaceBreakingFours(p_i46075_1_, casingTexture, beddingTexture, enumfacing);
            }
            this.addGeneralBreakingFours(p_i46075_1_, casingTexture, beddingTexture);
        }

        private void addFaceBreakingFours(IBakedModel p_177649_1_, TextureAtlasSprite casingTexture, TextureAtlasSprite beddingTexture, EnumFacing p_177649_3_) {
            Iterator iterator = p_177649_1_.func_177551_a(p_177649_3_).iterator();
            int i = 0;
            while (iterator.hasNext()) {
                BakedQuad bakedquad = (BakedQuad)iterator.next();
                TextureAtlasSprite sprite = casingTexture;
                this.addFaceQuad(p_177649_3_, (BakedQuad)new BreakingFour(bakedquad, sprite));
                ++i;
            }
        }

        private void addGeneralBreakingFours(IBakedModel p_177647_1_, TextureAtlasSprite casingTexture, TextureAtlasSprite beddingTexture) {
            Iterator iterator = p_177647_1_.func_177550_a().iterator();
            int i = 0;
            while (iterator.hasNext()) {
                BakedQuad bakedquad = (BakedQuad)iterator.next();
                TextureAtlasSprite sprite = casingTexture;
                if (i == 1 || i == 2 || i == 3 || i == 4) {
                    sprite = beddingTexture;
                }
                this.addGeneralQuad((BakedQuad)new BreakingFour(bakedquad, sprite));
                ++i;
            }
        }

        private Builder(boolean p_i46076_1_, boolean p_i46076_2_, ItemCameraTransforms p_i46076_3_) {
            for (EnumFacing enumfacing : EnumFacing.values()) {
                this.builderFaceQuads.add(Lists.newArrayList());
            }
            this.builderAmbientOcclusion = p_i46076_1_;
            this.builderGui3d = p_i46076_2_;
            this.builderCameraTransforms = p_i46076_3_;
        }

        public Builder addFaceQuad(EnumFacing p_177650_1_, BakedQuad p_177650_2_) {
            ((List)this.builderFaceQuads.get(p_177650_1_.ordinal())).add(p_177650_2_);
            return this;
        }

        public Builder addGeneralQuad(BakedQuad p_177648_1_) {
            this.builderGeneralQuads.add(p_177648_1_);
            return this;
        }

        public Builder setTexture(TextureAtlasSprite p_177646_1_) {
            this.builderTexture = p_177646_1_;
            return this;
        }

        public IBakedModel makeBakedModel() {
            if (this.builderTexture == null) {
                throw new RuntimeException("Missing particle!");
            }
            return new DogBedModelTexture(this.builderGeneralQuads, this.builderFaceQuads, this.builderAmbientOcclusion, this.builderGui3d, this.builderTexture, this.builderCameraTransforms);
        }
    }
}

