/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.entity;

import com.google.common.base.Predicate;
import doggytalents.DoggyTalentsMod;
import doggytalents.ModItems;
import doggytalents.api.DoggyTalentsAPI;
import doggytalents.api.IDogTreat;
import doggytalents.entity.CoordUtil;
import doggytalents.entity.LevelUtil;
import doggytalents.entity.ModeUtil;
import doggytalents.entity.TalentHelper;
import doggytalents.entity.TalentUtil;
import doggytalents.entity.ai.EntityAIDogBeg;
import doggytalents.entity.ai.EntityAIFetchBone;
import doggytalents.entity.ai.EntityAIFollowOwner;
import doggytalents.entity.ai.EntityAIModeAttackTarget;
import doggytalents.entity.ai.EntityAIOwnerHurtByTarget;
import doggytalents.entity.ai.EntityAIOwnerHurtTarget;
import doggytalents.entity.ai.EntityAIShepherdDog;
import doggytalents.lib.Constants;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAISit;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITargetNonTamed;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.BlockPos;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityDog
extends EntityTameable {
    private float timeDogBegging;
    private float prevTimeDogBegging;
    private boolean isShaking;
    public boolean forceShake;
    private float timeDogIsShaking;
    private float prevTimeDogIsShaking;
    private int hungerTick;
    private int prevHungerTick;
    private int healingTick;
    private int prevHealingTick;
    private int regenerationTick;
    private int prevRegenerationTick;
    private float timeWolfIsHappy;
    private float prevTimeWolfIsHappy;
    private boolean isWolfHappy;
    public boolean hiyaMaster;
    private int reversionTime;
    private boolean hasBone;
    public EntityAIFetchBone aiFetchBone;
    public TalentUtil talents;
    public LevelUtil levels;
    public ModeUtil mode;
    public CoordUtil coords;
    public Map<String, Object> objects = new HashMap<String, Object>();

    public EntityDog(World word) {
        super(word);
        this.func_70105_a(0.6f, 0.8f);
        ((PathNavigateGround)this.func_70661_as()).func_179690_a(true);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.field_70911_d);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.4f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIFollowOwner(this, 1.0, 10.0f, 2.0f));
        this.aiFetchBone = new EntityAIFetchBone(this, 1.0, 0.5f, 20.0f);
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)this.aiFetchBone);
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIDogBeg(this, 8.0f));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIOwnerHurtByTarget(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIOwnerHurtTarget(this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIModeAttackTarget(this));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAITargetNonTamed((EntityTameable)this, EntityAnimal.class, false, new Predicate(){

            public boolean func_180094_a(Entity p_180094_1_) {
                return p_180094_1_ instanceof EntitySheep || p_180094_1_ instanceof EntityRabbit;
            }

            public boolean apply(Object p_apply_1_) {
                return this.func_180094_a((Entity)p_apply_1_);
            }
        }));
        this.field_70715_bh.func_75776_a(6, (EntityAIBase)new EntityAIShepherdDog(this, EntityAnimal.class, 0, false));
        this.func_70903_f(false);
        TalentHelper.onClassCreation(this);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.3f);
        this.updateEntityAttributes();
    }

    public void updateEntityAttributes() {
        if (this.func_70909_n()) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0 + (this.effectiveLevel() + 1.0));
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(8.0);
        }
    }

    public String func_70005_c_() {
        String name = this.getDogName();
        if (name != "") {
            return name;
        }
        return super.func_70005_c_();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_94059_bO() {
        return true;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.talents = new TalentUtil(this);
        this.levels = new LevelUtil(this);
        this.mode = new ModeUtil(this);
        this.coords = new CoordUtil(this);
        this.field_70180_af.func_75682_a(19, (Object)new Byte(0));
        this.field_70180_af.func_75682_a(20, (Object)new Byte(0));
        this.field_70180_af.func_75682_a(21, (Object)new String(""));
        this.field_70180_af.func_75682_a(22, (Object)new String(""));
        this.field_70180_af.func_75682_a(23, (Object)new Integer(60));
        this.field_70180_af.func_75682_a(24, (Object)new String("0:0"));
        this.field_70180_af.func_75682_a(25, (Object)new Integer(0));
        this.field_70180_af.func_75682_a(26, (Object)new Integer(0));
        this.field_70180_af.func_75682_a(27, (Object)new Integer(0));
        this.field_70180_af.func_75682_a(28, (Object)"-1:-1:-1:-1:-1:-1");
    }

    protected void func_180429_a(BlockPos pos, Block block) {
        this.func_85030_a("mob.wolf.step", 0.15f, 1.0f);
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74778_a("version", "v1.9.1g");
        tagCompound.func_74768_a("doggyTex", this.getTameSkin());
        tagCompound.func_74778_a("dogName", this.getDogName());
        tagCompound.func_74768_a("dogHunger", this.getDogHunger());
        tagCompound.func_74757_a("willObey", this.willObeyOthers());
        tagCompound.func_74757_a("radioCollar", this.hasRadarCollar());
        this.talents.writeTalentsToNBT(tagCompound);
        this.levels.writeTalentsToNBT(tagCompound);
        this.mode.writeToNBT(tagCompound);
        this.coords.writeToNBT(tagCompound);
        TalentHelper.writeToNBT(this, tagCompound);
    }

    public void func_70037_a(NBTTagCompound tagCompound) {
        super.func_70037_a(tagCompound);
        String lastVersion = tagCompound.func_74779_i("version");
        this.setTameSkin(tagCompound.func_74762_e("doggyTex"));
        this.setDogName(tagCompound.func_74779_i("dogName"));
        this.setDogHunger(tagCompound.func_74762_e("dogHunger"));
        this.setWillObeyOthers(tagCompound.func_74767_n("willObey"));
        this.hasRadarCollar(tagCompound.func_74767_n("radioCollar"));
        this.talents.readTalentsFromNBT(tagCompound);
        this.levels.readTalentsFromNBT(tagCompound);
        this.mode.readFromNBT(tagCompound);
        this.coords.readFromNBT(tagCompound);
        TalentHelper.readFromNBT(this, tagCompound);
    }

    public String func_70639_aQ() {
        String sound = TalentHelper.getLivingSound(this);
        if (!"".equals(sound)) {
            return sound;
        }
        return this.field_70146_Z.nextInt(3) == 0 ? (this.func_70909_n() && this.func_110143_aJ() < this.func_110138_aP() / 2.0f ? "mob.wolf.whine" : "mob.wolf.panting") : "mob.wolf.bark";
    }

    public String func_70621_aR() {
        return "mob.wolf.hurt";
    }

    public String func_70673_aS() {
        return "mob.wolf.death";
    }

    public float func_70599_aP() {
        return 0.4f;
    }

    protected Item func_146068_u() {
        return Item.func_150899_d((int)-1);
    }

    public EntityAISit getSitAI() {
        return this.field_70911_d;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && this.isShaking && !this.forceShake && !this.func_70781_l() && this.field_70122_E) {
            this.forceShake = true;
            this.timeDogIsShaking = 0.0f;
            this.prevTimeDogIsShaking = 0.0f;
            this.field_70170_p.func_72960_a((Entity)this, (byte)8);
        }
        if (Constants.IS_HUNGER_ON) {
            this.prevHungerTick = this.hungerTick++;
            if (this.field_70153_n != null || !this.func_70906_o()) {
                // empty if block
            }
            this.hungerTick += TalentHelper.onHungerTick(this, this.hungerTick - this.prevHungerTick);
            if (this.hungerTick > 400) {
                this.setDogHunger(this.getDogHunger() - 1);
                this.hungerTick -= 400;
            }
        }
        if (Constants.DOGS_IMMORTAL) {
            this.prevRegenerationTick = this.regenerationTick++;
            if (this.func_70906_o()) {
                this.regenerationTick += TalentHelper.onRegenerationTick(this, this.regenerationTick - this.prevRegenerationTick);
            } else if (!this.func_70906_o()) {
                this.regenerationTick = 0;
            }
            if (this.regenerationTick >= 2400 && this.isIncapacicated()) {
                this.func_70606_j(2.0f);
                this.setDogHunger(1);
            } else if (this.regenerationTick >= 2400 && !this.isIncapacicated() && this.regenerationTick >= 4400 && this.getDogHunger() < 60) {
                this.setDogHunger(this.getDogHunger() + 1);
                this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                this.regenerationTick = 2400;
            }
        }
        if (this.func_110143_aJ() != 1.0f) {
            this.prevHealingTick = this.healingTick;
            this.healingTick += this.nourishment();
            if (this.healingTick >= 6000) {
                if (this.func_110143_aJ() < this.func_110138_aP()) {
                    this.func_70606_j(this.func_110143_aJ() + 1.0f);
                }
                this.healingTick = 0;
            }
        }
        if (this.func_110143_aJ() <= 0.0f && this.isImmortal()) {
            this.field_70725_aQ = 0;
            this.func_70606_j(1.0f);
        }
        if (this.getDogHunger() == 0 && this.field_70170_p.func_72912_H().func_76073_f() % 100L == 0L && this.func_110143_aJ() > 1.0f) {
            this.func_70097_a(DamageSource.field_76377_j, 1.0f);
        }
        if (this.levels.isDireDog() && Constants.DIRE_PARTICLES) {
            for (int i = 0; i < 2; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O - 0.25, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, (this.field_70146_Z.nextDouble() - 0.5) * 2.0, -this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0, new int[0]);
            }
        }
        if (this.reversionTime > 0) {
            --this.reversionTime;
        }
        TalentHelper.onLivingUpdate(this);
    }

    public void func_70071_h_() {
        float distanceToOwner;
        EntityPlayer player;
        super.func_70071_h_();
        this.prevTimeDogBegging = this.timeDogBegging;
        this.timeDogBegging = this.isBegging() ? (this.timeDogBegging += (1.0f - this.timeDogBegging) * 0.4f) : (this.timeDogBegging += (0.0f - this.timeDogBegging) * 0.4f);
        if (this.func_70026_G()) {
            this.isShaking = true;
            this.forceShake = false;
            this.timeDogIsShaking = 0.0f;
            this.prevTimeDogIsShaking = 0.0f;
        } else if ((this.isShaking || this.forceShake) && this.forceShake) {
            if (this.timeDogIsShaking == 0.0f) {
                this.func_85030_a("mob.wolf.shake", this.func_70599_aP(), (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            }
            this.prevTimeDogIsShaking = this.timeDogIsShaking;
            this.timeDogIsShaking += 0.05f;
            if (this.prevTimeDogIsShaking >= 2.0f) {
                if (this.field_70146_Z.nextInt(15) < this.talents.getLevel("fisherdog") * 2) {
                    if (this.field_70146_Z.nextInt(15) < this.talents.getLevel("hellhound") * 2) {
                        if (!this.field_70170_p.field_72995_K) {
                            this.func_145779_a(Items.field_179566_aV, 1);
                        }
                    } else if (!this.field_70170_p.field_72995_K) {
                        this.func_145779_a(Items.field_151115_aP, 1);
                    }
                }
                this.isShaking = false;
                this.forceShake = false;
                this.prevTimeDogIsShaking = 0.0f;
                this.timeDogIsShaking = 0.0f;
            }
            if (this.timeDogIsShaking > 0.4f) {
                float f = (float)this.func_174813_aQ().field_72338_b;
                int i = (int)(MathHelper.func_76126_a((float)((this.timeDogIsShaking - 0.4f) * (float)Math.PI)) * 7.0f);
                for (int j = 0; j < i; ++j) {
                    float f1 = (this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * this.field_70130_N * 0.5f;
                    float f2 = (this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * this.field_70130_N * 0.5f;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_SPLASH, this.field_70165_t + (double)f1, (double)(f + 0.8f), this.field_70161_v + (double)f2, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
                }
            }
        }
        if (this.field_70146_Z.nextInt(200) == 0) {
            this.hiyaMaster = true;
        }
        if ((this.isBegging() || this.hiyaMaster) && !this.isWolfHappy) {
            this.isWolfHappy = true;
            this.timeWolfIsHappy = 0.0f;
            this.prevTimeWolfIsHappy = 0.0f;
        } else {
            this.hiyaMaster = false;
        }
        if (this.isWolfHappy) {
            if (this.timeWolfIsHappy % 1.0f == 0.0f) {
                this.field_70170_p.func_72956_a((Entity)this, "mob.wolf.panting", this.func_70599_aP(), (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            }
            this.prevTimeWolfIsHappy = this.timeWolfIsHappy;
            this.timeWolfIsHappy += 0.05f;
            if (this.prevTimeWolfIsHappy >= 8.0f) {
                this.isWolfHappy = false;
                this.prevTimeWolfIsHappy = 0.0f;
                this.timeWolfIsHappy = 0.0f;
            }
        }
        if (this.func_70909_n() && (player = (EntityPlayer)this.func_70902_q()) != null && (distanceToOwner = player.func_70032_d((Entity)this)) <= 2.0f && this.hasBone()) {
            if (!this.field_70170_p.field_72995_K) {
                this.func_70099_a(new ItemStack(ModItems.throwBone, 1, 1), 0.0f);
            }
            this.setHasBone(false);
        }
        TalentHelper.onUpdate(this);
    }

    public void func_70612_e(float strafe, float forward) {
        if (this.field_70153_n instanceof EntityPlayer) {
            this.field_70126_B = this.field_70177_z = this.field_70153_n.field_70177_z;
            this.field_70125_A = this.field_70153_n.field_70125_A * 0.5f;
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            this.field_70759_as = this.field_70761_aq = this.field_70177_z;
            strafe = ((EntityPlayer)this.field_70153_n).field_70702_br * 0.5f;
            forward = ((EntityPlayer)this.field_70153_n).field_70701_bs;
            if (forward <= 0.0f) {
                forward *= 0.25f;
            }
            if (this.field_70122_E && forward > 0.0f) {
                float f2 = MathHelper.func_76126_a((float)(this.field_70177_z * (float)Math.PI / 180.0f));
                float f3 = MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f));
                this.field_70159_w += (double)(-0.4f * f2 * 0.15f);
                this.field_70179_y += (double)(0.4f * f3 * 0.15f);
            }
            this.field_70138_W = 1.0f;
            this.field_70747_aH = this.func_70689_ay() * 0.2f;
            if (!this.field_70170_p.field_72995_K) {
                this.func_70659_e((float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e() / 4.0f);
                super.func_70612_e(strafe, forward);
            }
            if (this.field_70122_E) {
                // empty if block
            }
            this.field_70722_aY = this.field_70721_aZ;
            double d0 = this.field_70165_t - this.field_70169_q;
            double d1 = this.field_70161_v - this.field_70166_s;
            float f4 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1)) * 4.0f;
            if (f4 > 1.0f) {
                f4 = 1.0f;
            }
            this.field_70721_aZ += (f4 - this.field_70721_aZ) * 0.4f;
            this.field_70754_ba += this.field_70721_aZ;
        } else {
            this.field_70138_W = 0.5f;
            this.field_70747_aH = 0.02f;
            super.func_70612_e(strafe, forward);
        }
    }

    public float func_70689_ay() {
        double speed = this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e();
        speed += TalentHelper.addToMoveSpeed(this);
        if ((!(this.func_70638_az() instanceof EntityDog) && !(this.func_70638_az() instanceof EntityPlayer) || this.field_70153_n instanceof EntityPlayer) && this.levels.isDireDog()) {
            speed += 0.05;
        }
        if (this.field_70153_n instanceof EntityPlayer) {
            speed /= 4.0;
        }
        return (float)speed;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean getDogShaking() {
        return this.isShaking;
    }

    @SideOnly(value=Side.CLIENT)
    public float getShadingWhileShaking(float partialTickTime) {
        return 0.75f + (this.prevTimeDogIsShaking + (this.timeDogIsShaking - this.prevTimeDogIsShaking) * partialTickTime) / 2.0f * 0.25f;
    }

    @SideOnly(value=Side.CLIENT)
    public float getShakeAngle(float partialTickTime, float startTime) {
        float f2 = (this.prevTimeDogIsShaking + (this.timeDogIsShaking - this.prevTimeDogIsShaking) * partialTickTime + startTime) / 1.8f;
        if (f2 < 0.0f) {
            f2 = 0.0f;
        } else if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        return MathHelper.func_76126_a((float)(f2 * (float)Math.PI)) * MathHelper.func_76126_a((float)(f2 * (float)Math.PI * 11.0f)) * 0.15f * (float)Math.PI;
    }

    public boolean isImmortal() {
        return this.func_70909_n() && Constants.DOGS_IMMORTAL || this.levels.isDireDog();
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.8f;
    }

    @SideOnly(value=Side.CLIENT)
    public float getInterestedAngle(float partialTickTime) {
        return (this.prevTimeDogBegging + (this.timeDogBegging - this.prevTimeDogBegging) * partialTickTime) * 0.15f * (float)Math.PI;
    }

    public int func_70646_bf() {
        return this.func_70906_o() ? 20 : super.func_70646_bf();
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        PotionEffect potioneffect;
        float f2;
        int i;
        float[] ret = ForgeHooks.onLivingFall((EntityLivingBase)this, (float)distance, (float)damageMultiplier);
        if (ret == null) {
            return;
        }
        distance = ret[0];
        damageMultiplier = ret[1];
        if (this.field_70153_n != null) {
            this.field_70153_n.func_180430_e(distance, damageMultiplier);
        }
        if ((i = MathHelper.func_76123_f((float)((distance - 3.0f - (f2 = (potioneffect = this.func_70660_b(Potion.field_76430_j)) != null ? (float)(potioneffect.func_76458_c() + 1) : 0.0f) - (float)TalentHelper.fallProtection(this)) * damageMultiplier))) > 0 && !TalentHelper.isImmuneToFalls(this)) {
            this.func_85030_a(this.func_146067_o(i), 1.0f, 1.0f);
            this.func_70097_a(DamageSource.field_76379_h, i);
            int j = MathHelper.func_76128_c((double)this.field_70165_t);
            int k = MathHelper.func_76128_c((double)(this.field_70163_u - (double)0.2f));
            int l = MathHelper.func_76128_c((double)this.field_70161_v);
            Block block = this.field_70170_p.func_180495_p(new BlockPos(j, k, l)).func_177230_c();
            if (block.func_149688_o() != Material.field_151579_a) {
                Block.SoundType soundtype = block.field_149762_H;
                this.func_85030_a(soundtype.func_150498_e(), soundtype.func_150497_c() * 0.5f, soundtype.func_150494_d() * 0.75f);
            }
        }
    }

    public boolean func_70097_a(DamageSource damageSource, float damage) {
        if (this.func_180431_b(damageSource)) {
            return false;
        }
        if (!TalentHelper.attackEntityFrom(this, damageSource, damage)) {
            return false;
        }
        Entity entity = damageSource.func_76346_g();
        this.field_70911_d.func_75270_a(false);
        if (entity != null && !(entity instanceof EntityPlayer) && !(entity instanceof EntityArrow)) {
            damage = (damage + 1.0f) / 2.0f;
        }
        return super.func_70097_a(damageSource, damage);
    }

    public boolean func_70652_k(Entity entity) {
        if (!TalentHelper.shouldDamageMob(this, entity)) {
            return false;
        }
        int damage = 4 + (MathHelper.func_76128_c((double)this.effectiveLevel()) + 1) / 2;
        damage = TalentHelper.attackEntityAsMob(this, entity, damage);
        if (entity instanceof EntityZombie) {
            ((EntityZombie)entity).func_70624_b((EntityLivingBase)this);
        }
        return entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)damage);
    }

    public void func_70903_f(boolean p_70903_1_) {
        super.func_70903_f(p_70903_1_);
        if (p_70903_1_) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(8.0);
        }
    }

    public boolean func_70085_c(EntityPlayer player) {
        ItemStack stack = player.field_71071_by.func_70448_g();
        if (TalentHelper.interactWithPlayer(this, player)) {
            return true;
        }
        if (this.func_70909_n()) {
            if (stack != null) {
                int foodValue = this.foodValue(stack);
                if (foodValue != 0 && this.getDogHunger() < 120 && this.canInteract(player) && !this.isIncapacicated()) {
                    if (!player.field_71075_bZ.field_75098_d && --stack.field_77994_a <= 0) {
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, (ItemStack)null);
                    }
                    this.setDogHunger(this.getDogHunger() + foodValue);
                    return true;
                }
                if (stack.func_77973_b() == Items.field_151103_aS && this.canInteract(player)) {
                    if (!this.field_70170_p.field_72995_K) {
                        if (this.field_70154_o != null) {
                            this.func_70078_a(null);
                        } else {
                            this.func_70078_a((Entity)player);
                        }
                    }
                    return true;
                }
                if (stack.func_77973_b() == Items.field_151055_y && this.canInteract(player) && !this.isIncapacicated()) {
                    player.openGui((Object)DoggyTalentsMod.instance, 1, this.field_70170_p, this.func_145782_y(), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v));
                    return true;
                }
                if (stack.func_77973_b() == ModItems.radioCollar && this.canInteract(player) && !this.hasRadarCollar() && !this.isIncapacicated()) {
                    if (!player.field_71075_bZ.field_75098_d && --stack.field_77994_a <= 0) {
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, (ItemStack)null);
                    }
                    this.hasRadarCollar(true);
                    return true;
                }
                if (stack.func_77973_b() instanceof IDogTreat && this.canInteract(player) && !this.isIncapacicated()) {
                    IDogTreat treat = (IDogTreat)stack.func_77973_b();
                    IDogTreat.EnumFeedBack type = treat.canGiveToDog(player, this, this.levels.getLevel(), this.levels.getDireLevel());
                    treat.giveTreat(type, player, this);
                    return true;
                }
                if (stack.func_77973_b() == ModItems.collarShears && this.func_152114_e((EntityLivingBase)player)) {
                    if (!this.field_70170_p.field_72995_K) {
                        this.func_70903_f(false);
                        this.field_70699_by.func_75499_g();
                        this.func_70904_g(false);
                        this.func_70606_j(8.0f);
                        this.talents.resetTalents();
                        this.func_152115_b("");
                        this.setWillObeyOthers(false);
                        this.mode.setMode(ModeUtil.EnumMode.DOCILE);
                        if (this.hasRadarCollar()) {
                            this.func_145779_a(ModItems.radioCollar, 1);
                        }
                        this.hasRadarCollar(false);
                        this.reversionTime = 40;
                    }
                    return true;
                }
                if (stack.func_77973_b() == Items.field_151105_aU && this.canInteract(player) && this.isIncapacicated()) {
                    if (!player.field_71075_bZ.field_75098_d && --stack.field_77994_a <= 0) {
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, (ItemStack)null);
                    }
                    if (!this.field_70170_p.field_72995_K) {
                        this.field_70911_d.func_75270_a(true);
                        this.func_70606_j(this.func_110138_aP());
                        this.setDogHunger(120);
                        this.regenerationTick = 0;
                        this.func_70624_b(null);
                        this.func_70908_e(true);
                        this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                    }
                    return true;
                }
            }
            if (!this.field_70170_p.field_72995_K && !this.func_70877_b(stack) && this.canInteract(player)) {
                this.field_70911_d.func_75270_a(!this.func_70906_o());
                this.field_70703_bu = false;
                this.field_70699_by.func_75499_g();
                this.func_70624_b(null);
            }
        } else {
            if (stack != null && stack.func_77973_b() == ModItems.collarShears && this.reversionTime < 1 && !this.field_70170_p.field_72995_K) {
                this.func_70106_y();
                EntityWolf wolf = new EntityWolf(this.field_70170_p);
                wolf.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
                this.field_70170_p.func_72838_d((Entity)wolf);
                return true;
            }
            if (stack != null && stack.func_77973_b() == Items.field_151103_aS) {
                if (!player.field_71075_bZ.field_75098_d && --stack.field_77994_a <= 0) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, (ItemStack)null);
                }
                if (!this.field_70170_p.field_72995_K) {
                    if (this.field_70146_Z.nextInt(3) == 0) {
                        this.func_70903_f(true);
                        this.field_70699_by.func_75499_g();
                        this.func_70624_b(null);
                        this.field_70911_d.func_75270_a(true);
                        this.func_70606_j(20.0f);
                        this.func_152115_b(player.func_110124_au().toString());
                        this.func_70908_e(true);
                        this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                    } else {
                        this.func_70908_e(false);
                        this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                    }
                }
                return true;
            }
        }
        return super.func_70085_c(player);
    }

    protected boolean func_70610_aX() {
        return this.func_70608_bn() || this.field_70154_o != null || this.field_70153_n instanceof EntityPlayer || super.func_70610_aX();
    }

    public double func_70033_W() {
        return this.field_70154_o instanceof EntityPlayer ? 0.5 : 0.0;
    }

    public boolean func_70687_e(PotionEffect potionEffect) {
        if (this.isIncapacicated()) {
            return false;
        }
        return TalentHelper.isPostionApplicable(this, potionEffect);
    }

    public void func_70015_d(int amount) {
        if (TalentHelper.setFire(this, amount)) {
            super.func_70015_d(amount);
        }
    }

    public int foodValue(ItemStack stack) {
        ItemFood itemfood;
        if (stack == null || stack.func_77973_b() == null) {
            return 0;
        }
        int foodValue = 0;
        Item item = stack.func_77973_b();
        if (stack.func_77973_b() != Items.field_151078_bh && item instanceof ItemFood && (itemfood = (ItemFood)item).func_77845_h()) {
            foodValue = 40;
        }
        foodValue = TalentHelper.changeFoodValue(this, stack, foodValue);
        return foodValue;
    }

    public int masterOrder() {
        int order = 0;
        EntityPlayer player = (EntityPlayer)this.func_70902_q();
        if (player != null) {
            float distanceAway = player.func_70032_d((Entity)this);
            ItemStack itemstack = player.field_71071_by.func_70448_g();
            if (itemstack != null && itemstack.func_77973_b() instanceof ItemTool && distanceAway <= 20.0f) {
                order = 1;
            }
            if (itemstack != null && (itemstack.func_77973_b() instanceof ItemSword || itemstack.func_77973_b() instanceof ItemBow)) {
                order = 2;
            }
            if (itemstack != null && itemstack.func_77973_b() == Items.field_151015_O) {
                order = 3;
            }
        }
        return order;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte p_70103_1_) {
        if (p_70103_1_ == 8) {
            this.forceShake = true;
            this.timeDogIsShaking = 0.0f;
            this.prevTimeDogIsShaking = 0.0f;
        } else {
            super.func_70103_a(p_70103_1_);
        }
    }

    public float getWagAngle(float f, float f1) {
        float f2 = (this.prevTimeWolfIsHappy + (this.timeWolfIsHappy - this.prevTimeWolfIsHappy) * f + f1) / 2.0f;
        if (f2 < 0.0f) {
            f2 = 0.0f;
        } else if (f2 > 2.0f) {
            f2 %= 2.0f;
        }
        return MathHelper.func_76126_a((float)(f2 * (float)Math.PI * 11.0f)) * 0.3f * (float)Math.PI;
    }

    @SideOnly(value=Side.CLIENT)
    public float getTailRotation() {
        return this.func_70909_n() ? (0.55f - (this.func_110138_aP() - this.func_110143_aJ()) / (this.func_110138_aP() / 20.0f) * 0.02f) * (float)Math.PI : 0.62831855f;
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack != null && DoggyTalentsAPI.BREED_WHITELIST.containsItem(stack);
    }

    public boolean func_70608_bn() {
        return false;
    }

    public boolean func_70648_aU() {
        return TalentHelper.canBreatheUnderwater(this);
    }

    public boolean canInteract(EntityPlayer player) {
        return this.func_152114_e((EntityLivingBase)player) || this.willObeyOthers();
    }

    public int nourishment() {
        int amount = 0;
        if (this.getDogHunger() > 0) {
            amount = 40 + 4 * (MathHelper.func_76128_c((double)this.effectiveLevel()) + 1);
            if (this.func_70906_o() && this.talents.getLevel("quickhealer") == 5) {
                amount += 20 + 2 * (MathHelper.func_76128_c((double)this.effectiveLevel()) + 1);
            }
            if (!this.func_70906_o()) {
                amount *= 5 + this.talents.getLevel("quickhealer");
                amount /= 10;
            }
        }
        return amount;
    }

    public void func_70908_e(boolean successful) {
        super.func_70908_e(successful);
    }

    public double effectiveLevel() {
        return (double)(this.levels.getLevel() + this.levels.getDireLevel()) / 10.0;
    }

    public int getTameSkin() {
        return this.field_70180_af.func_75683_a(20);
    }

    public void setTameSkin(int index) {
        this.field_70180_af.func_75692_b(20, (Object)((byte)index));
    }

    public String getDogName() {
        return this.field_70180_af.func_75681_e(21);
    }

    public void setDogName(String var1) {
        this.field_70180_af.func_75692_b(21, (Object)var1);
    }

    public void setWillObeyOthers(boolean flag) {
        this.field_70180_af.func_75692_b(26, (Object)(flag ? 1 : 0));
    }

    public boolean willObeyOthers() {
        return this.field_70180_af.func_75679_c(26) != 0;
    }

    public int points() {
        return this.levels.getLevel() + this.levels.getDireLevel() + (this.levels.isDireDog() ? 15 : 0) + (this.func_70874_b() < 0 ? 0 : 15);
    }

    public int spendablePoints() {
        return this.points() - this.usedPoints();
    }

    public int usedPoints() {
        return TalentHelper.getUsedPoints(this);
    }

    public int deductive(int par1) {
        boolean byte0 = false;
        switch (par1) {
            case 1: {
                return 1;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 6;
            }
            case 4: {
                return 10;
            }
            case 5: {
                return 15;
            }
        }
        return 0;
    }

    public EntityDog createChild(EntityAgeable entityAgeable) {
        EntityDog entitydog = new EntityDog(this.field_70170_p);
        String uuid = this.func_152113_b();
        if (uuid != null && uuid.trim().length() > 0) {
            entitydog.func_152115_b(uuid);
            entitydog.func_70903_f(true);
        }
        entitydog.func_70873_a(-24000 * (Constants.TEN_DAY_PUPS ? 10 : 1));
        return entitydog;
    }

    public void setBegging(boolean flag) {
        this.field_70180_af.func_75692_b(19, (Object)((byte)(flag ? 1 : 0)));
    }

    public boolean isBegging() {
        return this.field_70180_af.func_75683_a(19) == 1;
    }

    public int getDogHunger() {
        return this.field_70180_af.func_75679_c(23);
    }

    public void setDogHunger(int par1) {
        this.field_70180_af.func_75692_b(23, (Object)MathHelper.func_76125_a((int)par1, (int)0, (int)120));
    }

    public void hasRadarCollar(boolean flag) {
        this.field_70180_af.func_75692_b(25, (Object)(flag ? 1 : 0));
    }

    public boolean hasRadarCollar() {
        return this.field_70180_af.func_75679_c(25) != 0;
    }

    public void setHasBone(boolean hasBone) {
        this.hasBone = hasBone;
    }

    public boolean hasBone() {
        return this.hasBone;
    }

    public boolean func_70878_b(EntityAnimal entityAnimal) {
        if (entityAnimal == this) {
            return false;
        }
        if (!this.func_70909_n()) {
            return false;
        }
        if (!(entityAnimal instanceof EntityDog)) {
            return false;
        }
        EntityDog entityDog = (EntityDog)entityAnimal;
        return !entityDog.func_70909_n() ? false : (entityDog.func_70906_o() ? false : this.func_70880_s() && entityDog.func_70880_s());
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public boolean func_142018_a(EntityLivingBase entityToAttack, EntityLivingBase owner) {
        if (TalentHelper.canAttackEntity(this, (Entity)entityToAttack)) {
            return true;
        }
        if (!(entityToAttack instanceof EntityCreeper) && !(entityToAttack instanceof EntityGhast)) {
            EntityDog entityDog;
            if (entityToAttack instanceof EntityDog && (entityDog = (EntityDog)entityToAttack).func_70909_n() && entityDog.func_70902_q() == owner) {
                return false;
            }
            return entityToAttack instanceof EntityPlayer && owner instanceof EntityPlayer && !((EntityPlayer)owner).func_96122_a((EntityPlayer)entityToAttack) ? false : !(entityToAttack instanceof EntityHorse) || !((EntityHorse)entityToAttack).func_110248_bS();
        }
        return false;
    }

    public boolean func_70686_a(Class p_70686_1_) {
        if (TalentHelper.canAttackClass(this, p_70686_1_)) {
            return true;
        }
        return super.func_70686_a(p_70686_1_);
    }

    public boolean isIncapacicated() {
        return Constants.DOGS_IMMORTAL && this.func_110143_aJ() <= 1.0f;
    }

    public boolean canRiderInteract() {
        return true;
    }

    public boolean shouldDismountInWater(Entity rider) {
        if (!TalentHelper.shouldDismountInWater(this, rider)) {
            return false;
        }
        return super.shouldDismountInWater(rider);
    }
}

