/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.entity;

import doggytalents.api.inferface.ITalent;
import doggytalents.entity.EntityDog;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;

public class TalentUtil {
    private EntityDog dog;
    private Map<String, Integer> dataMap;
    private String lastSaveString;

    public TalentUtil(EntityDog dog) {
        this.dog = dog;
        this.dataMap = new HashMap<String, Integer>();
        this.lastSaveString = "";
    }

    public void writeTalentsToNBT(NBTTagCompound tagCompound) {
        tagCompound.func_74778_a("talents", this.getSaveString());
    }

    public void readTalentsFromNBT(NBTTagCompound tagCompound) {
        this.dog.func_70096_w().func_75692_b(22, (Object)tagCompound.func_74779_i("talents"));
    }

    public String getSaveString() {
        String saveString = this.dog.func_70096_w().func_75681_e(22);
        return saveString == null ? "" : saveString;
    }

    public int getLevel(ITalent talent) {
        return this.getLevel(talent.getKey());
    }

    public int getLevel(String id) {
        String saveString = this.getSaveString();
        if (!this.lastSaveString.equals(saveString)) {
            this.dataMap.clear();
            String[] split = saveString.split(":");
            if (split.length % 2 == 0 && split.length > 0) {
                for (int i = 0; i < split.length; i += 2) {
                    this.dataMap.put(split[i], Integer.valueOf(split[i + 1]));
                }
            }
            this.lastSaveString = saveString;
        }
        if (!this.dataMap.containsKey(id)) {
            return 0;
        }
        int level = this.dataMap.get(id);
        return level;
    }

    public void setLevel(ITalent talent, int level) {
        this.setLevel(talent.getKey(), level);
    }

    public void setLevel(String id, int level) {
        if (level == this.getLevel(id)) {
            return;
        }
        this.dataMap.put(id, level);
        String saveString = "";
        boolean first = true;
        for (String key : this.dataMap.keySet()) {
            if (!first) {
                saveString = saveString + ":";
            }
            saveString = saveString + key + ":" + this.dataMap.get(key);
            first = false;
        }
        this.dog.func_70096_w().func_75692_b(22, (Object)saveString);
        this.dog.updateEntityAttributes();
    }

    public void resetTalents() {
        this.dataMap.clear();
        this.dog.func_70096_w().func_75692_b(22, (Object)"");
    }
}

