/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.helper;

import com.google.common.io.ByteStreams;
import com.google.gson.Gson;
import doggytalents.DoggyTalentsMod;
import doggytalents.helper.ChatHelper;
import doggytalents.helper.LogHelper;
import doggytalents.lib.Constants;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.event.HoverEvent;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ForgeVersion;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.versioning.DefaultArtifactVersion;
import net.minecraftforge.fml.relauncher.Side;

public class DoggyTalentsVersion {
    public static ForgeVersion.Status status = ForgeVersion.Status.PENDING;
    public static String recommendedVersion = "v1.9.1g";
    public static String linkVersion = null;
    public static boolean checkedVersion = false;

    public static void startVersionCheck() {
        if (!Constants.VERSION_CHECK) {
            return;
        }
        new Thread("Doggy Talents Version Check"){

            @Override
            public void run() {
                try {
                    String downloadLink = DoggyTalentsVersion.fetchDownloadLink(DoggyTalentsVersion.getUrlSource("http://www.mediafire.com/download/lh66wbyc9oxdc3r/version.json"));
                    URL url = new URL(downloadLink);
                    InputStream con = url.openStream();
                    String data = new String(ByteStreams.toByteArray((InputStream)con));
                    con.close();
                    Map json = (Map)new Gson().fromJson(data, Map.class);
                    Map versions = (Map)json.get("versions");
                    Map links = (Map)json.get("links");
                    String rec = (String)versions.get("1.8-recommended");
                    DefaultArtifactVersion current = new DefaultArtifactVersion("v1.9.1g");
                    if (rec != null) {
                        DefaultArtifactVersion recommended = new DefaultArtifactVersion(rec);
                        int diff = recommended.compareTo((Object)current);
                        if (diff == 0) {
                            status = ForgeVersion.Status.UP_TO_DATE;
                        } else if (diff < 0) {
                            status = ForgeVersion.Status.AHEAD;
                        } else {
                            status = ForgeVersion.Status.OUTDATED;
                            recommendedVersion = rec;
                            linkVersion = (String)links.get(rec);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    status = ForgeVersion.Status.FAILED;
                }
                LogHelper.info("Received version data: %s", status);
                String chat = String.format("A new %s version exists %s. Get it here: %s", "Doggy Talents", recommendedVersion, linkVersion);
                if (status == ForgeVersion.Status.OUTDATED) {
                    LogHelper.info(chat, new Object[0]);
                }
                Side side = FMLCommonHandler.instance().getEffectiveSide();
                while (!checkedVersion && side == Side.CLIENT) {
                    EntityPlayer player;
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    if (status != ForgeVersion.Status.OUTDATED || (player = DoggyTalentsMod.proxy.getPlayerEntity()) == null) continue;
                    IChatComponent link = ForgeHooks.newChatWithLinks((String)linkVersion);
                    link.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (IChatComponent)new ChatComponentText("Click to download!")));
                    link.func_150256_b().func_150238_a(EnumChatFormatting.YELLOW);
                    ChatComponentTranslation chatComponent = ChatHelper.getChatComponentTranslation("doggytalents.updatemessage", "Doggy Talents", recommendedVersion);
                    chatComponent.func_150256_b().func_150217_b(Boolean.valueOf(true));
                    player.func_145747_a((IChatComponent)chatComponent);
                    player.func_145747_a(link);
                    checkedVersion = true;
                }
            }
        }.start();
    }

    private static String getUrlSource(String spec) throws IOException {
        String inputLine;
        URL url = new URL(spec);
        URLConnection yc = url.openConnection();
        BufferedReader in = new BufferedReader(new InputStreamReader(yc.getInputStream(), "UTF-8"));
        String total = "";
        while ((inputLine = in.readLine()) != null) {
            total = total + inputLine;
        }
        in.close();
        return total;
    }

    private static String fetchDownloadLink(String str) {
        try {
            String regex = "(?=\\<)|(?<=\\>)";
            String[] data = str.split(regex);
            String found = "NOTFOUND";
            for (String dat : data) {
                if (!dat.contains("DLP_mOnDownload(this)")) continue;
                found = dat;
                break;
            }
            String wentthru = found.substring(found.indexOf("href=\"") + 6);
            wentthru = wentthru.substring(0, wentthru.indexOf("\""));
            return wentthru;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "ERROR";
        }
    }
}

